/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.dvb.DvbParam;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.ui.SettingComposite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DVBComposite
extends SettingComposite {
    private static final String FREQUENCY_CABLE = "618";
    private static final String FREQUENCY_SATELLITE = "3840";
    private static final String FREQUENCY_TERRESTRIAL = "474000";
    private static final String SYMBOLRATE_CABLE = "6875";
    private static final String SYMBOLRATE_SATELLITE = "27500";
    private static final String SINGLE_LOW_C = "5150";
    private static final String SINGLE_LOW_KU = "11300";
    private static final String SINGLE_LOW_KA = "17250";
    private static final String DUAL_LOW_C = "5150";
    private static final String DUAL_LOW_KU = "9750";
    private static final String DUAL_LOW_KA = "16750";
    private static final String DUAL_HIGH_C = "5750";
    private static final String DUAL_HIGH_KU = "10600";
    private static final String DUAL_HIGH_KA = "18000";
    private static final String TREBLE_LOW_KA = "16350";
    private static final String TREBLE_MID_KA = "17350";
    private static final String TREBLE_HIGH_KA = "18350";
    private static final String[] SIGNAL_TYPE = new String[]{DvbParam.SignalType.Cable.name(), DvbParam.SignalType.Satellite.name(), DvbParam.SignalType.DVB_T.name(), DvbParam.SignalType.DVB_T2.name(), DvbParam.SignalType.ISDB_T.name(), DvbParam.SignalType.ATSC_T.name(), DvbParam.SignalType.DTMB.name(), DvbParam.SignalType.J83B.name()};
    private Text textLowloFrep;
    private Text textHighloFrep;
    private Text textMidloFrep;
    private Text videoTxt;
    private Text audioTxt;
    private Combo comboSignalType;
    private Combo comboPolarization;
    private Combo comboLNBType;
    private Combo comboLNBBand;
    private Combo comboLNBPower;
    private Combo comboSwitch16port;
    private Combo comboSwitch4port;
    private Combo comboSwitch22K;
    private Combo comboVideoType;
    private Combo comboAudioType;
    private Text textCableFrequency;
    private Text textSatelliteFrequency;
    private Text textCableSymbolRate;
    private Text textSatelliteSymbolRate;
    private Combo comboCableQAMType;
    private Text textTerrestrialFrequency;
    private Combo comboTerrestrialQAMType;
    private Text textBandWidth;
    private Combo comboChannelMode;
    private Combo comboDVBTPrio;
    private Group comCable;
    private Group comSatellite;
    private Group comTerrestrial;
    private int oldSignalType;

    public DVBComposite(Composite parent, Setting setting) {
        super(parent, setting);
    }

    @Override
    public PrepareSetting getSetting() {
        return (PrepareSetting)super.getSetting();
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout fatherGrid = new GridLayout(1, false);
        fatherGrid.marginHeight = 20;
        fatherGrid.verticalSpacing = 20;
        control.setLayout((Layout)fatherGrid);
        Group group = new Group(control, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.DVBComposite_12);
        this.fillHorizontal((Control)group);
        Composite composite = new Composite((Composite)group, 0);
        GridLayout paramLayout = new GridLayout(2, false);
        composite.setLayout((Layout)paramLayout);
        this.fillHorizontal((Control)composite);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setText(Messages.DVBComposite_13);
        this.comboSignalType = new Combo(composite, 8);
        this.comboSignalType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVBComposite.this.updateDVBParamComposite(((Combo)e.getSource()).getSelectionIndex(), group);
            }
        });
        this.comboSignalType.setItems(SIGNAL_TYPE);
        this.comboSignalType.select(DvbParam.SignalType.Satellite.ordinal());
        this.setOldSignalType(DvbParam.SignalType.Satellite.ordinal());
        GridData data = new GridData();
        this.comboSignalType.setLayoutData((Object)data);
        this.createDVBSatellite(group);
        this.createVideoAndAudioGroup(control);
        return control;
    }

    private void createDVBSatellite(Group parent) {
        this.comSatellite = new Group((Composite)parent, 0);
        this.comSatellite.setText("Satellite");
        this.comSatellite.setBackground(parent.getBackground());
        GridLayout comSatelliteGL = new GridLayout(6, false);
        comSatelliteGL.marginWidth = 20;
        comSatelliteGL.horizontalSpacing = 30;
        this.comSatellite.setLayout((Layout)comSatelliteGL);
        this.fillHorizontal((Control)this.comSatellite);
        Label lblFrep = new Label((Composite)this.comSatellite, 0);
        lblFrep.setText(Messages.DVBComposite_14);
        lblFrep.setBackground(parent.getBackground());
        this.textSatelliteFrequency = new Text((Composite)this.comSatellite, 2048);
        this.textSatelliteFrequency.setText(FREQUENCY_SATELLITE);
        this.textSatelliteFrequency.setTextLimit(8);
        this.fillHorizontal((Control)this.textSatelliteFrequency);
        DVBComposite.addModifyListene(this.textSatelliteFrequency);
        Label lblSimbol = new Label((Composite)this.comSatellite, 0);
        lblSimbol.setText(Messages.DVBComposite_15);
        lblSimbol.setBackground(parent.getBackground());
        this.textSatelliteSymbolRate = new Text((Composite)this.comSatellite, 2048);
        this.textSatelliteSymbolRate.setText(SYMBOLRATE_SATELLITE);
        this.textSatelliteSymbolRate.setTextLimit(8);
        this.fillHorizontal((Control)this.textSatelliteSymbolRate);
        DVBComposite.addModifyListene(this.textSatelliteSymbolRate);
        Label lblPo = new Label((Composite)this.comSatellite, 0);
        lblPo.setText(Messages.DVBComposite_17);
        lblPo.setBackground(parent.getBackground());
        this.comboPolarization = new Combo((Composite)this.comSatellite, 8);
        this.comboPolarization.setItems(new String[]{"Horizontal", "Vertical", "Left Circular", "Right Circular"});
        this.comboPolarization.select(0);
        this.fillHorizontal((Control)this.comboPolarization);
        Label lblLnbType = new Label((Composite)this.comSatellite, 0);
        lblLnbType.setText(Messages.DVBComposite_18);
        lblLnbType.setBackground(parent.getBackground());
        this.comboLNBType = new Combo((Composite)this.comSatellite, 8);
        this.comboLNBType.setItems(new String[]{"Single", "Dual", "Treble"});
        this.comboLNBType.select(1);
        this.comboLNBType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVBComposite.this.handleLNBListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fillHorizontal((Control)this.comboLNBType);
        Label lblLnbBand = new Label((Composite)this.comSatellite, 0);
        lblLnbBand.setText(Messages.DVBComposite_19);
        lblLnbBand.setBackground(parent.getBackground());
        this.comboLNBBand = new Combo((Composite)this.comSatellite, 8);
        this.comboLNBBand.setItems(new String[]{"BAND_C", "BAND_KU", "BAND_KA"});
        this.comboLNBBand.select(0);
        this.comboLNBBand.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVBComposite.this.handleLNBListener();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fillHorizontal((Control)this.comboLNBBand);
        Label lblLnbPwoer = new Label((Composite)this.comSatellite, 0);
        lblLnbPwoer.setText(Messages.DVBComposite_22);
        lblLnbPwoer.setBackground(parent.getBackground());
        this.comboLNBPower = new Combo((Composite)this.comSatellite, 8);
        this.comboLNBPower.setItems(new String[]{"Off", "On", "Enhanced"});
        this.comboLNBPower.select(1);
        this.fillHorizontal((Control)this.comboLNBPower);
        Label lblLowlo = new Label((Composite)this.comSatellite, 0);
        lblLowlo.setText(Messages.DVBComposite_20);
        lblLowlo.setBackground(parent.getBackground());
        this.textLowloFrep = new Text((Composite)this.comSatellite, 2048);
        this.textLowloFrep.setText("5150");
        this.textLowloFrep.setTextLimit(8);
        DVBComposite.addModifyListene(this.textLowloFrep);
        this.fillHorizontal((Control)this.textLowloFrep);
        Label lblHg = new Label((Composite)this.comSatellite, 0);
        lblHg.setText(Messages.DVBComposite_21);
        lblHg.setBackground(parent.getBackground());
        this.textHighloFrep = new Text((Composite)this.comSatellite, 2048);
        this.textHighloFrep.setText(DUAL_HIGH_C);
        this.textHighloFrep.setTextLimit(8);
        DVBComposite.addModifyListene(this.textHighloFrep);
        this.fillHorizontal((Control)this.textHighloFrep);
        Label lblMid = new Label((Composite)this.comSatellite, 0);
        lblMid.setText(Messages.DVBComposite_Middle_Frep);
        lblMid.setBackground(parent.getBackground());
        this.textMidloFrep = new Text((Composite)this.comSatellite, 2048);
        this.textMidloFrep.setText(TREBLE_MID_KA);
        this.textMidloFrep.setTextLimit(8);
        this.textMidloFrep.setEnabled(false);
        DVBComposite.addModifyListene(this.textMidloFrep);
        this.fillHorizontal((Control)this.textMidloFrep);
        Label lblSwitch = new Label((Composite)this.comSatellite, 0);
        lblSwitch.setText(Messages.DVBComposite_23);
        lblSwitch.setBackground(parent.getBackground());
        lblSwitch.setVisible(false);
        this.comboSwitch16port = new Combo((Composite)this.comSatellite, 8);
        this.comboSwitch16port.setItems(new String[]{"NONE", "PORT_1", "PORT_2", "PORT_3", "PORT_4", "PORT_5", "PORT_6", "PORT_7", "PORT_8", "PORT_9", "PORT_10", "PORT_11", "PORT_12", "PORT_13", "PORT_14", "PORT_15", "PORT_16"});
        this.comboSwitch16port.select(0);
        this.comboSwitch16port.setVisible(false);
        this.fillHorizontal((Control)this.comboSwitch16port);
        Label lblSwitchport = new Label((Composite)this.comSatellite, 0);
        lblSwitchport.setText(Messages.DVBComposite_24);
        lblSwitchport.setBackground(parent.getBackground());
        lblSwitchport.setVisible(false);
        this.comboSwitch4port = new Combo((Composite)this.comSatellite, 8);
        this.comboSwitch4port.setItems(new String[]{"NONE", "PORT_1", "PORT_2", "PORT_3", "PORT_4"});
        this.comboSwitch4port.select(0);
        this.comboSwitch4port.setVisible(false);
        this.fillHorizontal((Control)this.comboSwitch4port);
        Label lblSwitchk = new Label((Composite)this.comSatellite, 0);
        lblSwitchk.setText(Messages.DVBComposite_25);
        lblSwitchk.setBackground(parent.getBackground());
        lblSwitchk.setVisible(false);
        this.comboSwitch22K = new Combo((Composite)this.comSatellite, 8);
        this.comboSwitch22K.setItems(new String[]{"NONE", "22K_0", "22K_22"});
        this.comboSwitch22K.select(0);
        this.comboSwitch22K.setVisible(false);
        this.fillHorizontal((Control)this.comboSwitch22K);
    }

    private void createDVBCable(Group parent) {
        this.comCable = new Group((Composite)parent, 0);
        this.comCable.setText("Cable");
        this.comCable.setBackground(parent.getBackground());
        GridLayout comCableGL = new GridLayout(6, false);
        comCableGL.marginWidth = 20;
        comCableGL.horizontalSpacing = 30;
        this.comCable.setLayout((Layout)comCableGL);
        this.fillHorizontal((Control)this.comCable);
        Label lblFrep = new Label((Composite)this.comCable, 0);
        lblFrep.setText(Messages.DVBComposite_14);
        lblFrep.setBackground(parent.getBackground());
        this.textCableFrequency = new Text((Composite)this.comCable, 2048);
        this.textCableFrequency.setText(FREQUENCY_CABLE);
        this.textCableFrequency.setTextLimit(8);
        this.fillHorizontal((Control)this.textCableFrequency);
        DVBComposite.addModifyListene(this.textCableFrequency);
        Label lblSimbol = new Label((Composite)this.comCable, 0);
        lblSimbol.setText(Messages.DVBComposite_15);
        lblSimbol.setBackground(parent.getBackground());
        this.textCableSymbolRate = new Text((Composite)this.comCable, 2048);
        this.textCableSymbolRate.setText(SYMBOLRATE_CABLE);
        this.textCableSymbolRate.setTextLimit(8);
        this.fillHorizontal((Control)this.textCableSymbolRate);
        DVBComposite.addModifyListene(this.textCableSymbolRate);
        Label lblQamType = new Label((Composite)this.comCable, 0);
        lblQamType.setText(Messages.DVBComposite_16);
        lblQamType.setBackground(parent.getBackground());
        this.comboCableQAMType = new Combo((Composite)this.comCable, 8);
        this.comboCableQAMType.setItems(new String[]{"QAM-16", "QAM-32", "QAM-64", "QAM-128", "QAM-256"});
        this.comboCableQAMType.select(2);
        this.fillHorizontal((Control)this.comboCableQAMType);
    }

    private void createDVBTerrestrial(Group parent) {
        this.comTerrestrial = new Group((Composite)parent, 0);
        this.comTerrestrial.setText("Terrestrial");
        this.comTerrestrial.setBackground(parent.getBackground());
        GridLayout comTerrestrialGL = new GridLayout(6, false);
        comTerrestrialGL.marginWidth = 20;
        comTerrestrialGL.horizontalSpacing = 30;
        this.comTerrestrial.setLayout((Layout)comTerrestrialGL);
        this.fillHorizontal((Control)this.comTerrestrial);
        Label lblFrep = new Label((Composite)this.comTerrestrial, 0);
        lblFrep.setText(Messages.DVBComposite_TerrestrialFrequency);
        lblFrep.setBackground(parent.getBackground());
        this.textTerrestrialFrequency = new Text((Composite)this.comTerrestrial, 2048);
        this.textTerrestrialFrequency.setText(FREQUENCY_TERRESTRIAL);
        this.textTerrestrialFrequency.setTextLimit(8);
        this.fillHorizontal((Control)this.textTerrestrialFrequency);
        DVBComposite.addModifyListene(this.textTerrestrialFrequency);
        Label lblBandWidth = new Label((Composite)this.comTerrestrial, 0);
        lblBandWidth.setText(Messages.DVBComposite_BandWidth);
        lblBandWidth.setBackground(parent.getBackground());
        this.textBandWidth = new Text((Composite)this.comTerrestrial, 2048);
        this.textBandWidth.setText("8000");
        this.textBandWidth.setTextLimit(8);
        this.fillHorizontal((Control)this.textBandWidth);
        DVBComposite.addModifyListene(this.textBandWidth);
        Label lblQamType = new Label((Composite)this.comTerrestrial, 0);
        lblQamType.setText(Messages.DVBComposite_16);
        lblQamType.setBackground(parent.getBackground());
        this.comboTerrestrialQAMType = new Combo((Composite)this.comTerrestrial, 8);
        this.comboTerrestrialQAMType.setItems(new String[]{"QAM-16", "QAM-32", "QAM-64", "QAM-128", "QAM-256"});
        this.comboTerrestrialQAMType.select(2);
        this.fillHorizontal((Control)this.comboTerrestrialQAMType);
        Label lblChannelMode = new Label((Composite)this.comTerrestrial, 0);
        lblChannelMode.setText(Messages.DVBComposite_ChannelMode);
        lblChannelMode.setToolTipText(Messages.DVBComposite_ChannelMode_TipText);
        lblChannelMode.setBackground(parent.getBackground());
        this.comboChannelMode = new Combo((Composite)this.comTerrestrial, 8);
        this.comboChannelMode.setItems(new String[]{"Base", "Lite"});
        this.comboChannelMode.select(0);
        this.fillHorizontal((Control)this.comboChannelMode);
        Label lblDVBTPrio = new Label((Composite)this.comTerrestrial, 0);
        lblDVBTPrio.setText(Messages.DVBComposite_DVBTPrio);
        lblDVBTPrio.setToolTipText(Messages.DVBComposite_DVBTPrio_TipText);
        lblDVBTPrio.setBackground(parent.getBackground());
        this.comboDVBTPrio = new Combo((Composite)this.comTerrestrial, 8);
        this.comboDVBTPrio.setItems(new String[]{"HP", "LP"});
        this.comboDVBTPrio.select(0);
        this.fillHorizontal((Control)this.comboDVBTPrio);
    }

    private void createVideoAndAudioGroup(Composite control) {
        Group group_1 = new Group(control, 0);
        group_1.setText(Messages.DVBComposite_30);
        GridLayout bottmLayout = new GridLayout(4, false);
        bottmLayout.marginWidth = 20;
        bottmLayout.marginHeight = 20;
        bottmLayout.horizontalSpacing = 30;
        group_1.setLayout((Layout)bottmLayout);
        this.fillHorizontal((Control)group_1);
        Label lblVideo = new Label((Composite)group_1, 0);
        lblVideo.setText(Messages.DVBComposite_26);
        this.videoTxt = new Text((Composite)group_1, 2048);
        this.videoTxt.setText("512");
        this.videoTxt.setTextLimit(4);
        DVBComposite.addModifyListene(this.videoTxt);
        this.fillHorizontal((Control)this.videoTxt);
        Label lblVideoType = new Label((Composite)group_1, 0);
        lblVideoType.setText(Messages.DVBComposite_28);
        this.comboVideoType = new Combo((Composite)group_1, 8);
        this.comboVideoType.setItems(new String[]{"MPG2", "MPG4", "H264", "H265"});
        this.comboVideoType.select(0);
        this.fillHorizontal((Control)this.comboVideoType);
        Label lblAudioPid = new Label((Composite)group_1, 0);
        lblAudioPid.setText(Messages.DVBComposite_27);
        this.audioTxt = new Text((Composite)group_1, 2048);
        this.audioTxt.setText("650");
        this.audioTxt.setTextLimit(4);
        this.fillHorizontal((Control)this.audioTxt);
        DVBComposite.addModifyListene(this.audioTxt);
        Label lblAudioType = new Label((Composite)group_1, 0);
        lblAudioType.setText(Messages.DVBComposite_29);
        this.comboAudioType = new Combo((Composite)group_1, 8);
        this.comboAudioType.setItems(new String[]{"MP3", "MP2"});
        this.comboAudioType.select(0);
        this.fillHorizontal((Control)this.comboAudioType);
    }

    private void updateDVBParamComposite(int select, Group parent) {
        if (select == this.getOldSignalType()) {
            return;
        }
        if (select == DvbParam.SignalType.Cable.ordinal() || select == DvbParam.SignalType.J83B.ordinal()) {
            this.setDispose((Composite)this.comCable);
            this.setDispose((Composite)this.comSatellite);
            this.setDispose((Composite)this.comTerrestrial);
            this.createDVBCable(parent);
        } else if (select == DvbParam.SignalType.Satellite.ordinal()) {
            this.setDispose((Composite)this.comCable);
            this.setDispose((Composite)this.comTerrestrial);
            this.createDVBSatellite(parent);
        } else {
            this.setDispose((Composite)this.comCable);
            this.setDispose((Composite)this.comSatellite);
            this.setDispose((Composite)this.comTerrestrial);
            this.createDVBTerrestrial(parent);
        }
        this.setOldSignalType(select);
        parent.redraw();
        parent.layout();
        parent.getParent().layout();
    }

    private void setDispose(Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            composite.dispose();
        }
    }

    private boolean checkControlVaild(Control control) {
        return control != null && !control.isDisposed();
    }

    @Override
    protected Object getParam() {
        boolean isCable;
        DvbParam dvbParam = new DvbParam();
        int selectSignalType = this.comboSignalType.getSelectionIndex();
        dvbParam.setSingleType(this.comboSignalType.getSelectionIndex());
        boolean bl = isCable = selectSignalType == DvbParam.SignalType.Cable.ordinal() || selectSignalType == DvbParam.SignalType.J83B.ordinal();
        if (isCable) {
            this.setCableParam(dvbParam);
        } else if (selectSignalType == DvbParam.SignalType.Satellite.ordinal()) {
            this.setSatelliteParam(dvbParam);
        } else {
            this.setTerrestrialParam(dvbParam);
        }
        try {
            this.setCommonParams(dvbParam);
            this.setTerrestrialParams(dvbParam);
            this.getSetting().setParamObj(dvbParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return dvbParam;
    }

    private void setTerrestrialParams(DvbParam dvbParam) {
        if (this.checkControlVaild((Control)this.textBandWidth)) {
            dvbParam.setBandWidth(Integer.parseInt(this.textBandWidth.getText()));
        }
        if (this.checkControlVaild((Control)this.comboChannelMode)) {
            dvbParam.setChannelMode(this.comboChannelMode.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboDVBTPrio)) {
            dvbParam.setDvbTPrio(this.comboDVBTPrio.getSelectionIndex());
        }
    }

    private void setCommonParams(DvbParam dvbParam) {
        if (this.checkControlVaild((Control)this.comboPolarization)) {
            dvbParam.setPolarization(this.comboPolarization.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboLNBType)) {
            dvbParam.setLnbType(this.comboLNBType.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboLNBBand)) {
            dvbParam.setLnbBand(this.comboLNBBand.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.textLowloFrep)) {
            dvbParam.setLowloFrep(Integer.parseInt(this.textLowloFrep.getText()));
        }
        if (this.checkControlVaild((Control)this.textHighloFrep)) {
            dvbParam.setHighloFrep(Integer.parseInt(this.textHighloFrep.getText()));
        }
        if (this.checkControlVaild((Control)this.comboLNBPower)) {
            dvbParam.setLnbPower(this.comboLNBPower.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboSwitch16port)) {
            dvbParam.setSwitch16Port(this.comboSwitch16port.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboSwitch4port)) {
            dvbParam.setSwitch4Port(this.comboSwitch4port.getSelectionIndex());
        }
        if (this.checkControlVaild((Control)this.comboSwitch22K)) {
            dvbParam.setSwitch22k(this.comboSwitch22K.getSelectionIndex());
        }
        dvbParam.setVideoId(Integer.parseInt(this.videoTxt.getText()));
        dvbParam.setVideoType(this.comboVideoType.getSelectionIndex());
        dvbParam.setAudioId(Integer.parseInt(this.audioTxt.getText()));
        dvbParam.setAudioType(this.comboAudioType.getSelectionIndex());
    }

    private void setTerrestrialParam(DvbParam dvbParam) {
        if (this.checkControlVaild((Control)this.textTerrestrialFrequency)) {
            String textFrequencyValue = this.textTerrestrialFrequency.getText();
            dvbParam.setFreq(Integer.parseInt(textFrequencyValue));
        }
        if (this.checkControlVaild((Control)this.comboTerrestrialQAMType)) {
            int comboQAMTypeValue = this.comboTerrestrialQAMType.getSelectionIndex();
            dvbParam.setQamType(comboQAMTypeValue);
        }
    }

    private void setSatelliteParam(DvbParam dvbParam) {
        if (this.checkControlVaild((Control)this.textSatelliteFrequency)) {
            String textFrequencyValue = this.textSatelliteFrequency.getText();
            dvbParam.setFreq(Integer.parseInt(textFrequencyValue));
        }
        if (this.checkControlVaild((Control)this.textSatelliteSymbolRate)) {
            String textSymbolRateValue = this.textSatelliteSymbolRate.getText();
            dvbParam.setSymbolRate(Integer.parseInt(textSymbolRateValue));
        }
    }

    private void setCableParam(DvbParam dvbParam) {
        if (this.checkControlVaild((Control)this.textCableFrequency)) {
            String textFrequencyValue = this.textCableFrequency.getText();
            dvbParam.setFreq(Integer.parseInt(textFrequencyValue));
        }
        if (this.checkControlVaild((Control)this.textCableSymbolRate)) {
            String textSymbolRateValue = this.textCableSymbolRate.getText();
            dvbParam.setSymbolRate(Integer.parseInt(textSymbolRateValue));
        }
        if (this.checkControlVaild((Control)this.comboCableQAMType)) {
            int comboQAMTypeValue = this.comboCableQAMType.getSelectionIndex();
            dvbParam.setQamType(comboQAMTypeValue);
        }
    }

    private void handleLNBListener() {
        if (this.checkControlVaild((Control)this.comboLNBType)) {
            if (this.comboLNBType.getSelectionIndex() == 0) {
                this.setLNBTypeSingle();
            } else if (this.comboLNBType.getSelectionIndex() == 1) {
                this.setLNBTypeDual();
            } else {
                this.setLNBTypeTreble();
            }
        }
    }

    private void setLNBTypeTreble() {
        if (this.checkControlVaild((Control)this.comboLNBBand)) {
            this.comboLNBBand.select(2);
        }
        if (this.checkControlVaild((Control)this.textLowloFrep)) {
            this.textLowloFrep.setEnabled(true);
            this.textLowloFrep.setText(TREBLE_LOW_KA);
        }
        if (this.checkControlVaild((Control)this.textMidloFrep)) {
            this.textMidloFrep.setEnabled(true);
            this.textMidloFrep.setText(TREBLE_MID_KA);
        }
        if (this.checkControlVaild((Control)this.textHighloFrep)) {
            this.textHighloFrep.setEnabled(true);
            this.textHighloFrep.setText(TREBLE_HIGH_KA);
        }
    }

    private void setLNBTypeDual() {
        if (this.checkControlVaild((Control)this.textLowloFrep)) {
            this.textLowloFrep.setEnabled(true);
            if (this.checkControlVaild((Control)this.comboLNBBand)) {
                if (this.comboLNBBand.getSelectionIndex() == 0) {
                    this.textLowloFrep.setText("5150");
                } else if (this.comboLNBBand.getSelectionIndex() == 1) {
                    this.textLowloFrep.setText(DUAL_LOW_KU);
                } else {
                    this.textLowloFrep.setText(DUAL_LOW_KA);
                }
            }
        }
        if (this.checkControlVaild((Control)this.textMidloFrep)) {
            this.textMidloFrep.setEnabled(false);
        }
        if (this.checkControlVaild((Control)this.textHighloFrep)) {
            this.textHighloFrep.setEnabled(true);
            if (this.checkControlVaild((Control)this.comboLNBBand)) {
                if (this.comboLNBBand.getSelectionIndex() == 0) {
                    this.textHighloFrep.setText(DUAL_HIGH_C);
                } else if (this.comboLNBBand.getSelectionIndex() == 1) {
                    this.textHighloFrep.setText(DUAL_HIGH_KU);
                } else {
                    this.textHighloFrep.setText(DUAL_HIGH_KA);
                }
            }
        }
    }

    private void setLNBTypeSingle() {
        if (this.checkControlVaild((Control)this.textLowloFrep)) {
            this.textLowloFrep.setEnabled(true);
            if (this.checkControlVaild((Control)this.comboLNBBand)) {
                if (this.comboLNBBand.getSelectionIndex() == 0) {
                    this.textLowloFrep.setText("5150");
                } else if (this.comboLNBBand.getSelectionIndex() == 1) {
                    this.textLowloFrep.setText(SINGLE_LOW_KU);
                } else {
                    this.textLowloFrep.setText(SINGLE_LOW_KA);
                }
            }
        }
        if (this.checkControlVaild((Control)this.textMidloFrep)) {
            this.textMidloFrep.setEnabled(false);
        }
        if (this.checkControlVaild((Control)this.textHighloFrep)) {
            this.textHighloFrep.setEnabled(false);
        }
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        return true;
    }

    @Override
    protected boolean checkAllTextValue() {
        int selectSignalType = this.comboSignalType.getSelectionIndex();
        if (selectSignalType == 0) {
            if (this.textCableFrequency != null && !this.textCableFrequency.isDisposed() && !this.checkTextValue(this.textCableFrequency)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Frequency) + Messages.BaseComposite_EnterInvalidNumbers));
                return false;
            }
            if (this.textCableSymbolRate != null && !this.textCableSymbolRate.isDisposed() && !this.checkTextValue(this.textCableSymbolRate)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_SymbolRate) + Messages.BaseComposite_EnterInvalidNumbers));
                return false;
            }
        } else if (selectSignalType == 1) {
            if (this.textSatelliteFrequency != null && !this.textSatelliteFrequency.isDisposed() && !this.checkTextValue(this.textSatelliteFrequency)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Frequency) + Messages.BaseComposite_EnterInvalidNumbers));
                return false;
            }
            if (this.textSatelliteSymbolRate != null && !this.textSatelliteSymbolRate.isDisposed() && !this.checkTextValue(this.textSatelliteSymbolRate)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_SymbolRate) + Messages.BaseComposite_EnterInvalidNumbers));
                return false;
            }
        } else if (this.textTerrestrialFrequency != null && !this.textTerrestrialFrequency.isDisposed() && !this.checkTextValue(this.textTerrestrialFrequency)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Frequency) + Messages.BaseComposite_EnterInvalidNumbers));
            return false;
        }
        if (!this.textLowloFrep.isDisposed() && !this.checkTextValue(this.textLowloFrep)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_LNBPower) + Messages.BaseComposite_EnterInvalidNumbers));
            return false;
        }
        if (!this.textHighloFrep.isDisposed() && !this.checkTextValue(this.textHighloFrep)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_HighloFrep) + Messages.BaseComposite_EnterInvalidNumbers));
            return false;
        }
        if (!this.videoTxt.isDisposed() && !this.checkTextValue(this.videoTxt, 0, 8192)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_VideoPID) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(8192))));
            return false;
        }
        if (!this.audioTxt.isDisposed() && !this.checkTextValue(this.audioTxt, 0, 8192)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_AudioPID) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(8192))));
            return false;
        }
        return true;
    }

    public int getOldSignalType() {
        return this.oldSignalType;
    }

    public void setOldSignalType(int oldSignalType) {
        this.oldSignalType = oldSignalType;
    }
}

