/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.HI_UNF_MCE;
import com.hisilicon.fastplay.model.baseparam.MipiModeObj;
import com.hisilicon.fastplay.model.baseparam.MipiPanelCmdObj;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DispMipiDialog
extends Dialog {
    private static final int totalControlCount = 30;
    private static final int width = 1266;
    private static final int height = 280;
    private static final int BPP_MIM_VOLUME = 128;
    private static final int BPP_MAX_VOLUME = 575;
    private static final int BRI_PERCENT_MAX_VOLUME = 100;
    private static final int ARG_COUNT_MAX_VOLUME = 24;
    private static final int VALUE_MAX_VOLUME = 24;
    static final int CMD_NUMBER_INIT = 3;
    private MipiModeObj mipiModeObj;
    private Pattern patten = Pattern.compile("^[0-9]*$");
    private Pattern pattenHex = Pattern.compile("^[0-f]*$");
    private Composite parent;
    private Composite panelCmdComposite;
    private Combo comboChannel0;
    private Combo comboChannel1;
    private Combo comboChannel2;
    private Combo comboChannel3;
    private Combo comboOutputMode;
    private Combo comboVideoMode;
    private Combo comboMipiMode;
    private Text textBpp;
    private Text textBriPercent;
    private ArrayList<Text> textArgCountList = new ArrayList();
    private List<ArrayList<Text>> mipiPanelCmdObjTextList = new ArrayList<ArrayList<Text>>();
    static final short[] CHANNEL_LIST_INIT = new short[]{1, 2, 3, 4};
    private static final String[] CMD_NEUMBER_VALUE_LIST = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
    private int cmdNumber;

    protected DispMipiDialog(Shell comShell, MipiModeObj mipiModeObj) {
        super(comShell);
        this.mipiModeObj = mipiModeObj;
    }

    protected Control createContents(Composite parent) {
        this.parent = parent;
        parent.getShell().setText("MIPI Set");
        parent.setSize(1266, 280 + this.mipiModeObj.getCmdNumber() * 29);
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(8, true));
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.comboChannel0 = this.createCombo(composite, Messages.BaseparamComposite_mipi_Channel0, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_LENE_ID_E.values()), this.mipiModeObj.getLaneIdList()[0]);
        this.comboChannel1 = this.createCombo(composite, Messages.BaseparamComposite_mipi_Channel1, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_LENE_ID_E.values()), this.mipiModeObj.getLaneIdList()[1]);
        this.comboChannel2 = this.createCombo(composite, Messages.BaseparamComposite_mipi_Channel2, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_LENE_ID_E.values()), this.mipiModeObj.getLaneIdList()[2]);
        this.comboChannel3 = this.createCombo(composite, Messages.BaseparamComposite_mipi_Channel3, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_LENE_ID_E.values()), this.mipiModeObj.getLaneIdList()[3]);
        this.comboOutputMode = this.createCombo(composite, Messages.BaseparamComposite_mipi_outputmode, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_VIDEO_MODE_E.values()), this.mipiModeObj.getOutputMode());
        this.comboVideoMode = this.createCombo(composite, Messages.BaseparamComposite_mipi_videomode, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_OUTPUT_MODE_E.values()), this.mipiModeObj.getVideoMode());
        this.comboMipiMode = this.createCombo(composite, Messages.BaseparamComposite_mipi_mipimode, HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_MIPI_MIPI_MODE_E.values()), this.mipiModeObj.getMipiMode());
        Label labelBpp = new Label(composite, 0);
        labelBpp.setText(String.valueOf(Messages.BaseparamComposite_mipi_bpp) + ":");
        this.fillHorizontal((Control)labelBpp);
        this.textBpp = new Text(composite, 2048);
        this.textBpp.setTextLimit(3);
        this.textBpp.setText(String.valueOf(this.mipiModeObj.getBpp()));
        this.addModifyListene(this.textBpp, false);
        this.fillHorizontal((Control)this.textBpp);
        Label labelBripercent = new Label(composite, 0);
        labelBripercent.setText(String.valueOf(Messages.BaseparamComposite_mipi_bripercent) + ":");
        this.fillHorizontal((Control)labelBripercent);
        this.textBriPercent = new Text(composite, 2048);
        this.textBriPercent.setTextLimit(3);
        this.textBriPercent.setText(String.valueOf(this.mipiModeObj.getBriPercent()));
        this.addModifyListene(this.textBriPercent, false);
        this.fillHorizontal((Control)this.textBriPercent);
        Label labelNumber = new Label(composite, 0);
        labelNumber.setText("CMD Number:");
        this.fillHorizontal((Control)labelNumber);
        Combo comboNumber = new Combo(composite, 8);
        comboNumber.setItems(CMD_NEUMBER_VALUE_LIST);
        comboNumber.setTextLimit(2);
        GridData comboGD = new GridData(1, 1, false, false);
        comboGD.widthHint = 55;
        comboNumber.setLayoutData((Object)comboGD);
        comboNumber.select(this.mipiModeObj.getCmdNumber());
        this.cmdNumber = this.mipiModeObj.getCmdNumber();
        this.fillHorizontal((Control)comboNumber);
        comboNumber.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int number = Integer.parseInt(comboNumber.getText());
                if (DispMipiDialog.this.cmdNumber != number) {
                    DispMipiDialog.this.disposeAllControl();
                    parent.setSize(1266, 280 + number * 28);
                    DispMipiDialog.this.mipiModeObj.setCmdNumber(number);
                    MipiPanelCmdObj[] cmdObjList = new MipiPanelCmdObj[number];
                    int index = 0;
                    while (index < number) {
                        cmdObjList[index] = new MipiPanelCmdObj();
                        ++index;
                    }
                    DispMipiDialog.this.mipiModeObj.setMipiPanelCmdObj(cmdObjList);
                    DispMipiDialog.this.updateAdvanceForPanelCmd(DispMipiDialog.this.mipiModeObj);
                    DispMipiDialog.this.cmdNumber = number;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelNumbervalidValue = new Label(composite, 0);
        labelNumbervalidValue.setText("([0-24])");
        this.fillHorizontal((Control)labelNumbervalidValue);
        this.panelCmdComposite = new Composite(parent, 0);
        this.createPanelCmd(this.mipiModeObj);
        return super.createContents(parent);
    }

    private void updateAdvanceForPanelCmd(MipiModeObj mipiModeObj) {
        this.mipiPanelCmdObjTextList.clear();
        this.textArgCountList.clear();
        int cmdIndex = 0;
        while (cmdIndex < mipiModeObj.getCmdNumber()) {
            ArrayList<Text> textList = new ArrayList<Text>();
            MipiPanelCmdObj mipiPanelCmdObj = mipiModeObj.getMipiPanelCmdObj()[cmdIndex];
            Label labelPanelCmd = new Label(this.panelCmdComposite, 0);
            labelPanelCmd.setText("PanelCMD" + cmdIndex + " (HEX):");
            Label labelCmdType = new Label(this.panelCmdComposite, 0);
            labelCmdType.setText("Type:");
            Text textCmdType = new Text(this.panelCmdComposite, 2048);
            textCmdType.setText(Integer.toHexString(mipiPanelCmdObj.getCmdType()));
            textCmdType.setTextLimit(2);
            this.fillHorizontal((Control)textCmdType);
            this.addModifyListene(textCmdType, true);
            textList.add(textCmdType);
            Label labelArgCount = new Label(this.panelCmdComposite, 0);
            labelArgCount.setText("ArgConut:");
            Text textArgCount = new Text(this.panelCmdComposite, 2048);
            textArgCount.setText(String.valueOf(mipiPanelCmdObj.getArgCount()));
            this.fillHorizontal((Control)textArgCount);
            textArgCount.setTextLimit(2);
            this.addModifyListene(textArgCount, false);
            textList.add(textArgCount);
            this.textArgCountList.add(textArgCount);
            Label labelValue = new Label(this.panelCmdComposite, 0);
            labelValue.setText("Value:");
            int argLength = mipiPanelCmdObj.getCmdValueList().length;
            int i = 0;
            while (i < argLength) {
                Text text = new Text(this.panelCmdComposite, 2048);
                String value = Integer.toString(mipiPanelCmdObj.getCmdValueList()[i]);
                text.setText(value);
                this.fillHorizontal((Control)text);
                text.setTextLimit(2);
                this.addModifyListene(text, false);
                textList.add(text);
                ++i;
            }
            this.mipiPanelCmdObjTextList.add(textList);
            ++cmdIndex;
        }
        this.parent.update();
        this.parent.layout();
    }

    private void createPanelCmd(MipiModeObj mipiModeObj) {
        this.panelCmdComposite.setLayout((Layout)new GridLayout(30, false));
        GridData comGD = new GridData(4, 1, true, false);
        comGD.horizontalSpan = 10;
        this.panelCmdComposite.setLayoutData((Object)comGD);
        this.updateAdvanceForPanelCmd(mipiModeObj);
    }

    private void disposeAllControl() {
        if (this.panelCmdComposite != null && !this.panelCmdComposite.isDisposed()) {
            Control[] children = this.panelCmdComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control control = children[i];
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    Object var3_3 = null;
                }
                ++i;
            }
        }
    }

    private Combo createCombo(Composite composite, String text, String[] items, int select) {
        Label spdiLbl = new Label(composite, 0);
        this.fillHorizontal((Control)spdiLbl);
        spdiLbl.setText(text);
        Combo combo = new Combo(composite, 8);
        combo.setItems(items);
        combo.select(select);
        this.fillHorizontal((Control)combo);
        return combo;
    }

    protected GridData fillHorizontal(Control control) {
        GridData layoutData = new GridData(768);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected GridData beginHorizontal(Control control) {
        GridData btnGridData = new GridData(1, 1, true, true);
        control.setLayoutData((Object)btnGridData);
        return btnGridData;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.getTimingParamValue()) {
                this.okPressed();
            }
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    private boolean getTimingParamValue() {
        if (!this.checkTimingParam()) {
            return false;
        }
        this.mipiModeObj.setLaneIdList(new short[]{(short)this.comboChannel0.getSelectionIndex(), (short)this.comboChannel1.getSelectionIndex(), (short)this.comboChannel2.getSelectionIndex(), (short)this.comboChannel3.getSelectionIndex()});
        this.mipiModeObj.setOutputMode(this.comboOutputMode.getSelectionIndex());
        this.mipiModeObj.setVideoMode(this.comboVideoMode.getSelectionIndex());
        this.mipiModeObj.setMipiMode(this.comboMipiMode.getSelectionIndex());
        this.mipiModeObj.setBpp(Integer.parseInt(this.textBpp.getText().trim()));
        this.mipiModeObj.setBriPercent(Integer.parseInt(this.textBriPercent.getText().trim()));
        this.mipiModeObj.setCmdNumber(this.mipiPanelCmdObjTextList.size());
        MipiPanelCmdObj[] cmdObjList = new MipiPanelCmdObj[this.mipiModeObj.getCmdNumber()];
        int index = 0;
        while (index < cmdObjList.length) {
            ArrayList<Text> textList = this.mipiPanelCmdObjTextList.get(index);
            MipiPanelCmdObj mipiPanelCmdObj = new MipiPanelCmdObj();
            mipiPanelCmdObj.setCmdType(Integer.parseInt(textList.get(0).getText().trim(), 16));
            mipiPanelCmdObj.setArgCount(Integer.parseInt(textList.get(1).getText().trim()));
            byte[] cmdValueList = new byte[24];
            int i = 0;
            while (i < cmdValueList.length) {
                cmdValueList[i] = (byte)Integer.parseInt(textList.get(i + 2).getText().trim());
                ++i;
            }
            mipiPanelCmdObj.setCmdValueList(cmdValueList);
            cmdObjList[index] = mipiPanelCmdObj;
            ++index;
        }
        this.mipiModeObj.setMipiPanelCmdObj(cmdObjList);
        return true;
    }

    private boolean checkTimingParam() {
        String bppStr = this.textBpp.getText();
        if (bppStr == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.BaseparamComposite_mipi_bpp) + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        int bpp = Integer.parseInt(bppStr);
        if (bpp < 128 || bpp > 575) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.BaseparamComposite_mipi_bpp) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(128), (Object)String.valueOf(575))));
            return false;
        }
        String briPercentStr = this.textBriPercent.getText();
        if (briPercentStr == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.BaseparamComposite_mipi_bripercent) + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        int percentStr = Integer.parseInt(briPercentStr);
        if (percentStr < 0 || percentStr > 100) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.BaseparamComposite_mipi_bripercent) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(100))));
            return false;
        }
        for (Text text : this.textArgCountList) {
            String argCountStr = text.getText();
            if (argCountStr == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ArgConut" + Messages.Composite_Text_Can_Not_Empty));
                return false;
            }
            int argCount = Integer.parseInt(argCountStr);
            if (argCount >= 0 && argCount <= 24) continue;
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ArgConut" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(24))));
            return false;
        }
        for (ArrayList arrayList : this.mipiPanelCmdObjTextList) {
            int i = 0;
            while (i < arrayList.size()) {
                Text text = (Text)arrayList.get(i);
                if (i != 0) {
                    String valueStr = text.getText();
                    if (valueStr == null) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("Value" + Messages.Composite_Text_Can_Not_Empty));
                        return false;
                    }
                    long value = -1L;
                    try {
                        value = Integer.valueOf(valueStr).intValue();
                    }
                    catch (NumberFormatException number) {
                        number.printStackTrace();
                    }
                    if (value < 0L || value > 24L) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("Value" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(24))));
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected void addModifyListene(Text text, boolean isHex) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textStr = text.getText();
                if (textStr == null) {
                    return;
                }
                if (textStr.isEmpty()) {
                    text.setText("0");
                    return;
                }
                if (isHex) {
                    if (!DispMipiDialog.this.pattenHex.matcher(textStr.toLowerCase()).matches()) {
                        text.setText("0");
                        return;
                    }
                } else if (!DispMipiDialog.this.patten.matcher(textStr).matches()) {
                    text.setText("0");
                    return;
                }
            }
        });
    }
}

