/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.HI_UNF_MCE;
import com.hisilicon.fastplay.model.baseparam.SoundParamObj;
import com.hisilicon.fastplay.views.FastplayView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class InterFaceDialog
extends Dialog {
    public static final int action_type_add = 1;
    public static final int action_type_del = 0;
    public static final String DISP_INTERFACE_TYPE = "disp";
    public static final String SOUND_INTERFACE_TYPE = "SOUND";
    public static final String SOUND_DAC = "DAC";
    public static final String SOUND_HDMI = "HDMI";
    public static final String SOUND_I2S = "I2S";
    public static final int SOUND_INTERFACE_NUMBER = 5;
    private List allList;
    private List selectList;
    private Object[] typeObj;
    private String[] selectNames;
    private String interfaceType;
    public static final int MAX_I2S_COUNT = 2;
    public static final int MAX_I2S_COUNT_HI3796CV300 = 5;
    public static final int MAX_ARC_COUNT = 1;
    public static final int MAX_ARC_COUNT_HI3796CV300 = 2;

    private static int getMaxI2sCount() {
        if (FastplayView.isHi3796CV300Series()) {
            return 5;
        }
        return 2;
    }

    private static int getMaxArcCount() {
        if (FastplayView.isHi3796CV300Series()) {
            return 2;
        }
        return 1;
    }

    protected InterFaceDialog(Shell comShell, String[] names, String type) {
        super(comShell);
        this.selectNames = names;
        this.interfaceType = type;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.BaseparamComposite_InterFaceDialog_title);
        parent.setSize(610, 396);
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite(parent, 2048);
        Label lblNewLabel = new Label(com, 0);
        lblNewLabel.setBounds(33, 29, 80, 17);
        lblNewLabel.setText(Messages.InterFaceType);
        this.allList = new List(com, 514);
        if (this.interfaceType == null) {
            return null;
        }
        if (this.interfaceType.equals(DISP_INTERFACE_TYPE)) {
            if (FastplayView.isHi3796CV300Series()) {
                this.allList.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.DISPINTERFACEHI3796CV300.values()));
            } else {
                this.allList.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.DISPINTERFACE.values()));
            }
        } else {
            this.allList.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.AUDIOINTERFACE.values()));
        }
        this.allList.setBounds(32, 52, 185, 233);
        Button btnNewButton = new Button(com, 0);
        btnNewButton.setBounds(251, 106, 80, 27);
        btnNewButton.setText(">");
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterFaceDialog.this.addItem(InterFaceDialog.this.allList, InterFaceDialog.this.selectList, false);
            }
        });
        Button button = new Button(com, 0);
        button.setText("<");
        button.setBounds(251, 139, 80, 27);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterFaceDialog.this.removeItem(InterFaceDialog.this.selectList, InterFaceDialog.this.allList, false);
            }
        });
        Button button_1 = new Button(com, 0);
        button_1.setText(">>");
        button_1.setBounds(251, 172, 80, 27);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterFaceDialog.this.addItem(InterFaceDialog.this.allList, InterFaceDialog.this.selectList, true);
            }
        });
        Button button_2 = new Button(com, 0);
        button_2.setText("<<");
        button_2.setBounds(251, 205, 80, 27);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterFaceDialog.this.removeItem(InterFaceDialog.this.selectList, InterFaceDialog.this.allList, true);
            }
        });
        this.selectList = new List(com, 514);
        this.selectList.setBounds(372, 52, 185, 233);
        this.setSelectList();
        Label lblSelect = new Label(com, 0);
        lblSelect.setText(Messages.BaseparamComposite_12);
        lblSelect.setBounds(375, 29, 61, 17);
        Button btnOK = new Button(com, 0);
        btnOK.setText(Messages.BaseparamComposite_13);
        btnOK.setBounds(149, 306, 80, 27);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FastplayView.isHi3796CV300Series()) {
                    String[] itmes = InterFaceDialog.this.selectList.getItems();
                    if (InterFaceDialog.this.interfaceType.equals(InterFaceDialog.DISP_INTERFACE_TYPE) && itmes.length > 1) {
                        MessageDialog.openInformation((Shell)InterFaceDialog.this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.INTERFACE_TYPE_ERROR);
                        return;
                    }
                    if (InterFaceDialog.this.interfaceType.equals(InterFaceDialog.SOUND_INTERFACE_TYPE)) {
                        int count = 0;
                        String[] stringArray = itmes;
                        int n = itmes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String item = stringArray[n2];
                            if (item.startsWith(InterFaceDialog.SOUND_DAC)) {
                                ++count;
                            } else if (item.startsWith(InterFaceDialog.SOUND_HDMI)) {
                                ++count;
                            } else if (item.startsWith(InterFaceDialog.SOUND_I2S)) {
                                ++count;
                            }
                            ++n2;
                        }
                        if (count > 5) {
                            MessageDialog.openInformation((Shell)InterFaceDialog.this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.INTEFACE_NUMBER_ERROR);
                            return;
                        }
                    }
                }
                InterFaceDialog.this.getListValues(1);
                InterFaceDialog.this.close();
            }
        });
        Button btnCancle = new Button(com, 0);
        btnCancle.setText(Messages.BaseparamComposite_15);
        btnCancle.setBounds(390, 306, 80, 27);
        btnCancle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterFaceDialog.this.getListValues(0);
                InterFaceDialog.this.close();
            }
        });
        return super.createContents(com);
    }

    private void setSelectList() {
        if (this.selectNames != null && this.selectNames.length > 0) {
            int i = 0;
            while (i < this.selectNames.length) {
                if (SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name().toUpperCase().equals(this.selectNames[i])) {
                    this.selectList.add(SOUND_HDMI);
                } else {
                    this.selectList.add(this.selectNames[i]);
                }
                ++i;
            }
        }
    }

    private void getListValues(int type) {
        if (type == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = 0;
            this.typeObj = objectArray;
            return;
        }
        String[] itmes = this.selectList.getItems();
        String[] interfaceNames = new String[itmes.length];
        System.arraycopy(itmes, 0, interfaceNames, 0, itmes.length);
        this.typeObj = new Object[]{1, interfaceNames};
    }

    public Object[] getTypeObj() {
        return (Object[])this.typeObj.clone();
    }

    private void addItem(List srcList, List targList, boolean isAll) {
        if (isAll) {
            String[] items = srcList.getItems();
            int i = 0;
            while (i < items.length) {
                if (!this.filterItem(targList.getItems(), items[i])) {
                    items[i] = InterFaceDialog.removeTipMultiChoice(items[i]);
                    targList.add(items[i]);
                }
                ++i;
            }
        } else {
            String[] selection = srcList.getSelection();
            int i = 0;
            while (i < selection.length) {
                if (!this.filterItem(targList.getItems(), selection[i])) {
                    selection[i] = InterFaceDialog.removeTipMultiChoice(selection[i]);
                    targList.add(selection[i]);
                }
                ++i;
            }
        }
    }

    private boolean filterItem(String[] items, String itemName) {
        int i2cCount = 0;
        int arcCount = 0;
        itemName = InterFaceDialog.removeTipMultiChoice(itemName);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            item = InterFaceDialog.removeTipMultiChoice(item);
            if (FastplayView.isHi3796CV300Series() ? !itemName.equalsIgnoreCase(HI_UNF_MCE.AUDIOINTERFACE.ARC.name()) && !itemName.equalsIgnoreCase(HI_UNF_MCE.AUDIOINTERFACE.I2S.name()) && itemName.equals(item) : !itemName.equalsIgnoreCase(HI_UNF_MCE.AUDIOINTERFACE.I2S.name()) && itemName.equals(item)) {
                return true;
            }
            if (HI_UNF_MCE.AUDIOINTERFACE.ARC.name().equals(item)) {
                ++arcCount;
            }
            if (HI_UNF_MCE.AUDIOINTERFACE.I2S.name().equals(item)) {
                ++i2cCount;
            }
            ++n2;
        }
        if (HI_UNF_MCE.AUDIOINTERFACE.I2S.name().equals(itemName) && i2cCount == InterFaceDialog.getMaxI2sCount()) {
            return true;
        }
        return HI_UNF_MCE.AUDIOINTERFACE.ARC.name().equals(itemName) && arcCount == InterFaceDialog.getMaxArcCount();
    }

    private void removeItem(List srcList, List targList, boolean isAll) {
        if (isAll) {
            srcList.removeAll();
        } else {
            srcList.remove(srcList.getSelectionIndices());
        }
    }

    public boolean close() {
        return super.close();
    }

    public static String removeTipMultiChoice(String str) {
        if (str.endsWith(Messages.CanSelectMore)) {
            str = str.substring(0, str.indexOf(Messages.CanSelectMore));
        }
        return str;
    }
}

