/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.logoimage.LogParam;
import com.hisilicon.fastplay.preferences.FastplayPreferences;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.ui.SettingComposite;
import com.hisilicon.fastplay.views.FastplayView;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LogoComposite
extends SettingComposite {
    private static final int MAX_RESOLUTION_WIDTH = 4096;
    private static final int MAX_RESOLUTION_HIGHT = 4096;
    private CLabel backgrundImg1;
    private CLabel backgrundImg2;
    private String logFile1;
    private String logFile2;
    private int logQuality1;
    private int logQuality2;
    private Composite imgCompo1;
    private Image backImg1;
    private Composite imgCompo2;
    private Image backImg2;

    public LogoComposite(Composite parent, Setting setting) {
        super(parent, setting);
    }

    private String[] getQualityValue() {
        return new String[]{"100", "80", "60", "40", "20"};
    }

    @Override
    public PrepareSetting getSetting() {
        return (PrepareSetting)super.getSetting();
    }

    void copyImageToCanvas(Image src, Image des, CLabel canvas) {
        GC gc = new GC((Drawable)des);
        ImageData srcData = src.getImageData();
        Rectangle rectangle = canvas.getBounds();
        gc.drawImage(src, 0, 0, srcData.width, srcData.height, 0, 0, rectangle.width, rectangle.height);
        src.dispose();
        gc.dispose();
    }

    public void loadImage(Image img, CLabel canvas) {
        Image newImage = new Image(null, canvas.getSize().x, canvas.getSize().y);
        try {
            if (img != null) {
                this.copyImageToCanvas(img, newImage, canvas);
                canvas.setBackground(newImage);
                img.dispose();
            } else {
                canvas.setBackground(newImage);
            }
        }
        catch (SWTException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout fatherLayout = new GridLayout(1, false);
        composite.setLayout((Layout)fatherLayout);
        this.imgCompo1 = new Composite(composite, 0);
        FillLayout imgLayout = new FillLayout();
        this.imgCompo1.setLayout((Layout)imgLayout);
        this.fillHorizVert((Control)this.imgCompo1);
        this.backgrundImg1 = new CLabel(this.imgCompo1, 36);
        this.backgrundImg1.setText(Messages.Logo_7);
        this.backgrundImg1.setAlignment(0x1000000);
        if (FastplayView.isHi3796CV300Series()) {
            this.imgCompo2 = new Composite(composite, 0);
            imgLayout = new FillLayout();
            this.imgCompo2.setLayout((Layout)imgLayout);
            this.fillHorizVert((Control)this.imgCompo2);
            this.backgrundImg2 = new CLabel(this.imgCompo2, 36);
            this.backgrundImg2.setText(Messages.Logo_7);
            this.backgrundImg2.setAlignment(0x1000000);
        }
        Composite comGroup = new Composite(composite, 2048);
        comGroup.setLayout((Layout)new GridLayout(1, false));
        this.fillHorizontal((Control)comGroup);
        Composite subComGroup = new Composite(comGroup, 0);
        subComGroup.setLayout((Layout)new GridLayout(6, false));
        this.fillHorizontal((Control)subComGroup);
        Label labelQuality = new Label(subComGroup, 0);
        labelQuality.setText(Messages.LogoComposite_Image_Quality);
        Combo comboQuality = new Combo(subComGroup, 8);
        comboQuality.setItems(this.getQualityValue());
        comboQuality.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                int selectionIndex = comboQuality.getSelectionIndex();
                int selectVaule = Integer.parseInt(LogoComposite.this.getQualityValue()[selectionIndex]);
                LogoComposite.this.logQuality1 = selectVaule;
            }
        });
        comboQuality.select(0);
        GridData labelGD = new GridData();
        labelGD.horizontalIndent = 20;
        Label label = new Label(subComGroup, 0);
        label.setText(Messages.LogoComposite_0);
        label.setLayoutData((Object)labelGD);
        Text imageText = new Text(subComGroup, 2048);
        imageText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                LogoComposite.this.logFile1 = imageText.getText();
                if (LogoComposite.this.logFile1 == null || LogoComposite.this.logFile1.isEmpty()) {
                    LogoComposite.this.loadImage(null, LogoComposite.this.backgrundImg1);
                }
            }
        });
        imageText.setLayoutData((Object)new GridData(4, 1, true, false));
        Button button = new Button(subComGroup, 0);
        button.setText(Messages.LogoComposite_1);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(LogoComposite.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*", "*.bmp", "*.gif", "*.jpeg", ".png"});
                dialog.setFileName(imageText.getText());
                String open = dialog.open();
                if (open == null) {
                    return;
                }
                if (LogoComposite.this.checkImagePath(open)) {
                    LogoComposite.this.backgrundImg1.getImage();
                    LogoComposite.this.backgrundImg1.getBackgroundImage();
                    imageText.setText(open);
                    LogoComposite.this.backgrundImg1.setText("");
                    LogoComposite.this.backImg1 = LogoComposite.this.getImage(open, LogoComposite.this.imgCompo1);
                    LogoComposite.this.loadImage(LogoComposite.this.backImg1, LogoComposite.this.backgrundImg1);
                    if (LogoComposite.this.backImg1 == null) {
                        imageText.setText("");
                    }
                }
            }
        });
        if (FastplayView.isHi3796CV300Series()) {
            comGroup = new Composite(composite, 2048);
            comGroup.setLayout((Layout)new GridLayout(1, false));
            this.fillHorizontal((Control)comGroup);
            subComGroup = new Composite(comGroup, 0);
            subComGroup.setLayout((Layout)new GridLayout(6, false));
            this.fillHorizontal((Control)subComGroup);
            labelQuality = new Label(subComGroup, 0);
            labelQuality.setText(Messages.LogoComposite_Image_Quality);
            Combo comboQuality2 = new Combo(subComGroup, 8);
            comboQuality2.setItems(this.getQualityValue());
            comboQuality2.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    int selectionIndex = comboQuality.getSelectionIndex();
                    int selectVaule = Integer.parseInt(LogoComposite.this.getQualityValue()[selectionIndex]);
                    LogoComposite.this.logQuality2 = selectVaule;
                }
            });
            comboQuality2.select(0);
            labelGD = new GridData();
            labelGD.horizontalIndent = 20;
            label = new Label(subComGroup, 0);
            label.setText(Messages.LogoComposite_0);
            label.setLayoutData((Object)labelGD);
            Text imageText2 = new Text(subComGroup, 2048);
            imageText2.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    LogoComposite.this.logFile2 = imageText2.getText();
                    if (LogoComposite.this.logFile2 == null || LogoComposite.this.logFile2.isEmpty()) {
                        LogoComposite.this.loadImage(null, LogoComposite.this.backgrundImg2);
                    }
                }
            });
            imageText2.setLayoutData((Object)new GridData(4, 1, true, false));
            Button button2 = new Button(subComGroup, 0);
            button2.setText(Messages.LogoComposite_1);
            button2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(LogoComposite.this.getShell(), 4096);
                    dialog.setFilterExtensions(new String[]{"*", "*.bmp", "*.gif", "*.jpeg", ".png"});
                    dialog.setFileName(imageText2.getText());
                    String open = dialog.open();
                    if (open == null) {
                        return;
                    }
                    if (LogoComposite.this.checkImagePath(open)) {
                        LogoComposite.this.backgrundImg2.getImage();
                        LogoComposite.this.backgrundImg2.getBackgroundImage();
                        imageText2.setText(open);
                        LogoComposite.this.backgrundImg2.setText("");
                        LogoComposite.this.backImg2 = LogoComposite.this.getImage(open, LogoComposite.this.imgCompo2);
                        LogoComposite.this.loadImage(LogoComposite.this.backImg2, LogoComposite.this.backgrundImg2);
                        if (LogoComposite.this.backImg2 == null) {
                            imageText2.setText("");
                        }
                    }
                }
            });
        }
        return composite;
    }

    private Image getImage(String filePath, Composite imgCompo) {
        ImageData newImageData = null;
        Image image = null;
        Rectangle bounds = imgCompo.getBounds();
        ImageData[] load = null;
        try {
            load = new ImageLoader().load(filePath);
        }
        catch (Error e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.LogoComposite_Resolution_To_Much_CanNot_load);
            return null;
        }
        catch (IllegalArgumentException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.LogoComposite_Resolution_To_Much_CanNot_load);
            return null;
        }
        catch (SWTException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.LogoComposite_Resolution_To_Much_CanNot_load);
            return null;
        }
        if (load != null && load.length > 0) {
            newImageData = load[0].scaledTo(bounds.width, bounds.height);
            int width = load[0].width;
            int height = load[0].height;
            if (width > 4096 || height > 4096) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.LogoComposite_Resolution_To_Much);
                return null;
            }
            image = new Image((Device)this.getShell().getDisplay(), newImageData);
        }
        return image;
    }

    public void displayBackground() {
        if (this.backgrundImg1 != null && this.backgrundImg1.getBackgroundImage() != null) {
            this.backgrundImg1.getBackgroundImage().dispose();
        }
        if (this.backgrundImg2 != null && this.backgrundImg2.getBackgroundImage() != null) {
            this.backgrundImg2.getBackgroundImage().dispose();
        }
    }

    @Override
    protected Object getParam() {
        boolean isNotConvertJPG = FastplayPreferences.isNotConvertJPG();
        LogParam logParam = null;
        logParam = FastplayView.isHi3796CV300Series() ? new LogParam(this.logFile1, this.logQuality1, this.logFile2, this.logQuality2, isNotConvertJPG) : new LogParam(this.logFile1, this.logQuality1, isNotConvertJPG);
        this.getSetting().setParamObj(logParam);
        return logParam;
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        LogParam log = (LogParam)objParam;
        String fileName = log.getLogFileName();
        return this.checkImagePath(fileName);
    }

    private boolean checkImgSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        String suffix = fileName.substring(index);
        String[] stringArray = SettingComposite.getImgsuffix();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String su = stringArray[n2];
            if (su.equalsIgnoreCase(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkImagePath(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.commom_msg_file_path);
            return false;
        }
        if (!new File(fileName).exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.Logo_3);
            return false;
        }
        if (!this.checkImgSuffix(fileName)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.Logo_2);
            return false;
        }
        return true;
    }
}

