/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.baseparam.HI_UNF_ENC_FMT_E;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.baseparam.BaseParam;
import com.hisilicon.fastplay.model.baseparam.DispParamObj;
import com.hisilicon.fastplay.model.baseparam.I2SModeObj;
import com.hisilicon.fastplay.model.baseparam.SoundParamObj;
import com.hisilicon.fastplay.model.baseparam.WidgetParam;
import com.hisilicon.fastplay.model.ts.TSParam;
import com.hisilicon.fastplay.processor.IBniParamServer;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.processor.TSParamProcess;
import com.hisilicon.fastplay.ui.ANIComposite;
import com.hisilicon.fastplay.ui.BaseparamComposite;
import com.hisilicon.fastplay.ui.DVBComposite;
import com.hisilicon.fastplay.ui.LogoComposite;
import com.hisilicon.fastplay.ui.MusicComposite;
import com.hisilicon.fastplay.views.FastplayView;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public abstract class SettingComposite
extends Composite
implements HI_UNF_ENC_FMT_E {
    private static Pattern patten = Pattern.compile("^[0-9]*$");
    protected static final Pattern hexDataPatternWithPerfix = Pattern.compile("0x[0-9a-fA-F]{1,8}");
    protected static final Pattern hexDataPattern = Pattern.compile("[0-9a-fA-F]{1,8}");
    public static final int MIN_INPUT_0 = 0;
    public static final int MAX_INPUT_100 = 100;
    public static final int MAX_INPUT_200 = 200;
    public static final int MAX_INPUT_1023 = 1023;
    public static final int MAX_INPUT_8192 = 8192;
    public static final int TEXT_LIMIT_3 = 3;
    public static final int TEXT_LIMIT_4 = 4;
    public static final int TEXT_LIMIT_5 = 5;
    public static final int TEXT_LIMIT_8 = 8;
    public static final int TEXT_LIMIT_9 = 9;
    public static final int TEXT_LIMIT_10 = 10;
    protected static final int MULTIPLE_2 = 2;
    protected static final int MULTIPLE_4 = 4;
    private static final String[] imgSuffix = new String[]{".jpg", ".jpeg", ".bmp", ".png", ".gif"};
    private Setting setting;
    protected IBniParamServer paramServer;

    public SettingComposite(Composite parent, Setting setting) {
        super(parent, 0);
        this.setting = setting;
        this._setLayout((Layout)new GridLayout());
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        GridData gridData;
        Control control = this.createControl(parent);
        if (control != null) {
            control.setLayoutData((Object)new GridData(1808));
        }
        Composite buttonArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(768));
        if (this instanceof BaseparamComposite) {
            Label tipLabel = new Label(buttonArea, 0);
            tipLabel.setText(Messages.TipLabel);
            GridData lblGD = new GridData(4, 1, true, false);
            lblGD.horizontalSpan = 2;
            tipLabel.setLayoutData((Object)lblGD);
        }
        if (!(this instanceof MusicComposite)) {
            Button createButton = new Button(buttonArea, 0);
            createButton.setText(Messages.SettingComposite_0);
            gridData = new GridData(576);
            gridData.widthHint = 150;
            createButton.setLayoutData((Object)gridData);
            createButton.addListener(13, (Listener)new CreateListener());
        }
        if (this instanceof BaseparamComposite) {
            Button readBaseBinBtn = new Button(buttonArea, 0);
            gridData = new GridData(576);
            gridData.widthHint = 150;
            readBaseBinBtn.setLayoutData((Object)gridData);
            readBaseBinBtn.setText(Messages.BaseParamComposite_ReadBin_Button);
            readBaseBinBtn.addListener(13, (Listener)new ReadBaseBinListener());
        }
        if (this instanceof LogoComposite) {
            Button convertButton = new Button(buttonArea, 0);
            convertButton.setText(Messages.LogoComposite_ConvertImage);
            gridData = new GridData(576);
            gridData.widthHint = 150;
            convertButton.setLayoutData((Object)gridData);
            convertButton.setToolTipText(Messages.LogoComposite_ConvertImageToJPG);
            convertButton.addListener(13, (Listener)new ConvertListener());
        }
    }

    public Setting getSetting() {
        return this.setting;
    }

    protected Object getParam() {
        return null;
    }

    protected abstract Control createControl(Composite var1);

    public void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    public void setLayout(Layout layout) {
    }

    protected GridData fillHorizontal(Control control) {
        GridData layoutData = new GridData(768);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected GridData fillHorizVert(Control control) {
        GridData layoutData = new GridData(1808);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected RowLayout rowLayout() {
        RowLayout row = new RowLayout();
        row.center = true;
        return row;
    }

    protected boolean checkExitBeforeSave(String savePath) {
        File saveFile = new File(savePath);
        int open = 1;
        while (saveFile != null && saveFile.exists() && open == 1) {
            MessageDialog dialog = new MessageDialog(this.getShell(), "HiFastplay", null, NLS.bind((String)Messages.Composite_msg_file_exists_already_whether_to_overwrite_it, (Object)saveFile.getAbsolutePath()), 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            open = dialog.open();
            if (open != 1) continue;
            return false;
        }
        return open != 2;
    }

    private boolean prepareWork() {
        boolean bool = true;
        bool = this.checkAllTextValue();
        if (!bool) {
            return false;
        }
        Object paramObj = this.getParam();
        if (paramObj == null) {
            return false;
        }
        if (!this.checkInfo(paramObj)) {
            return false;
        }
        if (this.paramServer != null && !(this instanceof MusicComposite)) {
            Object result = this.paramServer.paramProcess(paramObj);
            if (this.paramServer instanceof TSParamProcess) {
                Status create = (Status)result;
                if (create != null && create == Status.CANCEL_STATUS) {
                    return false;
                }
                if (create != null && !create.isOK()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.TSParamProcessCheck_2);
                    return false;
                }
            }
        }
        return true;
    }

    protected static void addModifyListene(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textStr = text.getText();
                if (textStr == null) {
                    return;
                }
                if (!patten.matcher(textStr).matches()) {
                    text.setText("0");
                    return;
                }
                if (textStr.length() <= 0) {
                    text.setText("0");
                    return;
                }
            }
        });
    }

    protected boolean checkInfo(Object objParam) {
        return false;
    }

    protected Dimension getWindowSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    protected boolean checkAllTextValue() {
        return true;
    }

    protected boolean checkTextValue(Text text) {
        String textStr = text.getText();
        if (textStr == null) {
            return false;
        }
        if (textStr.length() > 0) {
            return textStr.length() < String.valueOf(Integer.MAX_VALUE).length();
        }
        return false;
    }

    protected static void addModifyListenerForHexText(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textStr = text.getText();
                if (textStr == null) {
                    return;
                }
                if (textStr.isEmpty()) {
                    text.setText("0x0");
                    return;
                }
                if (!SettingComposite.isValidHexString(textStr)) {
                    text.setText("0");
                    return;
                }
            }
        });
    }

    protected boolean checkTextValue(Text text, int min, int max) {
        String textStr = text.getText();
        if (textStr == null) {
            return false;
        }
        if (textStr.length() > 0) {
            if (text.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                return false;
            }
            long value = -1L;
            try {
                if (textStr.startsWith("0x")) {
                    Long tmpNum = Long.parseLong(textStr.substring(2), 16);
                    value = tmpNum.intValue();
                } else {
                    value = Integer.parseInt(textStr);
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            return value >= (long)min && value <= (long)max;
        }
        return false;
    }

    protected boolean checkTextOffsetValue(Text text, int min, int max, int multiple) {
        String textStr = text.getText();
        if (textStr == null) {
            return false;
        }
        if (textStr.length() > 0) {
            if (text.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                return false;
            }
            long value = 0L;
            if (textStr.startsWith("0x")) {
                Long tmpNum = Long.parseLong(textStr.substring(2), 16);
                value = tmpNum.intValue();
            } else {
                value = Integer.parseInt(textStr);
            }
            if (value < (long)min || value > (long)max) {
                return false;
            }
            return value % (long)multiple == 0L;
        }
        return false;
    }

    protected boolean checkTextValue(Spinner spinner, int min, int max) {
        String textStr = spinner.getText();
        if (textStr == null) {
            return false;
        }
        if (textStr.length() > 0) {
            if (spinner.getText().length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                return false;
            }
            Integer value = Integer.valueOf(textStr);
            if (value < min || value > max) {
                return false;
            }
        }
        return true;
    }

    protected Spinner createSpinner(Composite parent, int style, int min, int current, int max, int inc, int pageinc, int digits) {
        Spinner spinner = new Spinner(parent, style);
        if (min >= 0) {
            spinner.setMinimum(min);
        }
        if (max >= 0) {
            spinner.setMaximum(max);
        }
        if (current >= 0) {
            spinner.setSelection(current);
        }
        if (inc >= 1) {
            spinner.setIncrement(inc);
        }
        if (pageinc >= 1) {
            spinner.setPageIncrement(pageinc);
        }
        if (digits >= 0) {
            spinner.setDigits(digits);
        }
        return spinner;
    }

    protected void addModifyListenerForSpinner(Spinner spinner) {
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String spinneStr = spinner.getText();
                if (spinneStr == null) {
                    return;
                }
                if (!patten.matcher(spinneStr).matches()) {
                    spinner.setSelection(0);
                    return;
                }
            }
        });
    }

    public static boolean isValidHexString(String hexString, boolean withPrefix) {
        if (withPrefix) {
            return hexDataPatternWithPerfix.matcher(hexString).matches();
        }
        return hexDataPattern.matcher(hexString).matches();
    }

    public static boolean isValidHexString(String str) {
        return SettingComposite.isValidHexString(str, false) || SettingComposite.isValidHexString(str, true);
    }

    public static String[] getImgsuffix() {
        return (String[])imgSuffix.clone();
    }

    private final class ConvertListener
    implements Listener {
        private ConvertListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = SettingComposite.this.getSetting();
            this.saveInFileSystem(setting);
        }

        public void saveInFileSystem(Setting setting) {
            FileDialog dialog = new FileDialog(SettingComposite.this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.jpg"});
            String savePath = dialog.open();
            if (savePath != null) {
                boolean checkExitBeforeSaveResult = SettingComposite.this.checkExitBeforeSave(savePath);
                if (checkExitBeforeSaveResult) {
                    File file = new File(savePath);
                    IStatus create = Status.CANCEL_STATUS;
                    if (!SettingComposite.this.prepareWork()) {
                        return;
                    }
                    PrepareSetting prepareSetting = (PrepareSetting)setting;
                    if (SettingComposite.this instanceof LogoComposite) {
                        create = prepareSetting.convertImageToJPG(file);
                        ((LogoComposite)SettingComposite.this).displayBackground();
                    }
                    if (create == null || create.isOK()) {
                        MessageDialog.openInformation((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_12, (String)Messages.SettingComposite_13);
                    } else {
                        MessageDialog.openError((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_14, (String)create.getMessage());
                    }
                } else {
                    return;
                }
            }
        }
    }

    protected final class CreateListener
    implements Listener {
        protected CreateListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = SettingComposite.this.getSetting();
            this.saveInFileSystem(setting);
        }

        public void saveInFileSystem(Setting setting) {
            FileDialog dialog = new FileDialog(SettingComposite.this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.img", "*.bin", "*.*"});
            if (SettingComposite.this instanceof BaseparamComposite) {
                dialog.setFileName("baseparam");
            } else if (SettingComposite.this instanceof DVBComposite) {
                dialog.setFileName("fastplay");
            } else if (SettingComposite.this instanceof LogoComposite) {
                dialog.setFileName("logo");
            } else if (SettingComposite.this instanceof ANIComposite) {
                dialog.setFileName("fastplay");
            } else if (SettingComposite.this instanceof MusicComposite) {
                dialog.setFileName("bootmusic");
            }
            String savePath = dialog.open();
            if (savePath != null) {
                boolean checkExitBeforeSaveResult = SettingComposite.this.checkExitBeforeSave(savePath);
                if (checkExitBeforeSaveResult) {
                    File file = new File(savePath);
                    IStatus create = Status.CANCEL_STATUS;
                    if (!SettingComposite.this.prepareWork()) {
                        return;
                    }
                    PrepareSetting prepareSetting = (PrepareSetting)setting;
                    if (SettingComposite.this instanceof BaseparamComposite) {
                        create = prepareSetting.createBaseBin(savePath);
                    } else if (SettingComposite.this instanceof DVBComposite) {
                        create = prepareSetting.createDvbBin(file);
                    } else if (SettingComposite.this instanceof LogoComposite) {
                        create = prepareSetting.createLogoBin(file);
                        ((LogoComposite)SettingComposite.this).displayBackground();
                    } else if (SettingComposite.this instanceof ANIComposite) {
                        if ("jpeg".equals(((TSParam)prepareSetting.getParamObj()).getActiontype())) {
                            create = prepareSetting.createMultiTsBin(file);
                            ((TSParamProcess)SettingComposite.this.paramServer).clearFile();
                            SettingComposite.this.paramServer = null;
                        } else {
                            create = prepareSetting.createTsBin(file);
                        }
                    } else if (SettingComposite.this instanceof MusicComposite) {
                        create = prepareSetting.createMusicBin(savePath);
                    }
                    if (create == null || create.isOK()) {
                        MessageDialog.openInformation((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_12, (String)Messages.SettingComposite_13);
                    } else {
                        MessageDialog.openError((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_14, (String)create.getMessage());
                    }
                }
            } else {
                return;
            }
        }
    }

    private final class ReadBaseBinListener
    implements Listener {
        private ReadBaseBinListener() {
        }

        public void handleEvent(Event event) {
            Setting setting = SettingComposite.this.getSetting();
            this.readInFileSystem(setting);
        }

        public void readInFileSystem(Setting setting) {
            FileDialog dialog = new FileDialog(SettingComposite.this.getShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.*", "*.img", "*.bin"});
            String binPath = dialog.open();
            if (binPath != null) {
                FastplayView fastplayView;
                BaseparamComposite baseparamComposite;
                File file = new File(binPath);
                IStatus readResult = Status.CANCEL_STATUS;
                PrepareSetting prepareSetting = (PrepareSetting)setting;
                if (SettingComposite.this instanceof BaseparamComposite) {
                    readResult = prepareSetting.readBaseparamBin(file.getPath());
                }
                if (readResult == null) {
                    MessageDialog.openError((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_12, (String)Messages.BaseParamComposite_ReadBin_FileNotFind);
                    return;
                }
                if (!readResult.isOK()) {
                    MessageDialog.openError((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_12, (String)Messages.BaseParamComposite_ReadBin_Error);
                    return;
                }
                DispParamObj readDisplay0 = prepareSetting.getReadDisplay0();
                DispParamObj readDisplay1 = prepareSetting.getReadDisplay1();
                DispParamObj readDisplay2 = prepareSetting.getReadDisplay2();
                SoundParamObj readSound0 = prepareSetting.getReadSound0();
                SoundParamObj readSound1 = prepareSetting.getReadSound1();
                SoundParamObj readSound2 = prepareSetting.getReadSound2();
                List<I2SModeObj> i2sModeObjList = prepareSetting.getI2SModeObjList();
                BaseParam readBaseParam = new BaseParam();
                readBaseParam.addDispParamToList(readDisplay0);
                readBaseParam.addDispParamToList(readDisplay1);
                readBaseParam.addDispParamToList(readDisplay2);
                readBaseParam.addSountParamToList(readSound0);
                readBaseParam.addSountParamToList(readSound1);
                readBaseParam.addSountParamToList(readSound2);
                for (I2SModeObj i2SModeObj : i2sModeObjList) {
                    readBaseParam.addI2sParamToList(i2SModeObj);
                }
                ((PrepareSetting)SettingComposite.this.getSetting()).setReadParamObj(readBaseParam);
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(FastplayView.ID);
                if (view != null && view instanceof FastplayView && (baseparamComposite = (fastplayView = (FastplayView)view).getBaseparamComposite()) != null && !baseparamComposite.isDisposed()) {
                    WidgetParam widgetParam = baseparamComposite.getWgetParam();
                    Set<Map.Entry<Integer, Composite>> dataEntrySet = widgetParam.getDispComposite().entrySet();
                    for (Map.Entry<Integer, Composite> entry : dataEntrySet) {
                        if (entry.getKey() == 0 && readDisplay0 != null) {
                            readDisplay0 = (DispParamObj)widgetParam.setBaseParam(0, entry.getValue(), readDisplay0, baseparamComposite);
                            readDisplay0.setCurrentDisp(0);
                            continue;
                        }
                        if (entry.getKey() == 1 && readDisplay1 != null) {
                            readDisplay1 = (DispParamObj)widgetParam.setBaseParam(1, entry.getValue(), readDisplay1, baseparamComposite);
                            readDisplay1.setCurrentDisp(1);
                            continue;
                        }
                        if (entry.getKey() != 2 || readDisplay2 == null) continue;
                        readDisplay2 = (DispParamObj)widgetParam.setBaseParam(2, entry.getValue(), readDisplay2, baseparamComposite);
                        readDisplay2.setCurrentDisp(2);
                    }
                    Set<Map.Entry<Integer, Composite>> soundEntrySet = widgetParam.getSoundComposite().entrySet();
                    for (Map.Entry<Integer, Composite> entry : soundEntrySet) {
                        if (entry.getKey() == 0) {
                            if (readSound0 == null) continue;
                            readSound0 = (SoundParamObj)widgetParam.setBaseParam(0, entry.getValue(), readSound0, baseparamComposite);
                            continue;
                        }
                        if (entry.getKey() == 1) {
                            if (readSound1 == null) continue;
                            readSound1 = (SoundParamObj)widgetParam.setBaseParam(1, entry.getValue(), readSound1, baseparamComposite);
                            continue;
                        }
                        if (entry.getKey() != 2 || readSound2 == null) continue;
                        readSound2 = (SoundParamObj)widgetParam.setBaseParam(2, entry.getValue(), readSound2, baseparamComposite);
                    }
                    Set<Map.Entry<Integer, Composite>> i2sEntrySet = widgetParam.getI2sComposite().entrySet();
                    for (Map.Entry<Integer, Composite> entry : i2sEntrySet) {
                        this.setEveryBaseParam(i2sModeObjList, baseparamComposite, widgetParam, entry);
                    }
                    ((PrepareSetting)SettingComposite.this.getSetting()).setReadParamObj(readBaseParam);
                    baseparamComposite.update();
                }
                if (readResult.isOK()) {
                    MessageDialog.openInformation((Shell)SettingComposite.this.getShell(), (String)Messages.SettingComposite_12, (String)Messages.BaseParamComposite_ReadBin_Success);
                }
            }
        }

        private void setEveryBaseParam(List<I2SModeObj> i2sModeObjList, BaseparamComposite baseparamComposite, WidgetParam widgetParam, Map.Entry<Integer, Composite> entry) {
            I2SModeObj i2sModeObj;
            I2SModeObj i2SModeObj;
            if (i2sModeObjList.size() == 0) {
                return;
            }
            if (entry.getKey() == 0 && (i2SModeObj = i2sModeObjList.get(0)) != null) {
                widgetParam.setBaseParam(0, entry.getValue(), i2SModeObj, baseparamComposite);
            }
            if (entry.getKey() == 1 && (i2sModeObj = i2sModeObjList.get(1)) != null) {
                widgetParam.setBaseParam(1, entry.getValue(), i2sModeObj, baseparamComposite);
            }
            if (entry.getKey() == 2 && (i2sModeObj = i2sModeObjList.get(2)) != null) {
                widgetParam.setBaseParam(2, entry.getValue(), i2sModeObj, baseparamComposite);
            }
            if (entry.getKey() == 3 && (i2sModeObj = i2sModeObjList.get(3)) != null) {
                widgetParam.setBaseParam(3, entry.getValue(), i2sModeObj, baseparamComposite);
            }
            if (entry.getKey() == 4 && (i2sModeObj = i2sModeObjList.get(4)) != null) {
                widgetParam.setBaseParam(4, entry.getValue(), i2sModeObj, baseparamComposite);
            }
        }
    }
}

