/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.hisilicon.hiloader";
    private static Activator plugin;

    public static void setPlugin(Activator plugin) {
        Activator.plugin = plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Activator.setPlugin(this);
    }

    public void stop(BundleContext context) throws Exception {
        Activator.setPlugin(null);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            return new Status(4, PLUGIN_ID, 0, "", exception);
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Image getImage(String imagePath) {
        ImageDescriptor imageDesc = null;
        if (!PlatformUI.isWorkbenchRunning()) {
            URL url = Activator.class.getResource(".");
            if (url == null) {
                return null;
            }
            String urlStr = url.toString();
            int index = urlStr.indexOf(PLUGIN_ID);
            urlStr = urlStr.substring(0, index + PLUGIN_ID.length());
            urlStr = String.valueOf(urlStr) + (imagePath.startsWith("/") ? imagePath : "/" + imagePath);
            try {
                url = new URL(urlStr);
                InputStream sourceStream = url.openStream();
                ImageData source = new ImageData(sourceStream);
                ImageData mask = source.getTransparencyMask();
                return new Image(null, source, mask);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            imageDesc = Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imagePath);
        }
        if (imageDesc == null) {
            return null;
        }
        return imageDesc.createImage();
    }
}

