/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.struct;

import com.hisilicon.hiloader.struct.FlashType;

public class FileSystem {
    public static final FileSystem none = new FileSystem("none");
    public static final FileSystem yaffs = new FileSystem("yaffs");
    public static final FileSystem ext3 = new FileSystem("ext3/4");
    public static final FileSystem f2fs = new FileSystem("f2fs");
    public static final FileSystem ubi = new FileSystem("ubi");
    public static final FileSystem squashfs = new FileSystem("squashfs");
    private static FileSystem[] items = new FileSystem[]{none, yaffs, ubi, ext3, squashfs, f2fs};
    private String fileName;

    public String name() {
        return this.fileName;
    }

    private FileSystem(String name) {
        this.fileName = name;
    }

    public static String[] getItems() {
        return new String[]{none.name(), yaffs.name(), ubi.name(), ext3.name(), FileSystem.squashfs.fileName, f2fs.name()};
    }

    public static String[] getItems(FlashType flashType) {
        if (flashType == null) {
            return FileSystem.getItems();
        }
        if (flashType == FlashType.emmc) {
            return new String[]{none.name(), ext3.name(), f2fs.name()};
        }
        if (flashType == FlashType.nand || flashType == FlashType.spi) {
            return new String[]{none.name(), yaffs.name(), ubi.name(), FileSystem.squashfs.fileName};
        }
        return FileSystem.getItems();
    }

    public static FileSystem valueOf(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("yaffs2")) {
            name = "yaffs";
        }
        int i = 0;
        while (i < items.length) {
            if (name.equalsIgnoreCase(items[i].name())) {
                return items[i];
            }
            ++i;
        }
        if (name.equalsIgnoreCase("ext3") || name.equalsIgnoreCase("ext4") || name.equalsIgnoreCase("ext3/4")) {
            return ext3;
        }
        return null;
    }

    public static String[] getItems(String flashTypeName) {
        FlashType flashType = FlashType.valueOf(flashTypeName);
        return FileSystem.getItems(flashType);
    }

    public static FileSystem[] values() {
        return (FileSystem[])items.clone();
    }
}

