/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.ui.ControlFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileField {
    private int widthHint = 800;
    private String labelText;
    private Label label;
    private Text textField;
    private String[] extensions = null;
    private File filterPath = null;
    private int labelWidth;
    private Button button;
    private String buttonText;
    private String oldValue;
    private Shell shell;
    private int buttonWidth;
    private String defaultFileName;
    private int fileDialogStyle;
    private boolean fileMode = true;
    private boolean readonly;
    private String fileFieldType;

    public FileField(Composite parent, String labelText, int labelWidth, String buttonText, int buttonWidth, String fileFieldType) {
        this(parent, labelText, labelWidth, buttonText, buttonWidth, 0x10001000, fileFieldType);
    }

    public FileField(Composite parent, String labelText, int labelWidth, String buttonText, int buttonWidth, int fileDialogStyle, String fileFieldType) {
        this.labelText = labelText;
        this.labelWidth = labelWidth;
        this.buttonText = buttonText;
        this.buttonWidth = buttonWidth;
        this.shell = parent.getShell();
        this.fileDialogStyle = fileDialogStyle;
        this.fileFieldType = fileFieldType;
        this.createControl(parent);
    }

    public Text getTextControl() {
        return this.textField;
    }

    private void createControl(Composite parent) {
        this.label = ControlFactory.createLabel(parent, this.labelText);
        GridData gd = new GridData();
        gd.widthHint = this.labelWidth;
        this.label.setLayoutData((Object)gd);
        this.textField = ControlFactory.createTsTextField(parent, 2052, this.widthHint);
        this.textField.setFont(parent.getFont());
        this.button = new Button(parent, 8);
        gd = new GridData();
        gd.widthHint = this.buttonWidth;
        this.button.setLayoutData((Object)gd);
        this.button.setText(this.buttonText);
        this.button.setFont(parent.getFont());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newValue = FileField.this.changePressed();
                if (newValue != null) {
                    FileField.this.setStringValue(newValue);
                }
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                FileField.this.button = null;
            }
        });
    }

    public boolean hasInputText(String errorMessage) {
        if (this.isEmpty()) {
            MessageDialog.openError((Shell)this.textField.getShell(), (String)"Error", (String)errorMessage);
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        String text = this.textField.getText();
        return text == null || text.isEmpty();
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public String getFilePath() {
        return this.textField.getText();
    }

    public void setFilePath(String path) {
        this.textField.setText(path);
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (this.oldValue == null) {
                return;
            }
            if (!this.oldValue.equals(value)) {
                this.valueChanged();
                this.textField.setText(value);
                if (this.fileFieldType.equals("tsFileField")) {
                    StringBuffer pathStr = new StringBuffer();
                    pathStr.append("hisitspath=" + value + "\n");
                    pathStr.append("hisiusbpath=" + value + "\n");
                    pathStr.append("ssuitspath=" + value + "\n");
                    FileField.saveFilterPath("tempPath.ini", pathStr.toString());
                } else if (this.fileFieldType.equals("usbFileField")) {
                    StringBuffer pathStr = new StringBuffer();
                    pathStr.append("hisitspath=" + value + "\n");
                    pathStr.append("hisiusbpath=" + value + "\n");
                    pathStr.append("ssuitspath=" + value + "\n");
                    FileField.saveFilterPath("tempPath.ini", pathStr.toString());
                } else if (this.fileFieldType.equals("ssuTsFileField")) {
                    StringBuffer pathStr = new StringBuffer();
                    pathStr.append("hisitspath=" + value + "\n");
                    pathStr.append("hisiusbpath=" + value + "\n");
                    pathStr.append("ssuitspath=" + value + "\n");
                    FileField.saveFilterPath("tempPath.ini", pathStr.toString());
                }
            }
        }
    }

    private void valueChanged() {
    }

    protected String changePressed() {
        File d;
        File f = new File(this.getTextControl().getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getFile(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    private File getFile(File startingDirectory) {
        if (this.fileMode) {
            return this.openFileDialog(startingDirectory);
        }
        return this.openDirectoryDialog(startingDirectory);
    }

    public void setFileMode(boolean fileMode) {
        this.fileMode = fileMode;
    }

    private File openDirectoryDialog(File startingDirectory) {
        String file;
        DirectoryDialog dialog = new DirectoryDialog(this.shell);
        if (startingDirectory != null) {
            dialog.setFilterPath(startingDirectory.getParent());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return this.defaultFileName == null ? new File(file) : new File(file, this.defaultFileName);
        }
        return null;
    }

    private File openFileDialog(File startingDirectory) {
        FileDialog dialog = new FileDialog(this.shell, this.fileDialogStyle);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        } else if (this.filterPath != null) {
            dialog.setFilterPath(this.filterPath.getPath());
        } else if (this.defaultFileName != null) {
            dialog.setFileName(this.defaultFileName);
        }
        if (this.extensions != null) {
            dialog.setFilterExtensions(this.extensions);
        }
        dialog.setOverwrite(true);
        String file = dialog.open();
        if (file != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public void setFileExtensions(String[] extensions) {
        this.extensions = (String[])extensions.clone();
    }

    public static ArrayList<String> loadFilterPath(String path) {
        ArrayList<String> pathList;
        block14: {
            pathList = new ArrayList<String>();
            if (!new File(path).exists()) {
                return pathList;
            }
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "GBK"));
                    while (br.ready()) {
                        pathList.add(br.readLine());
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    if (br == null) break block14;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    }
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    }
                }
            }
        }
        return pathList;
    }

    public static void saveFilterPath(String path, String strpath) {
        block13: {
            if (strpath == null) {
                return;
            }
            BufferedWriter bw = null;
            try {
                try {
                    bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "GBK"));
                    bw.write(strpath.toString().trim());
                    bw.write(System.getProperty("line.separator"));
                    bw.flush();
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    if (bw == null) break block13;
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell().getShell(), (String)"Error", (String)path);
                    }
                }
            }
        }
    }

    public void setFilterPath(File path) {
        this.filterPath = path;
    }

    public void setDefaultFileName(String text) {
        this.defaultFileName = text;
        this.textField.setText(new File(text).getAbsolutePath());
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
        this.textField.setEditable(!this.readonly);
    }
}

