/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.model.PartitionItem;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.ui.AbstractComposite;
import com.hisilicon.hiloader.ui.ControlFactory;
import com.hisilicon.hiloader.ui.FileField;
import com.hisilicon.hiloader.ui.UpgradeInfoGroup;
import com.hisilicon.hiloader.util.FileHelper;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.HisiTsPackageBuilder;
import com.hisilicon.hiloader.util.HisiUsbPackageBuilder;
import com.hisilicon.hiloader.util.IniFileParser;
import com.hisilicon.hiloader.util.InvalidDataFormatException;
import com.hisilicon.hiloader.util.StringUtil;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;

public class HiLoaderComposite
extends AbstractComposite {
    private static final String[] CHIPS = new String[]{"chip 0", "chip 1", "chip 2", "chip 3"};
    private static final String[] INI_FILTER_NAMES = new String[]{"xml Files(*.xml)", "ini Files (*.ini)"};
    private static final String[] INI_FILTER_EXTS = new String[]{"*.xml", "*.ini"};
    private UpgradeInfoGroup upgradeInfo;
    private Text dataPackageText;
    private FileField tsFileField;
    private FileField usbFileField;
    private Button usbButton;
    private Button tsButton;
    private final String[] contants = new String[]{"ALL", "TS_PACKAGE", "USB_PACKAGE"};

    public HiLoaderComposite(Composite parent, int style) {
        super(parent, style);
    }

    private void createTsGroup(Composite parent, String path) {
        Composite tsGroup = this.createGroup(parent, Messages.HiLoaderComposite_49, 4);
        tsGroup.setLayout((Layout)new GridLayout(1, false));
        Composite controlSectionComposite = new Composite(tsGroup, 0);
        controlSectionComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 1, true, false);
        controlSectionComposite.setLayoutData((Object)gridData);
        Label dataPackageLabel = new Label(controlSectionComposite, 0);
        dataPackageLabel.setText(Messages.ControlInformationInsertionFrequencyTitle);
        dataPackageLabel.setToolTipText(Messages.ControlInformationInsertionFrequencyTip);
        GridData gd = new GridData();
        gd.widthHint = 235;
        dataPackageLabel.setLayoutData((Object)gd);
        this.dataPackageText = new Text(controlSectionComposite, 2052);
        this.dataPackageText.setText("100");
        GridData dataPackageTextGd = new GridData();
        dataPackageTextGd.widthHint = 120;
        this.dataPackageText.setLayoutData((Object)dataPackageTextGd);
        Composite FileComposite = new Composite(tsGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        FileComposite.setLayout((Layout)layout);
        FileComposite.setLayoutData((Object)new GridData(768));
        this.tsFileField = new FileField(FileComposite, Messages.HiLoaderComposite_50, 100, Messages.HiLoaderComposite_51, 80, 0x10002000, "tsFileField");
        if (path == null) {
            this.tsFileField.setDefaultFileName(GlobleControler.intance.HISI_TS);
        } else {
            this.tsFileField.setDefaultFileName(path);
        }
        this.tsFileField.setFileExtensions(new String[]{"*.ts", "*.*"});
        this.tsButton = ControlFactory.createPushButton(FileComposite, Messages.HiLoaderComposite_53);
        this.tsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!HiLoaderComposite.this.validateInput(HiLoaderComposite.this.contants[1])) {
                    return;
                }
                String file = HiLoaderComposite.this.tsFileField.getFilePath();
                if (!FileUtil.isContinue(file)) {
                    return;
                }
                ArrayList<UpgradeFileInfo> selUpdateFiles = new ArrayList<UpgradeFileInfo>();
                int i = 0;
                while (i < HiLoaderComposite.this.updateFiles.size()) {
                    UpgradeFileInfo fileInfo = (UpgradeFileInfo)HiLoaderComposite.this.updateFiles.get(i);
                    if (fileInfo.isSel()) {
                        selUpdateFiles.add(fileInfo);
                    }
                    ++i;
                }
                String dataPackageStr = HiLoaderComposite.this.dataPackageText.getText();
                if (!HiLoaderComposite.this.valiDataPackageInput(dataPackageStr)) {
                    return;
                }
                if (selUpdateFiles.size() > 0) {
                    int dataPackage = Integer.parseInt(dataPackageStr);
                    UpgradeInfo info = HiLoaderComposite.this.upgradeInfo.getInput();
                    info.setDataPackage(dataPackage);
                    GlobleControler.runner.createRunnerJob("Packaged Ts (HISI) ", selUpdateFiles, info, file, new HisiTsPackageBuilder());
                } else {
                    HiLoaderComposite.this.showError(Messages.SELECTFILE);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GlobleControler.intance.addRunnerStateChangedListener(this);
    }

    private void createUsbGroup(Composite parent, String path) {
        String title = Messages.HiLoaderComposite_56;
        Composite group = this.createGroup(parent, title, 4);
        this.usbFileField = new FileField(group, Messages.HiLoaderComposite_57, 100, Messages.HiLoaderComposite_58, 80, 0x10002000, "usbFileField");
        if (path == null) {
            this.usbFileField.setDefaultFileName(GlobleControler.intance.HISI_USB);
        } else {
            this.usbFileField.setDefaultFileName(path);
        }
        this.usbFileField.setFileExtensions(new String[]{"*.bin", "*.*"});
        this.usbButton = ControlFactory.createPushButton(group, Messages.HiLoaderComposite_59);
        this.usbButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!HiLoaderComposite.this.validateInput(HiLoaderComposite.this.contants[2])) {
                    return;
                }
                String file = HiLoaderComposite.this.usbFileField.getFilePath();
                if (!FileUtil.isContinue(file)) {
                    return;
                }
                ArrayList<UpgradeFileInfo> selUpdateFiles = new ArrayList<UpgradeFileInfo>();
                int i = 0;
                while (i < HiLoaderComposite.this.updateFiles.size()) {
                    UpgradeFileInfo fileInfo = (UpgradeFileInfo)HiLoaderComposite.this.updateFiles.get(i);
                    if (fileInfo.isSel()) {
                        selUpdateFiles.add(fileInfo);
                    }
                    ++i;
                }
                if (selUpdateFiles.size() > 0) {
                    UpgradeInfo info = HiLoaderComposite.this.upgradeInfo.getInput();
                    GlobleControler.runner.createRunnerJob("Package Usb Ts (HISI)", selUpdateFiles, info, file, new HisiUsbPackageBuilder());
                } else {
                    HiLoaderComposite.this.showError(Messages.SELECTFILE);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Composite createGroup(Composite parent, String title, int num) {
        return ControlFactory.createGroup(parent, title, num);
    }

    protected void createUpgradeInfoGroup(Composite container) {
        Composite group = this.createGroup(container, Messages.UpgradeInfoGroup_0, 8);
        this.upgradeInfo = new UpgradeInfoGroup(group);
    }

    @Override
    protected void saveIni(String path) {
        if (!this.validateInput(this.contants[0])) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setFilterNames(INI_FILTER_NAMES);
        dlg.setFilterExtensions(INI_FILTER_EXTS);
        dlg.setFileName(path);
        dlg.setOverwrite(true);
        String filename = dlg.open();
        if (filename != null && !filename.isEmpty()) {
            if (filename.toUpperCase().lastIndexOf("INI") > 0) {
                String tsfile = this.tsFileField.getFilePath();
                String usbfile = this.usbFileField.getFilePath();
                try {
                    Ini ini = new Ini();
                    Profile.Section fileSection = ini.add("packer_tsfilename");
                    fileSection.put((Object)"ts_file_name", (Object)StringUtil.addQuote(tsfile));
                    fileSection.put((Object)"usb_file_name", (Object)StringUtil.addQuote(usbfile));
                    Profile.Section attrSec = ini.add("packer_attr");
                    attrSec.put((Object)"Download_PID", (Object)StringUtil.convertString(this.upgradeInfo.getDownloadPid(), 2));
                    attrSec.put((Object)"Download_TableId", (Object)StringUtil.convertString(this.upgradeInfo.getDownloadTableId(), 2));
                    attrSec.put((Object)"STB_manufacturerID", (Object)StringUtil.convertString(this.upgradeInfo.getManufacturerId(), 4));
                    attrSec.put((Object)"hardware_version", (Object)StringUtil.convertString(this.upgradeInfo.getHardwareVersion(), 8));
                    attrSec.put((Object)"software_version", (Object)StringUtil.convertString(this.upgradeInfo.getSoftwareVersion(), 8));
                    attrSec.put((Object)"start_sn", (Object)StringUtil.convertString(this.upgradeInfo.getStartSn(), 8));
                    attrSec.put((Object)"end_sn", (Object)StringUtil.convertString(this.upgradeInfo.getEndSn(), 8));
                    Profile.Section fileSec = ini.add("packer_file");
                    fileSec.put("bin_file_num", (Object)this.updateFiles.size());
                    int i = 1;
                    while (i <= this.updateFiles.size()) {
                        UpgradeFileInfo f = (UpgradeFileInfo)this.updateFiles.get(i - 1);
                        String sel = null;
                        sel = f.isSel() ? "1" : "0";
                        fileSec.put((Object)("flash_sel" + i), (Object)sel);
                        fileSec.put((Object)("flash_PartitionName" + i), (Object)f.getPartitionName());
                        fileSec.put("flash_PartitionVersion" + i, (Object)f.getPartitionVersion());
                        fileSec.put("flash_PartitionVersionTag" + i, (Object)f.getPartitionVerifyTag());
                        fileSec.put((Object)("bin_name" + i), (Object)StringUtil.addQuote(f.getFileName()));
                        fileSec.put((Object)("flash_addr" + i), (Object)StringUtil.toHexString(f.getStartAddress(), 8));
                        fileSec.put("flash_type" + i, (Object)f.getFlashType().ordinal());
                        fileSec.put((Object)("flash_system" + i), (Object)f.getFileSystem().name());
                        fileSec.put("flashindex" + i, (Object)f.getFlashIndex());
                        fileSec.put("file_length" + i, (Object)f.getLength());
                        ++i;
                    }
                    ini.store(new File(filename));
                    this.showMessage(Messages.HiLoaderComposite_85);
                }
                catch (IOException e) {
                    this.showError(Messages.HiLoaderComposite_12);
                }
            } else if (filename.toUpperCase().lastIndexOf("XML") > 0) {
                try {
                    File out = new File(filename);
                    ArrayList<PartitionItem> hiburn = new ArrayList<PartitionItem>();
                    int i = 0;
                    while (i < this.updateFiles.size()) {
                        UpgradeFileInfo f = (UpgradeFileInfo)this.updateFiles.get(i);
                        f.validateFileName();
                        PartitionItem item = new PartitionItem();
                        item.setChecked(f.isSel());
                        item.setFile(new File(f.getFileName()));
                        item.setFileSystem(f.getFileSystem());
                        item.setFlashType(f.getFlashType());
                        item.setLength(f.getLength());
                        item.setName(f.getPartitionName());
                        item.setStart(f.getStartAddress());
                        item.setPartitionVersione(f.getPartitionVersion());
                        item.setPartitionVersionTag(f.getPartitionVerifyTag());
                        hiburn.add(item);
                        ++i;
                    }
                    PartitionItem.save(out, hiburn);
                    this.showMessage(Messages.HiLoaderComposite_85);
                }
                catch (Exception e) {
                    this.showError(Messages.HiLoaderComposite_12);
                }
            }
        }
    }

    @Override
    protected String loadIni() {
        FileDialog dlg = new FileDialog(this.getShell(), 4100);
        dlg.setFilterNames(INI_FILTER_NAMES);
        dlg.setFilterExtensions(INI_FILTER_EXTS);
        String fileName = dlg.open();
        if (fileName != null && !fileName.isEmpty()) {
            if (fileName.toUpperCase().endsWith("INI")) {
                try {
                    IniFileParser parser = new IniFileParser(fileName);
                    this.tsFileField.setDefaultFileName(GlobleControler.intance.HISI_TS);
                    this.usbFileField.setDefaultFileName(GlobleControler.intance.HISI_USB);
                    this.upgradeInfo.setInput(parser, parser.getUpgradeInfo());
                    this.updateFiles = parser.getUpgradFiles();
                }
                catch (InvalidDataFormatException e) {
                    this.showError(e.getMessage());
                }
                catch (Exception e) {
                    this.showError(Messages.HiLoaderComposite_86);
                }
                return fileName;
            }
            if (fileName.toUpperCase().endsWith("XML")) {
                List<PartitionItem> load = null;
                try {
                    load = PartitionItem.load(new File(fileName), true);
                }
                catch (DocumentException e) {
                    this.showError(Messages.XMLINVALID);
                }
                if (load == null) {
                    return "";
                }
                if (load.isEmpty()) {
                    try {
                        throw new DocumentException();
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    IniFileParser parser = new IniFileParser(load);
                    if (this.tsFileField != null) {
                        this.tsFileField.setDefaultFileName(GlobleControler.intance.HISI_TS);
                    }
                    this.usbFileField.setDefaultFileName(GlobleControler.intance.HISI_USB);
                    this.upgradeInfo.setInput(parser, parser.getUpgradeInfo());
                    this.updateFiles = parser.getUpgradFiles();
                }
                catch (InvalidFileFormatException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidDataFormatException e) {
                    e.printStackTrace();
                }
                return fileName;
            }
            return "";
        }
        return "";
    }

    private boolean valiDataPackageInput(String dataPackageStr) {
        if (dataPackageStr.isEmpty()) {
            this.showError(NLS.bind((String)Messages.FileSize_Null, (Object)Messages.ControlInformationInsertionFrequency));
            return false;
        }
        try {
            int dataPackage = Integer.parseInt(dataPackageStr);
            if (dataPackage < 5 || dataPackage > 200) {
                this.showError(NLS.bind((String)Messages.DataPackageError, (Object)Messages.ControlInformationInsertionFrequency));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showError(Messages.DataPackageError);
            return false;
        }
        return true;
    }

    private boolean validateInput(String type) {
        if (this.updateFiles.size() == 0) {
            this.showError(Messages.HiLoaderComposite_87);
            return false;
        }
        if (!FileHelper.checkUpgradeFileInfo(this.updateFiles)) {
            return false;
        }
        if (this.updateFiles.size() > 64) {
            String message = String.format(Messages.HiLoaderComposite_88, 64);
            this.showError(message);
            return false;
        }
        for (UpgradeFileInfo file : this.updateFiles) {
            try {
                FileUtil.checkAddressConflict(file, this.updateFiles);
            }
            catch (InvalidDataFormatException e) {
                this.showError(e.getMessage());
                return false;
            }
        }
        if (!this.upgradeInfo.hasInputText()) {
            return false;
        }
        if (!this.upgradeInfo.validateInput()) {
            return false;
        }
        if (this.tsFileField != null) {
            if (!(!type.equals(this.contants[0]) || this.tsFileField.hasInputText(Messages.HiLoaderComposite_5) && this.usbFileField.hasInputText(Messages.HiLoaderComposite_60))) {
                return false;
            }
            if (type.equals(this.contants[1]) && !this.tsFileField.hasInputText(Messages.HiLoaderComposite_5)) {
                return false;
            }
        }
        return !type.equals(this.contants[2]) || this.usbFileField.hasInputText(Messages.HiLoaderComposite_60);
    }

    @Override
    public void createLoaderContents(Composite comp) {
        String value;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (screenHeight <= 768) {
            this.createPartFileContentControl(comp, 180);
        } else {
            this.createPartFileContentControl(comp, 380);
        }
        this.createUpgradeInfoGroup(comp);
        String tsPath = null;
        String usbPath = null;
        ArrayList<String> pathList = FileField.loadFilterPath("tempPath.ini");
        for (String str : pathList) {
            if (str.startsWith("hisitspath")) {
                tsPath = str.split("=")[1];
                continue;
            }
            if (!str.startsWith("hisiusbpath")) continue;
            usbPath = str.split("=")[1];
        }
        Object object = comp.getParent().getData("SUPPORTTS");
        if (object != null && object instanceof String && (value = (String)object).equals("YES")) {
            this.createTsGroup(comp, tsPath);
        }
        this.createUsbGroup(comp, usbPath);
    }

    @Override
    protected String[] getChipList() {
        return CHIPS;
    }

    @Override
    public void start() {
        if (this.tsButton != null) {
            if (this.tsButton.isDisposed()) {
                return;
            }
            this.tsButton.setEnabled(false);
        }
        if (this.usbButton != null) {
            if (this.usbButton.isDisposed()) {
                return;
            }
            this.usbButton.setEnabled(false);
        }
    }

    @Override
    public void stop() {
        if (this.tsButton != null) {
            if (this.tsButton.isDisposed()) {
                return;
            }
            this.tsButton.setEnabled(true);
        }
        if (this.usbButton != null) {
            if (this.usbButton.isDisposed()) {
                return;
            }
            this.usbButton.setEnabled(true);
        }
    }
}

