/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.ui.AbstractComposite;
import com.hisilicon.hiloader.ui.ControlFactory;
import com.hisilicon.hiloader.ui.FileField;
import com.hisilicon.hiloader.ui.ssu.SsuUpgradeInfoGroup;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.InvalidDataFormatException;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import com.hisilicon.hiloader.util.ssu.SsusaTsPackageBuilder;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SsuaHiLoaderComposite
extends AbstractComposite {
    private static final String[] CHIPS = new String[]{"chip 0"};
    private SsuUpgradeInfoGroup upgradeInfo;
    private FileField videoField;
    private FileField upgradeField;
    private Text insertNumberValue;
    private FileField tsFileField;
    private Button ssuTsButton;
    private static final int min = 1;
    private static final int max = 9999;
    private static final int integerBits = 4;
    private static final int fractionalBits = 4;

    public SsuaHiLoaderComposite(Composite parent, int style) {
        super(parent, style);
    }

    private void createTsGroup(Composite parent) {
        String title = Messages.HiLoaderComposite_49;
        Composite group = this.createGroup(parent, title, 4);
        this.tsFileField = new FileField(group, Messages.HiLoaderComposite_50, 150, Messages.HiLoaderComposite_51, 80, 0x10002000, "tsFileField");
        this.tsFileField.setDefaultFileName(GlobleControler.intance.SSUA_TS);
        this.tsFileField.setFileExtensions(new String[]{"*_ssu.ts", "*.*"});
        this.ssuTsButton = ControlFactory.createPushButton(group, Messages.HiLoaderComposite_53);
        this.ssuTsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String videoFile;
                if (!SsuaHiLoaderComposite.this.validateInput()) {
                    return;
                }
                String file = SsuaHiLoaderComposite.this.tsFileField.getFilePath();
                if (!FileUtil.isContinue(file)) {
                    return;
                }
                if (SsuaHiLoaderComposite.this.updateFiles.size() > 0) {
                    SsuaHiLoaderComposite.this.updateFiles.clear();
                }
                if ((videoFile = SsuaHiLoaderComposite.this.videoField.getFilePath()) == null || videoFile.isEmpty()) {
                    MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.InvalidFileName);
                    return;
                }
                File tempFile = new File(videoFile);
                if (!tempFile.exists()) {
                    MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.InvalidFileName);
                    return;
                }
                UpgradeFileInfo fileInfo = new UpgradeFileInfo();
                fileInfo.setFileName(videoFile);
                SsuaHiLoaderComposite.this.updateFiles.add(fileInfo);
                String upgradeFile = SsuaHiLoaderComposite.this.upgradeField.getFilePath();
                if (upgradeFile == null || upgradeFile.isEmpty()) {
                    MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.InvalidFileName);
                    return;
                }
                File tempFile2 = new File(upgradeFile);
                if (!tempFile2.exists()) {
                    MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.InvalidFileName);
                    return;
                }
                fileInfo = new UpgradeFileInfo();
                fileInfo.setFileName(upgradeFile);
                SsuaHiLoaderComposite.this.updateFiles.add(fileInfo);
                SsuUpgradeInfo info = SsuaHiLoaderComposite.this.upgradeInfo.getInput();
                SsuPackageOptions packageOtions = new SsuPackageOptions();
                try {
                    packageOtions.setNumberUpgradeFile(Integer.parseInt(SsuaHiLoaderComposite.this.insertNumberValue.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    packageOtions.setNumberUpgradeFile(3);
                }
                int numberUpgradeFile = packageOtions.getNumberUpgradeFile();
                long videoFileLength = new File(videoFile).length();
                long updateFileLength = new File(upgradeFile).length();
                if (videoFileLength < updateFileLength * (long)numberUpgradeFile) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.SsuaUpgradeInfoGroup_FileLengthError);
                        }
                    });
                    return;
                }
                GlobleControler.runner.createRunnerJob("Packaged Ts (SSU FROM ANDROID)", SsuaHiLoaderComposite.this.updateFiles, info, packageOtions, file, new SsusaTsPackageBuilder());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Composite createGroup(Composite parent, String title, int num) {
        return ControlFactory.createGroup(parent, title, num);
    }

    protected void createPackageOptions(Composite container) {
        Composite group = this.createGroup(container, Messages.PackageOptions, 10);
        group.setLayout((Layout)new GridLayout(6, true));
        GridData gridData = new GridData(4, 1, true, false);
        group.setLayoutData((Object)gridData);
        Label insertNumber = new Label(group, 0);
        insertNumber.setText(Messages.HiLoaderComposite_91);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)insertNumber);
        this.insertNumberValue = new Text(group, 16779268);
        this.setVerifyIntText(this.insertNumberValue, Messages.HiLoaderComposite_91, 1, 9999L, 4, 4);
        this.insertNumberValue.setTextLimit(4);
        this.insertNumberValue.setText("3");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.insertNumberValue);
    }

    protected void createUpgradeInfoGroup(Composite container) {
        Composite group = this.createGroup(container, Messages.UpgradeInfoGroup_0, 8);
        this.upgradeInfo = new SsuUpgradeInfoGroup(group);
    }

    private boolean validateInput() {
        for (UpgradeFileInfo file : this.updateFiles) {
            try {
                FileUtil.checkAddressConflict(file, this.updateFiles);
            }
            catch (InvalidDataFormatException e) {
                this.showError(e.getMessage());
                return false;
            }
        }
        if (!this.upgradeInfo.hasInputText()) {
            return false;
        }
        if (!this.upgradeInfo.validateInput()) {
            return false;
        }
        return this.tsFileField.hasInputText(Messages.HiLoaderComposite_5);
    }

    @Override
    public void createLoaderContents(Composite comp) {
        this.createUpgradeOptions(comp);
        this.createUpgradeInfoGroup(comp);
        this.createPackageOptions(comp);
        this.createTsGroup(comp);
    }

    protected void createUpgradeOptions(Composite parent) {
        this.updateFiles = new ArrayList();
        String title = Messages.HiLoaderComposite_43;
        Composite group = this.createGroup(parent, title, 3);
        this.videoField = new FileField(group, Messages.HiLoaderComposite_89, 150, Messages.HiLoaderComposite_51, 80, 0x10001000, "videoField");
        this.upgradeField = new FileField(group, Messages.HiLoaderComposite_90, 150, Messages.HiLoaderComposite_51, 80, 0x10001000, "upgradeField");
    }

    private void setVerifyIntText(final Text fileSize, final String title, final int min, final long max, int integerBits, final int fractionalBits) {
        fileSize.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String verifyText = fileSize.getText();
                double size = 0.0;
                try {
                    String[] result;
                    if (verifyText.length() == 0) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Null, (Object)title));
                        fileSize.setFocus();
                        return;
                    }
                    if (verifyText.startsWith(".")) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSize_Value);
                        fileSize.setFocus();
                        return;
                    }
                    size = Double.parseDouble(verifyText);
                    if (size < (double)min) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Minimum, (Object)min));
                        fileSize.setFocus();
                        return;
                    }
                    if (size > (double)max) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.FileSize_Maximum, (Object)max));
                        fileSize.setFocus();
                        return;
                    }
                    if (verifyText.indexOf(".") > 0 && (result = verifyText.split("\\."))[1].length() > fractionalBits) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.CableModuValue);
                        fileSize.setFocus();
                        return;
                    }
                    if (title.equals(Messages.TerrestrialCentreFrequency) && size % 10.0 != 0.0) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSizeMultiples);
                        fileSize.setFocus();
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.FileSize_Value);
                    fileSize.setFocus();
                    return;
                }
            }
        });
    }

    @Override
    public void start() {
        if (this.ssuTsButton.isDisposed()) {
            return;
        }
        this.ssuTsButton.setEnabled(false);
    }

    @Override
    public void stop() {
        if (this.ssuTsButton.isDisposed()) {
            return;
        }
        this.ssuTsButton.setEnabled(true);
    }

    @Override
    protected String[] getChipList() {
        return CHIPS;
    }

    @Override
    protected void saveIni(String path) {
    }

    @Override
    protected String loadIni() {
        return null;
    }
}

