/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomFileOutputStream
extends OutputStream {
    private RandomAccessFile out;
    private int offset;

    public RandomFileOutputStream(String filename) throws IOException {
        this.out = new RandomAccessFile(filename, "rw");
        this.out.seek(0L);
        this.offset = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.offset;
        this.outputChanged();
    }

    private void outputChanged() {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.offset += b.length;
        this.outputChanged();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.offset += len;
        this.outputChanged();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long getPosition() throws IOException {
        return this.out.getFilePointer();
    }

    public void setPostion(long pos) throws IOException {
        this.out.seek(pos);
    }

    public void skip(int n) throws IOException {
        int i = 0;
        while (i < n) {
            this.out.write(0);
            ++i;
        }
    }
}

