/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModule;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinTable;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import java.nio.ByteOrder;

public class BinItem {
    protected static final int ONE_BYTE_SIZE = 1;
    protected static final int SHORT_SIZE = 2;
    protected static final int THREE_BYTE_SIZE = 3;
    public static final int INT_SIZE = 4;
    protected BinModule mModuleRef;
    protected BinTable mTableRef;
    protected int offsetAddress;
    protected int value;
    protected int delay;
    protected RegBinAction writeOrRead;
    protected int bits;
    protected int startBit;
    protected boolean hasExport = false;

    public BinItem(BinModule parentModule, BinTable parentTable) {
        this.mModuleRef = parentModule;
        this.mTableRef = parentTable;
    }

    public BinItem() {
    }

    public int calculateOffsetAddress(int regAbsoluteAddr) {
        return BytesArrayUtils.get1LowBytesFromInt(regAbsoluteAddr);
    }

    public int getOffsetAddress() {
        return this.offsetAddress;
    }

    public void setOffsetAddress(int offsetAddress) {
        this.offsetAddress = offsetAddress;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public RegBinAction getWriteOrRead() {
        return this.writeOrRead;
    }

    public void setWriteOrRead(RegBinAction writeOrRead) {
        this.writeOrRead = writeOrRead;
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getStartBit() {
        return this.startBit;
    }

    public void setStartBit(int startBit) {
        this.startBit = startBit;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isHasExport() {
        return this.hasExport;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    protected int getIntValueBitCount(int value) {
        if (value == 0) {
            return 0;
        }
        if (value > 0 && value <= 255) {
            return 1;
        }
        if (value > 255 && value <= 65535) {
            return 2;
        }
        if (value > 65535 && value <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    protected int setIntValueBitCount(int value) {
        if (value == 0) {
            return 0;
        }
        if (value > 0 && value <= 255) {
            return 1;
        }
        if (value > 255 && value <= 65535) {
            return 2;
        }
        if (value > 65535 && value <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    public int getBytesSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        size += this.getIntValueBitCount(this.value);
        return size += this.getIntValueBitCount(this.delay);
    }

    public int fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        this.offsetAddress = buffer[pointer] & 0xFC;
        this.writeOrRead = RegBinAction.values()[buffer[pointer] & 1];
        int valueBitLen = (buffer[++pointer] & 0xE0) >> 5;
        this.startBit = buffer[pointer] & 0x1F;
        int delayBitLen = (buffer[++pointer] & 0xE0) >> 5;
        this.bits = buffer[pointer] & 0x1F;
        ++pointer;
        if (valueBitLen != 0) {
            if (valueBitLen == 1) {
                this.value = buffer[pointer] & 0xFF;
                ++pointer;
            } else if (valueBitLen == 2) {
                this.value = BytesArrayUtils.getShort(buffer, pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
                pointer += 2;
            } else if (valueBitLen == 3) {
                this.value = BytesArrayUtils.getIntFor3bytes(buffer, pointer, ByteOrder.BIG_ENDIAN, false) & 0xFFFFFF;
                pointer += 3;
            } else {
                this.value = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
        } else {
            this.value = 0;
        }
        if (delayBitLen != 0) {
            if (delayBitLen == 1) {
                this.delay = buffer[pointer] & 0xFF;
                ++pointer;
            } else if (delayBitLen == 2) {
                this.delay = BytesArrayUtils.getShort(buffer, pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
                pointer += 2;
            } else if (delayBitLen == 3) {
                this.delay = BytesArrayUtils.getIntFor3bytes(buffer, pointer, ByteOrder.BIG_ENDIAN, false) & 0xFFFFFF;
                pointer += 3;
            } else {
                this.delay = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
        } else {
            this.delay = 0;
        }
        return pointer - offset;
    }

    public int toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        int offsetAddressBits = this.offsetAddress & 0xFC;
        int reservedBit = 0;
        int writeOrReadBit = this.writeOrRead.ordinal() & 1;
        buffer[pointer] = (byte)(offsetAddressBits | reservedBit | writeOrReadBit);
        int valueBitLen = (this.getIntValueBitCount(this.value) & 7) << 5;
        int offsetBit = this.startBit & 0x1F;
        buffer[++pointer] = (byte)(valueBitLen | offsetBit);
        int delayBitLen = (this.getIntValueBitCount(this.delay) & 7) << 5;
        int bit = this.bits & 0x1F;
        buffer[++pointer] = (byte)(delayBitLen | bit);
        ++pointer;
        if (valueBitLen != 0) {
            int value = this.value;
            int valueBitCount = this.getIntValueBitCount(this.value);
            if (valueBitCount == 1) {
                buffer[pointer] = (byte)(value & 0xFF);
                ++pointer;
            } else if (valueBitCount == 2) {
                BytesArrayUtils.setShort(buffer, pointer, (short)(value & 0xFFFF), ByteOrder.BIG_ENDIAN);
                pointer += 2;
            } else if (valueBitCount == 3) {
                BytesArrayUtils.setIntFor3bytes(buffer, pointer, value & 0xFFFFFF, ByteOrder.BIG_ENDIAN, false);
                pointer += 3;
            } else {
                BytesArrayUtils.setInt(buffer, pointer, value, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
        }
        if (delayBitLen != 0) {
            int delay = this.delay;
            int delayBitCount = this.getIntValueBitCount(this.delay);
            if (delayBitCount == 1) {
                buffer[pointer] = (byte)(delay & 0xFF);
                ++pointer;
            } else if (delayBitCount == 2) {
                BytesArrayUtils.setShort(buffer, pointer, (short)(delay & 0xFFFF), ByteOrder.BIG_ENDIAN);
                pointer += 2;
            } else if (delayBitCount == 3) {
                BytesArrayUtils.setIntFor3bytes(buffer, pointer, delay & 0xFFFFFF, ByteOrder.BIG_ENDIAN, false);
                pointer += 3;
            } else {
                BytesArrayUtils.setInt(buffer, pointer, delay, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
        }
        return pointer - offset;
    }

    public BinModule getmModuleRef() {
        return this.mModuleRef;
    }

    public void setmModuleRef(BinModule mModuleRef) {
        this.mModuleRef = mModuleRef;
    }

    public BinTable getmTableRef() {
        return this.mTableRef;
    }

    public void setmTableRef(BinTable mTableRef) {
        this.mTableRef = mTableRef;
    }
}

