/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

public class BitUtils {
    private static final int HEX = 16;

    public static final int parseLongToInt32(String str, boolean isHex) {
        if (isHex) {
            str = BitUtils.remove0xHexStr(str);
            Long longValue = Long.parseLong(str, 16);
            return longValue.intValue();
        }
        Long longValue = Long.parseLong(str);
        return longValue.intValue();
    }

    public static String remove0xHexStr(String hexStr) {
        if (hexStr.startsWith("0x")) {
            hexStr = hexStr.substring(hexStr.indexOf("0x") + "0x".length());
        }
        return hexStr;
    }

    public static final int getStartBit(int value) {
        int startBit = 0;
        int compare = value;
        while (compare != 0) {
            if ((compare & 1) == 1) {
                return startBit;
            }
            compare >>>= 1;
            ++startBit;
        }
        return -1;
    }

    public static final int getEndBit(int value) {
        int endBit = 31;
        int compare = value;
        while (compare != 0) {
            if ((compare & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                return endBit;
            }
            compare <<= 1;
            --endBit;
        }
        return -1;
    }

    public static final int getMask(int startBit, int endBit) {
        int valueLeft = -1 << startBit;
        int valueRight = -1 >>> 31 - endBit;
        return valueLeft & valueRight;
    }

    public static byte[] genBytesWithZero(int length) {
        byte[] dst = new byte[length];
        int i = 0;
        while (i < length) {
            dst[i] = 0;
            ++i;
        }
        return dst;
    }
}

