/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.exception.InvalidExcelException;
import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.CAConfig;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.Layers;
import com.hisilicon.hiregbin.model.reg.NetworkConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelDefinition;
import com.hisilicon.hiregbin.model.reg.excel.ExcelMainData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelWorkbookInfo;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrParam;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrPhy;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrType;
import com.hisilicon.hiregbin.model.reg.excel.MainModelParam;
import com.hisilicon.hiregbin.model.reg.excel.MainNetconfig;
import com.hisilicon.hiregbin.model.reg.excel.MainPackage;
import com.hisilicon.hiregbin.model.reg.excel.MainRegInfo;
import com.hisilicon.hiregbin.model.reg.excel.MainStartup;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.MultiperTable;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.XLSXCovertCSVReader;
import com.hisilicon.hiregbin.views.RegbinView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class ExcelDataHelper {
    public static final String CELL_KEY_REG_FORMAT_VERSION = "reg format version";
    public static final String CELL_KEY_XLS_VERSION = "xls version";
    public static final String CELL_KEY_REG_BASE_NAME = "reg base name";
    public static final String CELL_KEY_WORKBOOK = "workbook";
    public static final String CELL_KEY_CONFIG_NUM = "configNum";
    public static final String CELL_KEY_DDRPARAM_NUM = "ddrParamNum";
    public static final String CELL_KEY_DDRPARAM_NAME = "ddrParamName";
    public static final String CELL_KEY_DDRPARAM_REGNAME = "regName";
    private static final String CELL_KEY_DDRPARAM_DDRCAPCITY = "DDRCapacity";
    private static final String CELL_KEY_DDRPARAM_DDRRANK0CAPACITY = "DDRRank0Capacity";
    public static final String CELL_KEY_DDRPARAM_DDRRANK1CAPACITY = "DDRRank1Capacity";
    public static final String CELL_KEY_DDRPHY_NUM = "ddrPhyNum";
    public static final String CELL_KEY_DDRPHY_NAME = "ddrPhyName";
    public static final String CELL_KEY_PACKAGE = "Package";
    public static final String CELL_KEY_PACKAGE_NUM = "packageNum";
    public static final String CELL_KEY_PACKAGE_NAME = "packageName";
    public static final String CELL_KEY_DDRType_NUM = "ddrTypeNum";
    public static final String CELL_KEY_DDRType_NAME = "ddrTypeName";
    public static final String CELL_KEY_MULTIPER_NUM = "multiperNum";
    public static final String CELL_KEY_multiper_ID = "multiperid";
    public static final String CELL_KEY_MULTIPER_DEFAULT_VOLTAGE = "defaultVoltage";
    public static final String CELL_KEY_STARTUP_NUM = "startupNum";
    public static final String CELL_KEY_STARTUP_NAME = "startup";
    public static final String CELL_KEY_PAGENAME = "pageName";
    public static final String CELL_KEY_NETCONFIG_NUM = "netconfigNum";
    public static final String CELL_KEY_NETCONFIG_NAME = "netconfig";
    public static final String CELL_KEY_NETCONFIG_PHYADDR = "phyAddr";
    public static final String CELL_KEY_NETCONFIG_RESETPIN = "resetPin";
    public static final String CELL_KEY_NETCONFIG_MODEL = "model";
    public static final String CELL_KEY_MODELCONFIG_NUM = "modelconfigNum";
    public static final String CELL_KEY_MODELCONFIG_NAME = "modelconfig";
    public static final String CELL_KEY_MODELCONFIG_MODEL = "regName";
    public static final String CELL_KEY_DEMOCONFIG_NUM = "demoNum";
    public static final String CELL_KEY_DEMOCONFIG_NAME = "demoName";
    public static final String CELL_KEY_DEMOCONFIG_BIT = "bit";
    public static final String CELL_KEY_DEMOCONFIG_LAYERS = "layers";
    public static final String CELL_KEY_DEMOCONFIG_CANOCA = "ca&noca";
    public static final String CELL_KEY_DEMOCONFIG_STARTUP = "startup";
    public static final String CELL_KEY_DEMOCONFIG_DDRType = "DDRType";
    public static final String CELL_KEY_DEMOCONFIG_VOL = "Vol_DVDD3318_1";
    public static final String CELL_KEY_DEMOCONFIG_PhyAddr = "PhyAddr";
    public static final String CELL_KEY_DEMOCONFIG_PACKAGE = "Package";
    public static final int DEMO_NAME_NUM = 30;
    public static final String CELL_KEY_DEMOCONFIG_Default_DDRCapacity = "Default_DDRCapacity";
    public static final String CELL_KEY_DEMOCONFIG_DDRPhy = "ddrPhyName";
    public static final String CELL_KEY_PACKAGE_BGA21X21 = "BGA21x21";
    public static final String CELL_KEY_PACKAGE_BGA15X15 = "BGA15x15";
    protected static final ArrayList<String> ddrParamNameList = new ArrayList();
    protected static final ArrayList<String> netConfigNameList = new ArrayList();
    public static final String CELL_KEY_GPIOCONFIG_NUM = "gpioNum";
    public static final String CELL_KEY_GPIOCONFIG_NAME = "gpioName";
    public static final String CELL_KEY_GPIOCONFIG_VALUE = "value";
    public static final int NEXT_LINE = 1;
    public static final String ENCODING = System.getProperty("file.encoding");
    public static final String EXECL_RANGE_SPLI = ":";
    public static final String XML_RANGE_SPLI = "~";
    public static final String UNDER_LINE = "_";
    public static final String LAYERS = "LAYERS";
    public static final int HEX = 16;
    public static final String HEX_STR = "0x";
    public static final int NULL_VALUE = -1;
    private static ExcelData excelData;
    private static ExcelData excelDataforImport;
    private static ParsedMainData parsedMainData;
    private static ParsedMainData demoParsedMainData;
    public static final String Excel_98CV200_REG_FORMAT_VERSION = "v120";
    public static final String Excel_3751V620_XLS_FORMAT_VERSION = "v135";
    public static final String DEFAULT_DDRTYPE = "ddrx";
    public static final String DEFAULT_DDRTYPE_MV330 = "DDR3";
    private static final int WORKBOOK_MAIN_COLUMN = 102;
    private static final int WORKBOOK_COLUMN = 8;
    private static final int DEMONUM = 21;
    private static final int WORKBOOK_PIN_MUX_DRV_COLUMN = 46;
    private static final int WORKBOOK_FP_PIN_MUX_DRV_COLUMN = 42;
    public static final int HI3796MV200_HI3716MV430_LIMITREGLENGTH = 10752;
    public static final int HI3796CV300_LIMITREGLENGTH = 10480;
    private static boolean checkGpioNotCorrect;
    private static String lackOfGpio;

    static {
        demoParsedMainData = null;
    }

    public static String getDdrcapcity() {
        if (RegbinView.isHi3796CV300Series()) {
            return CELL_KEY_DDRPARAM_DDRRANK0CAPACITY;
        }
        return CELL_KEY_DDRPARAM_DDRCAPCITY;
    }

    public static ParsedMainData toParsedMainDataNew(ExcelData excelData) {
        ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
        ParsedMainData parsedMainData = new ParsedMainData();
        ExcelMainData excelMainData = excelData.getExcelMainData();
        parsedMainData.setRegFormatVersion(excelMainData.getRegFormatVersion());
        parsedMainData.setXlsVersion(excelMainData.getXlsVersion());
        ExcelDataHelper.parsingDdrParam(excelWorkbookInfoList, parsedMainData, excelMainData);
        ExcelDataHelper.parsingStartup(parsedMainData, excelMainData);
        ExcelDataHelper.parsingNetconfig(excelWorkbookInfoList, parsedMainData, excelMainData);
        ExcelDataHelper.parsingDemoInfo(parsedMainData, excelMainData);
        ExcelDataHelper.parsingDdrType(parsedMainData, excelMainData);
        ExcelDataHelper.parsingDdrType(parsedMainData, excelMainData);
        ExcelDataHelper.parsingDdrPhy(parsedMainData, excelMainData);
        ArrayList<GpioData> gpioList = excelMainData.getGpioList();
        parsedMainData.setGpioList(gpioList);
        return parsedMainData;
    }

    private static void parsingDemoInfo(ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<DemoBaseParam> demoList = excelMainData.getDemoList();
        String ddrType = excelMainData.getDdrType();
        String chipName = excelMainData.getChipName();
        for (DemoBaseParam demoBaseParam : demoList) {
            Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
            for (Map.Entry<String, String> entry : dynamicParamMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.equalsIgnoreCase(ExcelDataHelper.getDdrcapcity())) continue;
                demoBaseParam.setDdrCapacity(value);
            }
            demoBaseParam.setDemoType(ddrType);
            demoBaseParam.setChipName(chipName);
        }
        parsedMainData.setDemoList(demoList);
    }

    private static void parsingNetconfig(ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList, ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
        int netconfigIndex = 0;
        while (netconfigIndex < mainNetconfigList.size()) {
            int regValue;
            String regName;
            BaseRegisterInfo baseRegisterInfo;
            ArrayList<BaseRegisterInfo> baseRegisterInfoList;
            String workbookName;
            MainNetconfig mainNetconfig = mainNetconfigList.get(netconfigIndex);
            String netMacName = mainNetconfig.getNetconfigName();
            MainRegInfo netPhyAddressReg = mainNetconfig.getNetPhyAddr();
            MainRegInfo netResetPinReg = mainNetconfig.getNetResetPin();
            ArrayList<String> netModelList = mainNetconfig.getNetModelList();
            NetworkConfig networkConfig = new NetworkConfig();
            networkConfig.setNetMacName(netMacName);
            for (String netModel : netModelList) {
                networkConfig.getNetMacValueList().add(netModel);
            }
            if (netPhyAddressReg != null) {
                String netPhyRegName = netPhyAddressReg.getRegName();
                String netPhyRegPage = netPhyAddressReg.getRegPage();
                if (netPhyRegName != null && netPhyRegPage != null) {
                    ExcelWorkbookInfo netPhyAddressRegWorkbook = null;
                    for (ExcelWorkbookInfo excelWorkbookInfo : excelWorkbookInfoList) {
                        workbookName = excelWorkbookInfo.getWorkbookName();
                        if (!workbookName.equalsIgnoreCase(netPhyRegPage)) continue;
                        netPhyAddressRegWorkbook = excelWorkbookInfo;
                        break;
                    }
                    if (netPhyAddressRegWorkbook != null) {
                        baseRegisterInfoList = netPhyAddressRegWorkbook.getBaseRegisterInfoList();
                        int index = 0;
                        while (index < baseRegisterInfoList.size()) {
                            baseRegisterInfo = baseRegisterInfoList.get(index);
                            regName = baseRegisterInfo.getRegName();
                            if (regName.equalsIgnoreCase(netPhyRegName)) {
                                regValue = baseRegisterInfo.getRegValue();
                                networkConfig.setNetPhyAddress(regValue);
                            }
                            ++index;
                        }
                    }
                } else {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckTempCurrentPageError, (Object)"main", (Object)netMacName));
                        }
                    });
                }
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckTempCurrentPageError, (Object)"main", (Object)netMacName));
                    }
                });
            }
            if (netResetPinReg != null) {
                String netResetRegName = netResetPinReg.getRegName();
                String netResetRegPage = netResetPinReg.getRegPage();
                if (netResetRegName != null && netResetRegPage != null) {
                    ExcelWorkbookInfo netResetRegWorkbook = null;
                    for (ExcelWorkbookInfo excelWorkbookInfo : excelWorkbookInfoList) {
                        workbookName = excelWorkbookInfo.getWorkbookName();
                        if (!workbookName.equalsIgnoreCase(netResetRegPage)) continue;
                        netResetRegWorkbook = excelWorkbookInfo;
                        break;
                    }
                    if (netResetRegWorkbook != null) {
                        baseRegisterInfoList = netResetRegWorkbook.getBaseRegisterInfoList();
                        int index = 0;
                        while (index < baseRegisterInfoList.size()) {
                            baseRegisterInfo = baseRegisterInfoList.get(index);
                            regName = baseRegisterInfo.getRegName();
                            if (netResetRegName.contains(regName)) {
                                regValue = baseRegisterInfo.getRegValue();
                                if (regName.endsWith("_BIT")) {
                                    int gpioBit = ExcelDataHelper.getGpioBit(regValue);
                                    networkConfig.setNetGpioBitNumber(gpioBit);
                                } else {
                                    int gpioGroup = ExcelDataHelper.getGpioGroup(regValue);
                                    networkConfig.setNetGpioGroupNumber(gpioGroup);
                                }
                            }
                            ++index;
                        }
                    }
                }
            }
            parsedMainData.getNetWorkConfigList().add(networkConfig);
            ++netconfigIndex;
        }
    }

    private static void parsingStartup(ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<String> startupList = new ArrayList<String>();
        ArrayList<MainStartup> mainStartupList = excelMainData.getMainStartupList();
        for (MainStartup mainStartup : mainStartupList) {
            String startupName = mainStartup.getStartupName();
            startupList.add(startupName);
        }
        parsedMainData.setStartupList(startupList);
    }

    private static void parsingDdrType(ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<String> ddrTypeList = new ArrayList<String>();
        ArrayList<MainDdrType> mainDdrTypeList = excelMainData.getMainddrTypeList();
        for (MainDdrType mainDdrType : mainDdrTypeList) {
            String ddrTypeName = mainDdrType.getDdrTypeName();
            ddrTypeList.add(ddrTypeName);
        }
        parsedMainData.setDdrTypeList(ddrTypeList);
    }

    private static void parsingDdrPhy(ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<String> ddrPhyList = new ArrayList<String>();
        ArrayList<MainDdrPhy> mainDdrPhyList = excelMainData.getMainDdrPhyList();
        for (MainDdrPhy mainDdrPhy : mainDdrPhyList) {
            String ddrPhyName = mainDdrPhy.getDdrPhyName();
            ddrPhyList.add(ddrPhyName);
        }
        parsedMainData.setDdrPhyList(ddrPhyList);
    }

    private static void parsingDdrParam(ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList, ParsedMainData parsedMainData, ExcelMainData excelMainData) {
        ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
        int paramIndex = 0;
        while (paramIndex < mainDdrParamList.size()) {
            ArrayList<BaseRegisterInfo> ddrParamRegisterInfoList = new ArrayList<BaseRegisterInfo>();
            MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
            String ddrParamName = mainDdrParam.getDdrParamName();
            ArrayList<MainRegInfo> ddrRegList = mainDdrParam.getDdrRegList();
            int regIndex = 0;
            while (regIndex < ddrRegList.size()) {
                MainRegInfo mainRegInfo = ddrRegList.get(regIndex);
                if (mainRegInfo != null) {
                    String regName = mainRegInfo.getRegName();
                    String regPage = mainRegInfo.getRegPage();
                    if (regName != null && regPage != null) {
                        ExcelWorkbookInfo currentWorkbookMddr = null;
                        for (ExcelWorkbookInfo excelWorkbookInfo : excelWorkbookInfoList) {
                            String workbookName = excelWorkbookInfo.getWorkbookName();
                            if (!workbookName.equalsIgnoreCase(regPage)) continue;
                            currentWorkbookMddr = excelWorkbookInfo;
                            break;
                        }
                        if (currentWorkbookMddr != null) {
                            int regPageBaseAddress = currentWorkbookMddr.getBaseAddress();
                            ArrayList<BaseRegisterInfo> baseRegisterInfoList = currentWorkbookMddr.getBaseRegisterInfoList();
                            int curRegIndex = 0;
                            while (curRegIndex < baseRegisterInfoList.size()) {
                                BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(curRegIndex);
                                String baseRegName = baseRegisterInfo.getRegName();
                                if (regName.equalsIgnoreCase(baseRegName)) {
                                    String regFunction = baseRegisterInfo.getRegFunction();
                                    for (BaseRegisterInfo mddrcRegisterInfo : ddrParamRegisterInfoList) {
                                        String ddrSSRegFunction = mddrcRegisterInfo.getRegFunction();
                                        if (ddrSSRegFunction.equalsIgnoreCase(regFunction)) break;
                                    }
                                    baseRegisterInfo.setRegAbsoluteAddress(regPageBaseAddress + baseRegisterInfo.getRegOffsetAddress());
                                    ddrParamRegisterInfoList.add(baseRegisterInfo);
                                }
                                ++curRegIndex;
                            }
                        }
                    }
                }
                ++regIndex;
            }
            parsedMainData.getComboParamRegInfoMap().put(ddrParamName, ddrParamRegisterInfoList);
            ++paramIndex;
        }
    }

    public static int getGpioGroup(int value) {
        return value & 0xFF;
    }

    public static int getGpioBit(int value) {
        return value & 0xFF;
    }

    private static String boolToYorNStr(boolean bool) {
        if (bool) {
            return "Y";
        }
        return "N";
    }

    public static String getHeaderCellValue(ExcelWorkbookInfo excelWorkbookInfo, int headerIndex) {
        switch (headerIndex) {
            case 0: {
                return excelWorkbookInfo.getModuleName();
            }
            case 1: {
                return HEX_STR + Integer.toHexString(excelWorkbookInfo.getBaseAddress());
            }
            case 2: {
                return String.valueOf(excelWorkbookInfo.getItem());
            }
            case 3: {
                return String.valueOf(excelWorkbookInfo.getPriority());
            }
            case 4: {
                return ExcelDataHelper.boolToYorNStr(excelWorkbookInfo.isExeForStandyWakeup());
            }
            case 5: {
                return ExcelDataHelper.boolToYorNStr(excelWorkbookInfo.isExeForNormalBoot());
            }
        }
        return null;
    }

    public static String getHeaderCellValueByPinDemux(PinDemuxHead pinDemuxHead, int headerIndex) {
        switch (headerIndex) {
            case 0: {
                return pinDemuxHead.getPinMuxModuleName();
            }
            case 1: {
                return HEX_STR + Integer.toHexString(pinDemuxHead.getPinMuxBaseAddress());
            }
            case 2: {
                return String.valueOf(pinDemuxHead.getPinMuxItem());
            }
            case 3: {
                return String.valueOf(pinDemuxHead.getPinMuxPriority());
            }
            case 4: {
                return ExcelDataHelper.boolToYorNStr(pinDemuxHead.isExeForStandyWakeup());
            }
            case 5: {
                return ExcelDataHelper.boolToYorNStr(pinDemuxHead.isExeForNormalBoot());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExcelData loadDataFromExcel(File file) throws IOException, InvalidExcelException, OpenXML4JException, ParserConfigurationException, SAXException {
        ExcelData excelData = new ExcelData();
        ExcelMainData loadWorkbookMainNew = ExcelDataHelper.loadWorkbookMainNew(excelData, file.getPath());
        if (loadWorkbookMainNew == null) {
            return null;
        }
        excelData.setExcelMainData(loadWorkbookMainNew);
        int demoNum = loadWorkbookMainNew.getDemoNum();
        if (demoNum > 30) {
            return null;
        }
        String workbookArray = loadWorkbookMainNew.getWorkbookArray();
        HashMap<String, ArrayList> map = ExcelDataHelper.parseGpioData(excelData, loadWorkbookMainNew);
        ArrayList parseGpioDataList = map.get("GpioParsedDataList");
        ArrayList gpioGroupName = map.get("GpioGroupName");
        excelData.setGpioParsedDataList(parseGpioDataList);
        ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
        String[] workbooks = workbookArray.split(",");
        int index = 0;
        while (index < workbooks.length) {
            block10: {
                String workbookName = workbooks[index];
                try {
                    if (workbookName != null && !workbookName.isEmpty()) {
                        if (workbookName.startsWith("pin_mux_drv".replace("\"", ""))) {
                            ExcelWorkbookInfo loadWorkbookPinMuxDrv = ExcelDataHelper.loadWorkbookPinMuxDrv(excelData, file.getPath(), workbookName, demoNum, gpioGroupName);
                            System.out.println(workbookName);
                            if (loadWorkbookPinMuxDrv == null) {
                                return null;
                            }
                            excelWorkbookInfoList.add(index, loadWorkbookPinMuxDrv);
                            break block10;
                        }
                        if (workbookName.equalsIgnoreCase("fp_pin_mux_drv".replace("\"", ""))) {
                            ExcelWorkbookInfo fpPinMuxDrvWorkbook = ExcelDataHelper.loadWorkbookFpPinMuxDrv(excelData, file.getPath(), workbookName, demoNum);
                            System.out.println(workbookName);
                            excelWorkbookInfoList.add(index, fpPinMuxDrvWorkbook);
                            break block10;
                        } else {
                            ExcelWorkbookInfo commonWorkbookInfo = ExcelDataHelper.loadWorkbookCommon(excelData, file.getPath(), workbookName);
                            System.out.println(workbookName);
                            excelWorkbookInfoList.add(index, commonWorkbookInfo);
                        }
                        break block10;
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckWorkbookAndNotFound, (Object)workbookName));
                        }
                    });
                    return null;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckWorkbookAndError, (Object)workbookName, (Object)e.getMessage()));
                        }
                    });
                    return null;
                }
            }
            ++index;
        }
        return excelData;
    }

    protected static HashMap<String, ArrayList> parseGpioData(ExcelData excelData, ExcelMainData workbookMain) {
        ArrayList<GpioData> gpioParsedDataList = excelData.getGpioParsedDataList();
        ArrayList<GpioData> gpioList = workbookMain.getGpioList();
        ArrayList<String> gpioGroupName = new ArrayList<String>();
        for (GpioData gpioParam : gpioList) {
            int gpioGroupAddress = gpioParam.getGpioGroupAddress();
            String gpioName = gpioParam.getGpioName();
            gpioGroupName.add(gpioName);
            GpioData gpioDIRParsedData = new GpioData();
            gpioDIRParsedData.setGpioName(String.valueOf(gpioName) + "_DIR");
            gpioDIRParsedData.setGpioAbsoluteAddr(gpioGroupAddress + 1024);
            gpioParsedDataList.add(gpioDIRParsedData);
        }
        Map<String, Integer> gpioXDataMap = GpioData.getGpioXDataMap();
        int i = 0;
        while (i < gpioList.size()) {
            GpioData gpioParam = gpioList.get(i);
            int gpioGroupAddress = gpioParam.getGpioGroupAddress();
            String gpioName = gpioParam.getGpioName();
            String gpioNum = gpioName.substring(4);
            if (gpioName.contains("AON_GPIO")) {
                gpioNum = gpioName.substring(8);
            }
            GpioData gpioParsedData = null;
            Iterator<Map.Entry<String, Integer>> iter = gpioXDataMap.entrySet().iterator();
            while (iter.hasNext()) {
                gpioParsedData = new GpioData();
                Map.Entry<String, Integer> entry = iter.next();
                String gpioNameKey = entry.getKey();
                int gpioOffset = entry.getValue();
                int gpioAbsoluteAddr = gpioGroupAddress + gpioOffset;
                String newGpioName = gpioNameKey.replace("X", gpioNum);
                gpioParsedData.setGpioAbsoluteAddr(gpioAbsoluteAddr);
                gpioParsedData.setGpioName(newGpioName);
                gpioParsedDataList.add(gpioParsedData);
            }
            ++i;
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.put("GpioParsedDataList", gpioParsedDataList);
        map.put("GpioGroupName", gpioGroupName);
        return map;
    }

    public static ExcelMainData loadWorkbookMainNew(ExcelData excelData, String filePath) throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        boolean needRegBaseName;
        ExcelMainData excelMainData = new ExcelMainData();
        ddrParamNameList.clear();
        netConfigNameList.clear();
        ZipSecureFile.setMinInflateRatio((double)0.001);
        List<String[]> workbookList = XLSXCovertCSVReader.readerExcel(filePath, "main", 102);
        boolean hasRegBaseName = false;
        int rowIndex = 0;
        while (rowIndex < workbookList.size()) {
            String fristCellKey;
            String[] cellArray = workbookList.get(rowIndex);
            if (cellArray != null && (fristCellKey = cellArray[0]) != null) {
                if (fristCellKey.equals(CELL_KEY_REG_FORMAT_VERSION)) {
                    String regFormatVersion = cellArray[2];
                    excelMainData.setRegFormatVersion(regFormatVersion);
                } else if (fristCellKey.equals(CELL_KEY_XLS_VERSION)) {
                    String xlsVersion = cellArray[2];
                    excelMainData.setXlsVersion(xlsVersion);
                } else if (fristCellKey.equals(CELL_KEY_REG_BASE_NAME)) {
                    String regBaseName = cellArray[2];
                    if (!regBaseName.equalsIgnoreCase(RegbinView.getCurrentChip())) {
                        hasRegBaseName = false;
                        return null;
                    }
                    hasRegBaseName = true;
                    excelMainData.setChipName(regBaseName);
                    if (RegbinView.isHi3716MV330Series()) {
                        excelMainData.setDdrType(DEFAULT_DDRTYPE_MV330);
                    } else {
                        excelMainData.setDdrType(DEFAULT_DDRTYPE);
                    }
                } else if (fristCellKey.equals(CELL_KEY_WORKBOOK)) {
                    String workbookArray = cellArray[2];
                    excelMainData.setWorkbookArray(workbookArray);
                } else if (fristCellKey.equals(CELL_KEY_DDRPARAM_NUM)) {
                    ExcelDataHelper.addDdrParamToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_STARTUP_NUM)) {
                    ExcelDataHelper.addStartupToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_NETCONFIG_NUM)) {
                    ExcelDataHelper.addNetConfigToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_MODELCONFIG_NUM)) {
                    ExcelDataHelper.addModelConfigToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_DEMOCONFIG_NUM)) {
                    ExcelDataHelper.addDemoToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_GPIOCONFIG_NUM)) {
                    ExcelDataHelper.addGpioToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_DDRType_NUM)) {
                    ExcelDataHelper.addDdrTypeToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_MULTIPER_NUM)) {
                    ExcelDataHelper.addMultiperToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_DDRPHY_NUM)) {
                    ExcelDataHelper.addDdrPhyToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else if (fristCellKey.equals(CELL_KEY_PACKAGE_NUM)) {
                    ExcelDataHelper.addPackageToMainData(workbookList, cellArray, excelMainData, rowIndex);
                } else {
                    System.out.println("fristCellKey: " + fristCellKey);
                }
            }
            ++rowIndex;
        }
        boolean bl = needRegBaseName = RegbinView.isHi3798CV200Series() || RegbinView.isHi3716MV330Series() || RegbinView.isHi3798MV200Series() || RegbinView.isHi3796MV200Series();
        if (needRegBaseName && !hasRegBaseName) {
            return null;
        }
        return excelMainData;
    }

    private static void addDdrParamToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int ddrDataRowNum;
        String ddrParamNumStr = cellArray[1];
        int ddrParamNum = Integer.parseInt(ddrParamNumStr);
        String[] ddrHeadRow = workbookList.get(rowIndex + 1);
        int ddrHeadRowNum = rowIndex + 1;
        ArrayList<String> ddrParamHeadList = new ArrayList<String>();
        int ddrHeadCellIndex = 0;
        while (ddrHeadCellIndex < ddrHeadRow.length) {
            String keyName = ddrHeadRow[ddrHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                ddrParamHeadList.add(keyName);
            }
            ++ddrHeadCellIndex;
        }
        int ddrParamRowIndex = ddrDataRowNum = ddrHeadRowNum + 1;
        while (ddrParamRowIndex < ddrDataRowNum + ddrParamNum) {
            String[] ddrParamDataRow = workbookList.get(ddrParamRowIndex);
            MainDdrParam mainDdrParam = new MainDdrParam();
            mainDdrParam.setDdrParamNum(ddrParamNum);
            int ddrDataCellIndex = 0;
            while (ddrDataCellIndex < ddrParamDataRow.length) {
                String dataValue = ddrParamDataRow[ddrDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)ddrParamHeadList.get(ddrDataCellIndex);
                    if (headName.equals(CELL_KEY_DDRPARAM_NAME)) {
                        mainDdrParam.setDdrParamName(dataValue);
                        ddrParamNameList.add(dataValue);
                    } else if (headName.equals(CELL_KEY_CONFIG_NUM)) {
                        mainDdrParam.setConfigNum(dataValue);
                    } else if (headName.equals("regName") || headName.startsWith("regName")) {
                        mainDdrParam.addDdrRegToList(new MainRegInfo(dataValue));
                    }
                }
                ++ddrDataCellIndex;
            }
            excelMainData.addMainDdrParamToList(mainDdrParam);
            ++ddrParamRowIndex;
        }
    }

    private static void addStartupToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int startupDataRowNum;
        String startupNumStr = cellArray[1];
        int startupNum = Integer.parseInt(startupNumStr);
        String[] startupHeadRow = workbookList.get(rowIndex + 1);
        int startupHeadRowNum = rowIndex + 1;
        ArrayList<String> startupHeadList = new ArrayList<String>();
        int startupHeadCellIndex = 0;
        while (startupHeadCellIndex < startupHeadRow.length) {
            String keyName = startupHeadRow[startupHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                startupHeadList.add(keyName);
            }
            ++startupHeadCellIndex;
        }
        int startupRowIndex = startupDataRowNum = startupHeadRowNum + 1;
        while (startupRowIndex < startupDataRowNum + startupNum) {
            String[] startupDataRow = workbookList.get(startupRowIndex);
            MainStartup mainStartup = new MainStartup();
            mainStartup.setStartupNum(startupNum);
            int startupDataCellIndex = 0;
            while (startupDataCellIndex < startupDataRow.length) {
                String dataValue = startupDataRow[startupDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)startupHeadList.get(startupDataCellIndex);
                    if (headName.equalsIgnoreCase("startup")) {
                        mainStartup.setStartupName(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_CONFIG_NUM)) {
                        mainStartup.setConfigNum(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_PAGENAME)) {
                        mainStartup.setPageName(dataValue);
                    }
                }
                ++startupDataCellIndex;
            }
            excelMainData.addMainStartupToList(mainStartup);
            ++startupRowIndex;
        }
    }

    private static void addDdrTypeToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int ddrTypeDataRowNum;
        String ddrTypeNumStr = cellArray[1];
        int ddrTypeNum = Integer.parseInt(ddrTypeNumStr);
        String[] ddrTypeHeadRow = workbookList.get(rowIndex + 1);
        int ddrTypeHeadRowNum = rowIndex + 1;
        ArrayList<String> ddrTypeHeadList = new ArrayList<String>();
        int ddrTypeHeadCellIndex = 0;
        while (ddrTypeHeadCellIndex < ddrTypeHeadRow.length) {
            String keyName = ddrTypeHeadRow[ddrTypeHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                ddrTypeHeadList.add(keyName);
            }
            ++ddrTypeHeadCellIndex;
        }
        int ddrTypeRowIndex = ddrTypeDataRowNum = ddrTypeHeadRowNum + 1;
        while (ddrTypeRowIndex < ddrTypeDataRowNum + ddrTypeNum) {
            String[] ddrTypeDataRow = workbookList.get(ddrTypeRowIndex);
            MainDdrType mainDdrType = new MainDdrType();
            mainDdrType.setDdrTypeNum(ddrTypeNum);
            int ddrTypeDataCellIndex = 0;
            while (ddrTypeDataCellIndex < ddrTypeDataRow.length) {
                String dataValue = ddrTypeDataRow[ddrTypeDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)ddrTypeHeadList.get(ddrTypeDataCellIndex);
                    if (headName.equalsIgnoreCase(CELL_KEY_DDRType_NAME)) {
                        mainDdrType.setDdrTypeName(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_CONFIG_NUM)) {
                        mainDdrType.setConfigNum(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_PAGENAME) || headName.startsWith(CELL_KEY_PAGENAME)) {
                        mainDdrType.getPageName().add(dataValue);
                    }
                }
                ++ddrTypeDataCellIndex;
            }
            excelMainData.addMainDdrTypeToList(mainDdrType);
            ++ddrTypeRowIndex;
        }
    }

    private static void addDdrPhyToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int ddrPhyDataRowNum;
        String ddrPhyNumStr = cellArray[1];
        int ddrPhyNum = Integer.parseInt(ddrPhyNumStr);
        String[] ddrPhyHeadRow = workbookList.get(rowIndex + 1);
        int ddrPhyHeadRowNum = rowIndex + 1;
        ArrayList<String> ddrPhyHeadList = new ArrayList<String>();
        int ddrPhyHeadCellIndex = 0;
        while (ddrPhyHeadCellIndex < ddrPhyHeadRow.length) {
            String keyName = ddrPhyHeadRow[ddrPhyHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                ddrPhyHeadList.add(keyName);
            }
            ++ddrPhyHeadCellIndex;
        }
        int ddrPhyRowIndex = ddrPhyDataRowNum = ddrPhyHeadRowNum + 1;
        while (ddrPhyRowIndex < ddrPhyDataRowNum + ddrPhyNum) {
            String[] ddrPhyDataRow = workbookList.get(ddrPhyRowIndex);
            MainDdrPhy mainDdrPhy = new MainDdrPhy();
            mainDdrPhy.setDdrPhyNum(ddrPhyNum);
            int ddrPhyDataCellIndex = 0;
            while (ddrPhyDataCellIndex < ddrPhyDataRow.length) {
                String dataValue = ddrPhyDataRow[ddrPhyDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)ddrPhyHeadList.get(ddrPhyDataCellIndex);
                    if (headName.equalsIgnoreCase("ddrPhyName")) {
                        mainDdrPhy.setDdrPhyName(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_CONFIG_NUM)) {
                        mainDdrPhy.setConfigNum(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_PAGENAME) || headName.startsWith(CELL_KEY_PAGENAME)) {
                        mainDdrPhy.getPageName().add(dataValue);
                    }
                }
                ++ddrPhyDataCellIndex;
            }
            excelMainData.addMainDdrPhyToList(mainDdrPhy);
            ++ddrPhyRowIndex;
        }
    }

    private static void addMultiperToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int multiperDataRowNum;
        String multiperNumStr = cellArray[1];
        int multiperNum = Integer.parseInt(multiperNumStr);
        String[] multiperHeadRow = workbookList.get(rowIndex + 1);
        int multiperHeadRowNum = rowIndex + 1;
        ArrayList<String> multiperHeadList = new ArrayList<String>();
        int multiperHeadCellIndex = 0;
        while (multiperHeadCellIndex < multiperHeadRow.length) {
            String keyName = multiperHeadRow[multiperHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                multiperHeadList.add(keyName);
            }
            ++multiperHeadCellIndex;
        }
        int multiperRowIndex = multiperDataRowNum = multiperHeadRowNum + 1;
        while (multiperRowIndex < multiperDataRowNum + multiperNum) {
            String[] multiperDataRow = workbookList.get(multiperRowIndex);
            MultiperTable multiperTable = new MultiperTable();
            int multiperDataCellIndex = 0;
            while (multiperDataCellIndex < multiperDataRow.length) {
                String dataValue = multiperDataRow[multiperDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)multiperHeadList.get(multiperDataCellIndex);
                    if (headName.equalsIgnoreCase(CELL_KEY_multiper_ID)) {
                        multiperTable.setTableId(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_MULTIPER_DEFAULT_VOLTAGE)) {
                        multiperTable.setTableVoltage(dataValue);
                    }
                }
                ++multiperDataCellIndex;
            }
            excelMainData.addMainMultiperTableToList(multiperTable);
            ++multiperRowIndex;
        }
    }

    private static void addNetConfigToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int netconfigDataRowNum;
        String netconfigNumStr = cellArray[1];
        int netconfigNum = Integer.parseInt(netconfigNumStr);
        String[] netconfigHeadRow = workbookList.get(rowIndex + 1);
        int netconfigHeadRowNum = rowIndex + 1;
        ArrayList<String> netconfigHeadList = new ArrayList<String>();
        int netconfigHeadCellIndex = 0;
        while (netconfigHeadCellIndex < netconfigHeadRow.length) {
            String keyName = netconfigHeadRow[netconfigHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                netconfigHeadList.add(keyName);
            }
            ++netconfigHeadCellIndex;
        }
        int netconfigRowIndex = netconfigDataRowNum = netconfigHeadRowNum + 1;
        while (netconfigRowIndex < netconfigDataRowNum + netconfigNum) {
            String[] netconfigDataRow = workbookList.get(netconfigRowIndex);
            MainNetconfig mainNetConfig = new MainNetconfig();
            mainNetConfig.setNetconfigNum(netconfigNum);
            int netconfigDataCellIndex = 0;
            while (netconfigDataCellIndex < netconfigDataRow.length) {
                String dataValue = netconfigDataRow[netconfigDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)netconfigHeadList.get(netconfigDataCellIndex);
                    if (headName.equalsIgnoreCase(CELL_KEY_NETCONFIG_NAME)) {
                        mainNetConfig.setNetconfigName(dataValue);
                        netConfigNameList.add(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_CONFIG_NUM)) {
                        mainNetConfig.setConfigNum(Integer.parseInt(dataValue));
                    } else if (headName.equalsIgnoreCase(CELL_KEY_NETCONFIG_PHYADDR)) {
                        mainNetConfig.setNetPhyAddr(new MainRegInfo(dataValue));
                    } else if (headName.equalsIgnoreCase(CELL_KEY_NETCONFIG_RESETPIN)) {
                        mainNetConfig.setNetResetPin(new MainRegInfo(dataValue));
                    } else if (headName.equalsIgnoreCase(CELL_KEY_NETCONFIG_MODEL) || headName.startsWith(CELL_KEY_NETCONFIG_MODEL)) {
                        mainNetConfig.addNetModelToList(dataValue);
                    }
                }
                ++netconfigDataCellIndex;
            }
            excelMainData.addMainNetconfigToList(mainNetConfig);
            ++netconfigRowIndex;
        }
    }

    private static void addModelConfigToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int modelDataRowNum;
        String modelNumStr = cellArray[1];
        int modelNum = Integer.parseInt(modelNumStr);
        String[] modelHeadRow = workbookList.get(rowIndex + 1);
        int modelHeadRowNum = rowIndex + 1;
        ArrayList<String> modelHeadList = new ArrayList<String>();
        int modelHeadCellIndex = 0;
        while (modelHeadCellIndex < modelHeadRow.length) {
            String keyName = modelHeadRow[modelHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                modelHeadList.add(keyName);
            }
            ++modelHeadCellIndex;
        }
        int modelRowIndex = modelDataRowNum = modelHeadRowNum + 1;
        while (modelRowIndex < modelDataRowNum + modelNum) {
            String[] modelDataRow = workbookList.get(modelRowIndex);
            MainModelParam mainModelParam = new MainModelParam();
            mainModelParam.setModelConfigNum(modelNum);
            int modelDataCellIndex = 0;
            while (modelDataCellIndex < modelDataRow.length) {
                String dataValue = modelDataRow[modelDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)modelHeadList.get(modelDataCellIndex);
                    if (headName.equals(CELL_KEY_MODELCONFIG_NAME)) {
                        mainModelParam.setModelConfigName(dataValue);
                    } else if (headName.equals(CELL_KEY_CONFIG_NUM)) {
                        mainModelParam.setConfigNum(Integer.parseInt(dataValue));
                    } else if (headName.startsWith("regName")) {
                        mainModelParam.addModelRegToList(new MainRegInfo(dataValue));
                    }
                }
                ++modelDataCellIndex;
            }
            excelMainData.addMainModelParamToList(mainModelParam);
            ++modelRowIndex;
        }
    }

    private static void addDemoToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int demoDataRowNum;
        String demoNumStr = cellArray[1];
        int demoNum = Integer.parseInt(demoNumStr);
        excelMainData.setDemoNum(demoNum);
        String[] demoHeadRow = workbookList.get(rowIndex + 1);
        int demoHeadRowNum = rowIndex + 1;
        ArrayList<String> demoHeadList = new ArrayList<String>();
        int demoHeadCellIndex = 0;
        while (demoHeadCellIndex < demoHeadRow.length) {
            String keyName = demoHeadRow[demoHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                demoHeadList.add(keyName);
            }
            ++demoHeadCellIndex;
        }
        int demoRowIndex = demoDataRowNum = demoHeadRowNum + 1;
        while (demoRowIndex < demoDataRowNum + demoNum) {
            String[] demoDataRow = workbookList.get(demoRowIndex);
            DemoBaseParam demoBaseParam = new DemoBaseParam();
            int demoDataCellIndex = 0;
            while (demoDataCellIndex < demoDataRow.length) {
                String dataValue = demoDataRow[demoDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)demoHeadList.get(demoDataCellIndex);
                    if (headName.equals(CELL_KEY_DEMOCONFIG_NAME)) {
                        demoBaseParam.setDemoName(dataValue);
                    } else if (headName.equals(CELL_KEY_DEMOCONFIG_BIT)) {
                        demoBaseParam.setDdrBuswidth(dataValue);
                    } else if (headName.equals(CELL_KEY_DEMOCONFIG_LAYERS)) {
                        demoBaseParam.setDdrPCBLayers(dataValue);
                    } else if (headName.equals(CELL_KEY_DEMOCONFIG_CANOCA)) {
                        CAConfig caConfig = null;
                        if (dataValue.equalsIgnoreCase(CAConfig.CA.name())) {
                            caConfig = CAConfig.CA;
                        }
                        if (dataValue.equalsIgnoreCase(CAConfig.noCA.name())) {
                            caConfig = CAConfig.noCA;
                        }
                        demoBaseParam.setCa(caConfig);
                    } else if (headName.equals("startup")) {
                        demoBaseParam.setStartup(dataValue);
                    } else if (headName.equals(CELL_KEY_DEMOCONFIG_DDRType)) {
                        demoBaseParam.setDdrType(dataValue);
                    } else if (headName.equals(CELL_KEY_DEMOCONFIG_VOL)) {
                        demoBaseParam.setVolDvdd(dataValue);
                    } else if (headName.equals("ddrPhyName")) {
                        demoBaseParam.setDdrPhy(dataValue);
                    } else if (headName.contains(CELL_KEY_DEMOCONFIG_PhyAddr)) {
                        demoBaseParam.getPhyAddrList().add(dataValue);
                    } else if (headName.contains(CELL_KEY_DEMOCONFIG_Default_DDRCapacity)) {
                        demoBaseParam.setDdrCapacity(dataValue);
                    } else if (headName.equalsIgnoreCase("Package")) {
                        demoBaseParam.setPackageStr(dataValue);
                    } else {
                        int i = 0;
                        while (i < ddrParamNameList.size()) {
                            String ddrParamName = ddrParamNameList.get(i);
                            if (headName.equals(ddrParamName)) {
                                demoBaseParam.putDynamicParamToList(ddrParamName, dataValue);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < netConfigNameList.size()) {
                            String netConfigName = netConfigNameList.get(i);
                            if (headName.equals(netConfigName)) {
                                demoBaseParam.putDynamicParamToList(netConfigName, dataValue);
                            }
                            ++i;
                        }
                    }
                }
                ++demoDataCellIndex;
            }
            excelMainData.addDemoBaseParamToList(demoBaseParam);
            ++demoRowIndex;
        }
    }

    private static void addPackageToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int packageDataRowNum;
        String packageNumStr = cellArray[1];
        int packageNum = Integer.parseInt(packageNumStr);
        String[] packageHeadRow = workbookList.get(rowIndex + 1);
        int packageHeadRowNum = rowIndex + 1;
        ArrayList<String> packageHeadList = new ArrayList<String>();
        int packageHeadCellIndex = 0;
        while (packageHeadCellIndex < packageHeadRow.length) {
            String keyName = packageHeadRow[packageHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                packageHeadList.add(keyName);
            }
            ++packageHeadCellIndex;
        }
        int packageRowIndex = packageDataRowNum = packageHeadRowNum + 1;
        while (packageRowIndex < packageDataRowNum + packageNum) {
            String[] packageDataRow = workbookList.get(packageRowIndex);
            MainPackage mainPackage = new MainPackage();
            mainPackage.setPackageNum(packageNum);
            int packageDataCellIndex = 0;
            while (packageDataCellIndex < packageDataRow.length) {
                String dataValue = packageDataRow[packageDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String option;
                    int n;
                    int n2;
                    String[] stringArray;
                    String[] options;
                    String headName = (String)packageHeadList.get(packageDataCellIndex);
                    if (headName.equalsIgnoreCase(CELL_KEY_PACKAGE_NAME)) {
                        mainPackage.setPackageName(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_CONFIG_NUM)) {
                        mainPackage.setConfigNum(dataValue);
                    } else if (headName.equalsIgnoreCase(CELL_KEY_PACKAGE_BGA21X21)) {
                        if (dataValue.contains(",")) {
                            stringArray = options = dataValue.split(",");
                            n2 = options.length;
                            n = 0;
                            while (n < n2) {
                                option = stringArray[n];
                                mainPackage.getBga21x21().add(option);
                                ++n;
                            }
                        } else {
                            mainPackage.getBga21x21().add(dataValue);
                        }
                    } else if (headName.equalsIgnoreCase(CELL_KEY_PACKAGE_BGA15X15)) {
                        if (dataValue.contains(",")) {
                            stringArray = options = dataValue.split(",");
                            n2 = options.length;
                            n = 0;
                            while (n < n2) {
                                option = stringArray[n];
                                mainPackage.getBga15x15().add(option);
                                ++n;
                            }
                        } else {
                            mainPackage.getBga15x15().add(dataValue);
                        }
                    }
                }
                ++packageDataCellIndex;
            }
            excelMainData.addMainPackageToList(mainPackage);
            ++packageRowIndex;
        }
    }

    private static void addGpioToMainData(List<String[]> workbookList, String[] cellArray, ExcelMainData excelMainData, int rowIndex) {
        int gpioDataRowNum;
        String gpioNumStr = cellArray[1];
        int gpioNum = Integer.parseInt(gpioNumStr);
        String[] gpioHeadRow = workbookList.get(rowIndex + 1);
        int gpioHeadRowNum = rowIndex + 1;
        ArrayList<String> gpioHeadList = new ArrayList<String>();
        int gpioHeadCellIndex = 0;
        while (gpioHeadCellIndex < gpioHeadRow.length) {
            String keyName = gpioHeadRow[gpioHeadCellIndex];
            if (keyName != null && keyName.length() > 0) {
                gpioHeadList.add(keyName);
            }
            ++gpioHeadCellIndex;
        }
        int gpioRowIndex = gpioDataRowNum = gpioHeadRowNum + 1;
        while (gpioRowIndex < gpioDataRowNum + gpioNum) {
            String[] gpioDataRow = workbookList.get(gpioRowIndex);
            GpioData gpioData = new GpioData();
            int gpioDataCellIndex = 0;
            while (gpioDataCellIndex < gpioDataRow.length) {
                String dataValue = gpioDataRow[gpioDataCellIndex];
                if (dataValue != null && dataValue.length() > 0) {
                    String headName = (String)gpioHeadList.get(gpioDataCellIndex);
                    if (headName.equals(CELL_KEY_GPIOCONFIG_NAME)) {
                        gpioData.setGpioName(dataValue);
                        gpioData.setGpioItemNum(dataValue.substring(dataValue.indexOf("GPIO") + "GPIO".length()));
                    } else if (!headName.equals(CELL_KEY_CONFIG_NUM) && headName.equals(CELL_KEY_GPIOCONFIG_VALUE)) {
                        dataValue = ExcelDataHelper.remove0xHexStr(dataValue);
                        int gpioGroupAddress = BitUtils.parseLongToInt32(dataValue, true);
                        gpioData.setGpioGroupAddress(gpioGroupAddress);
                    }
                }
                ++gpioDataCellIndex;
            }
            excelMainData.addGpioToList(gpioData);
            ++gpioRowIndex;
        }
    }

    private static boolean isEmptyStr(String inputStr) {
        return inputStr == null || inputStr.isEmpty();
    }

    private static int getCellDemoAlength() {
        if (RegbinView.isHi3796CV300Series()) {
            return 10;
        }
        return 14;
    }

    private static ExcelWorkbookInfo loadWorkbookPinMuxDrv(ExcelData excelData, String filePath, String workbootName, int demoNum, ArrayList<String> gpioGroupNameList) throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        List<String[]> workbookList = XLSXCovertCSVReader.readerExcel(filePath, workbootName, 46);
        ExcelWorkbookInfo excelWorkbookInfo = new ExcelWorkbookInfo();
        excelWorkbookInfo.setWorkbookName(workbootName);
        ExcelDataHelper.setCheckGpioNotCorrect(true);
        String currentRegName = "";
        int currentRegOffsetAddress = 0;
        String currentRegPinMum = "";
        Map<String, String> currentDemoSelectFunValue = null;
        HashMap<Integer, String> demo = new HashMap<Integer, String>();
        String gpioNum = null;
        ExcelDataHelper.readBaseWorkbookInfo(workbookList, excelWorkbookInfo, excelData);
        int rowIndex = 0;
        while (rowIndex < workbookList.size()) {
            String[] cellArray = workbookList.get(rowIndex);
            if (cellArray != null) {
                int regInfoStartRow;
                int regHeadStartRow;
                int n = regHeadStartRow = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 2 : 6;
                if (rowIndex == regHeadStartRow) {
                    int demoIndex = 0;
                    while (demoIndex < demoNum) {
                        String demoName = ExcelDataHelper.isV120RegFomatVersion(excelData) ? cellArray[ExcelDataHelper.getCellDemoAlength() + 2 + demoIndex] : cellArray[ExcelDataHelper.getCellDemoAlength() + demoIndex];
                        demo.put(demoIndex, demoName);
                        ++demoIndex;
                    }
                }
                int n2 = regInfoStartRow = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 3 : 7;
                if (rowIndex >= regInfoStartRow + 1) {
                    boolean isNullRow;
                    BaseRegisterInfo baseResiterInfo = new BaseRegisterInfo();
                    String regName = cellArray[0];
                    String regOffsetAddressStr = cellArray[1];
                    String regFunction = cellArray[2];
                    if (regFunction != null && regFunction.contains("GPIO")) {
                        int index = regFunction.lastIndexOf(UNDER_LINE);
                        gpioNum = regFunction.substring(0, index);
                        for (String gpioGroupName : gpioGroupNameList) {
                            if (gpioNum.equals(gpioGroupName)) {
                                ExcelDataHelper.setCheckGpioNotCorrect(false);
                                break;
                            }
                            ExcelDataHelper.setCheckGpioNotCorrect(true);
                        }
                        if (ExcelDataHelper.isCheckGpioNotCorrect()) {
                            ExcelDataHelper.setLackOfGpio(gpioNum);
                            return null;
                        }
                    }
                    boolean bl = isNullRow = regName == null && regOffsetAddressStr == null && regFunction == null;
                    if (!isNullRow) {
                        int regOffsetAddress;
                        if (!ExcelDataHelper.isEmptyStr(regName)) {
                            currentRegName = regName;
                        } else {
                            regName = currentRegName;
                        }
                        baseResiterInfo.setRegName(regName);
                        if (!ExcelDataHelper.isEmptyStr(regOffsetAddressStr)) {
                            regOffsetAddressStr = ExcelDataHelper.remove0xHexStr(regOffsetAddressStr);
                            currentRegOffsetAddress = regOffsetAddress = Integer.parseInt(regOffsetAddressStr, 16);
                            baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                        } else {
                            regOffsetAddress = currentRegOffsetAddress;
                            baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                        }
                        if (regFunction == null) {
                            regFunction = "";
                        }
                        baseResiterInfo.setRegFunction(regFunction);
                        String layers2DriverStr = null;
                        String layers2SlewRateStr = null;
                        String layers2ValueStr = null;
                        String layers4DriverStr = null;
                        String layers4SlewRateStr = null;
                        String layers4ValueStr = null;
                        String regDelay = null;
                        String regReadOrWrite = null;
                        String regBit = null;
                        String regStartBit = null;
                        String regPinMumStr = null;
                        String layer2Pupd = null;
                        String layer4Pupd = null;
                        if (ExcelDataHelper.isV120RegFomatVersion(excelData)) {
                            int cell_2layers_Add_Pupd = -3;
                            int cell_4layers_add_pupd = -2;
                            if (!RegbinView.isHi3796CV300Series()) {
                                cell_2layers_Add_Pupd = 1;
                                cell_4layers_add_pupd = 2;
                                layers2DriverStr = cellArray[3];
                                layers2SlewRateStr = cellArray[4];
                                layer2Pupd = cellArray[5];
                                layers2ValueStr = cellArray[5 + cell_2layers_Add_Pupd];
                            }
                            layers4DriverStr = cellArray[6 + cell_2layers_Add_Pupd];
                            layers4SlewRateStr = cellArray[7 + cell_2layers_Add_Pupd];
                            layer4Pupd = cellArray[7 + cell_4layers_add_pupd];
                            layers4ValueStr = cellArray[8 + cell_4layers_add_pupd];
                            regDelay = cellArray[9 + cell_4layers_add_pupd];
                            regReadOrWrite = cellArray[10 + cell_4layers_add_pupd];
                            regBit = cellArray[11 + cell_4layers_add_pupd];
                            regStartBit = cellArray[12 + cell_4layers_add_pupd];
                            regPinMumStr = cellArray[13 + cell_4layers_add_pupd];
                        } else {
                            layers2DriverStr = cellArray[3];
                            layers2SlewRateStr = cellArray[4];
                            layers2ValueStr = cellArray[5];
                            layers4DriverStr = cellArray[6];
                            layers4SlewRateStr = cellArray[7];
                            layers4ValueStr = cellArray[8];
                            regDelay = cellArray[9];
                            regReadOrWrite = cellArray[10];
                            regBit = cellArray[11];
                            regStartBit = cellArray[12];
                            regPinMumStr = cellArray[13];
                        }
                        if (!RegbinView.isHi3796CV300Series()) {
                            Layers layers2 = new Layers();
                            layers2.setDriver(layers2DriverStr == null ? "" : layers2DriverStr);
                            layers2.setSlewRate(layers2SlewRateStr == null ? "" : layers2SlewRateStr);
                            layers2.setPupd(layer2Pupd == null ? "" : layer2Pupd);
                            layers2.setValue(ExcelDataHelper.isEmptyStr(layers2ValueStr) ? -1 : Integer.parseInt(ExcelDataHelper.remove0xHexStr(layers2ValueStr), 16));
                            baseResiterInfo.setRegLayers2(layers2);
                        }
                        Layers layers4 = new Layers();
                        layers4.setDriver(layers4DriverStr == null ? "" : layers4DriverStr);
                        layers4.setSlewRate(layers4SlewRateStr == null ? "" : layers4SlewRateStr);
                        layers4.setPupd(layer4Pupd == null ? "" : layer4Pupd);
                        layers4.setValue(ExcelDataHelper.isEmptyStr(layers4ValueStr) ? -1 : Integer.parseInt(ExcelDataHelper.remove0xHexStr(layers4ValueStr), 16));
                        baseResiterInfo.setRegLayers4and6and8(layers4);
                        baseResiterInfo.setRegDelay(ExcelDataHelper.isEmptyStr(regDelay) ? -1 : Integer.parseInt(regDelay));
                        ExcelDataHelper.setBaseReadOrWrite(workbootName, baseResiterInfo, regReadOrWrite);
                        baseResiterInfo.setRegBit(ExcelDataHelper.isEmptyStr(regBit) ? -1 : Integer.parseInt(regBit));
                        baseResiterInfo.setRegStartBit(ExcelDataHelper.isEmptyStr(regStartBit) ? -1 : Integer.parseInt(regStartBit));
                        if (!ExcelDataHelper.isEmptyStr(regPinMumStr)) {
                            currentRegPinMum = regPinMumStr;
                            baseResiterInfo.setRegPinNum(regPinMumStr);
                        }
                        if (ExcelDataHelper.isEmptyStr(regPinMumStr)) {
                            baseResiterInfo.setRegPinNum(currentRegPinMum);
                        }
                        int demoIndex = 0;
                        while (demoIndex < demoNum) {
                            int cellNum = ExcelDataHelper.isV120RegFomatVersion(excelData) ? ExcelDataHelper.getCellDemoAlength() + 2 + demoIndex : ExcelDataHelper.getCellDemoAlength() + demoIndex;
                            String demoFunctionValue = cellArray[cellNum];
                            if (!ExcelDataHelper.isEmptyStr(demoFunctionValue)) {
                                String demoName = (String)demo.get(demoIndex);
                                baseResiterInfo.getDemoSelectFunValue().put(demoName, demoFunctionValue);
                            }
                            ++demoIndex;
                        }
                        if (baseResiterInfo.getDemoSelectFunValue().size() > 0) {
                            currentDemoSelectFunValue = baseResiterInfo.getDemoSelectFunValue();
                        } else {
                            baseResiterInfo.setDemoSelectFunValue(currentDemoSelectFunValue);
                        }
                        excelWorkbookInfo.getBaseRegisterInfoList().add(baseResiterInfo);
                    }
                }
            }
            ++rowIndex;
        }
        return excelWorkbookInfo;
    }

    private static void setBaseReadOrWrite(String workbootName, BaseRegisterInfo baseResiterInfo, String regReadOrWrite) {
        if (!ExcelDataHelper.isEmptyStr(regReadOrWrite)) {
            if (regReadOrWrite.equalsIgnoreCase(RegBinAction.WRITE.name())) {
                baseResiterInfo.setRegReadOrWrite(RegBinAction.WRITE);
            } else if (regReadOrWrite.equalsIgnoreCase(RegBinAction.READ.name())) {
                baseResiterInfo.setRegReadOrWrite(RegBinAction.READ);
            } else {
                baseResiterInfo.setRegReadOrWrite(RegBinAction.NONE);
            }
        } else {
            regReadOrWrite = "";
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckTempCurrentPageError, (Object)workbootName, (Object)(String.valueOf(baseResiterInfo.getRegName()) + " ReadOrWrite")));
                }
            });
        }
    }

    private static ExcelWorkbookInfo loadWorkbookFpPinMuxDrv(ExcelData excelData, String filePath, String workbootName, int demoNum) throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        List<String[]> workbookList = XLSXCovertCSVReader.readerExcel(filePath, workbootName, 42);
        int currentRegOffsetAddress = 0;
        String currentRegPinMum = "";
        Map<String, String> currentDemoSelectFunValue = null;
        ExcelWorkbookInfo excelWorkbookInfo = new ExcelWorkbookInfo();
        excelWorkbookInfo.setWorkbookName(workbootName);
        HashMap<Integer, String> demo = new HashMap<Integer, String>();
        ExcelDataHelper.readBaseWorkbookInfo(workbookList, excelWorkbookInfo, excelData);
        String currentRegName = "";
        int rowIndex = 0;
        while (rowIndex < workbookList.size()) {
            String[] cellArray = workbookList.get(rowIndex);
            if (cellArray != null) {
                int regInfoStartRow;
                int regHeadStartRow;
                int n = regHeadStartRow = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 2 : 6;
                if (rowIndex == regHeadStartRow) {
                    int demoIndex = 0;
                    while (demoIndex < demoNum) {
                        String demoName = ExcelDataHelper.isV120RegFomatVersion(excelData) ? cellArray[12 + demoIndex] : cellArray[11 + demoIndex];
                        demo.put(demoIndex, demoName);
                        ++demoIndex;
                    }
                }
                int n2 = regInfoStartRow = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 3 : 7;
                if (rowIndex >= regInfoStartRow) {
                    boolean isNullRow;
                    BaseRegisterInfo baseResiterInfo = new BaseRegisterInfo();
                    String regName = cellArray[0];
                    String regOffsetAddressStr = cellArray[1];
                    String regFunction = cellArray[2];
                    boolean bl = isNullRow = regName == null && regOffsetAddressStr == null && regFunction == null;
                    if (!isNullRow) {
                        int regOffsetAddress;
                        if (!ExcelDataHelper.isEmptyStr(regName)) {
                            currentRegName = regName;
                        } else {
                            regName = currentRegName;
                        }
                        baseResiterInfo.setRegName(regName);
                        if (!ExcelDataHelper.isEmptyStr(regOffsetAddressStr)) {
                            regOffsetAddressStr = ExcelDataHelper.remove0xHexStr(regOffsetAddressStr);
                            currentRegOffsetAddress = regOffsetAddress = Integer.parseInt(regOffsetAddressStr, 16);
                            baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                        } else {
                            regOffsetAddress = currentRegOffsetAddress;
                            baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                        }
                        baseResiterInfo.setRegFunction(regFunction == null ? "" : regFunction);
                        String layerDriverStr = null;
                        String layerSlewRateStr = null;
                        String layerValueStr = null;
                        String layerPupd = null;
                        String regDelay = null;
                        String regReadOrWrite = null;
                        String regBit = null;
                        String regStartBit = null;
                        String regPinMumStr = null;
                        if (ExcelDataHelper.isV120RegFomatVersion(excelData)) {
                            layerDriverStr = cellArray[3];
                            layerSlewRateStr = cellArray[4];
                            layerPupd = cellArray[5];
                            layerValueStr = cellArray[6];
                            regDelay = cellArray[7];
                            regReadOrWrite = cellArray[8];
                            regBit = cellArray[9];
                            regStartBit = cellArray[10];
                            regPinMumStr = cellArray[11];
                        } else {
                            layerDriverStr = cellArray[3];
                            layerSlewRateStr = cellArray[4];
                            layerValueStr = cellArray[5];
                            regDelay = cellArray[6];
                            regReadOrWrite = cellArray[7];
                            regBit = cellArray[8];
                            regStartBit = cellArray[9];
                            regPinMumStr = cellArray[10];
                        }
                        baseResiterInfo.setLayerDriver(ExcelDataHelper.isEmptyStr(layerDriverStr) ? "" : layerDriverStr);
                        baseResiterInfo.setLayerSlewRate(ExcelDataHelper.isEmptyStr(layerSlewRateStr) ? "" : layerSlewRateStr);
                        baseResiterInfo.setLayerPupd(ExcelDataHelper.isEmptyStr(layerPupd) ? "" : layerPupd);
                        baseResiterInfo.setLayerValue(ExcelDataHelper.isEmptyStr(layerValueStr) ? -1 : Integer.parseInt(ExcelDataHelper.remove0xHexStr(layerValueStr), 16));
                        baseResiterInfo.setRegDelay(ExcelDataHelper.isEmptyStr(regDelay) ? -1 : Integer.parseInt(regDelay));
                        ExcelDataHelper.setBaseReadOrWrite(workbootName, baseResiterInfo, regReadOrWrite);
                        baseResiterInfo.setRegBit(ExcelDataHelper.isEmptyStr(regBit) ? -1 : Integer.parseInt(regBit));
                        baseResiterInfo.setRegStartBit(ExcelDataHelper.isEmptyStr(regStartBit) ? -1 : Integer.parseInt(regStartBit));
                        if (regPinMumStr != null && !regPinMumStr.isEmpty()) {
                            currentRegPinMum = regPinMumStr;
                            baseResiterInfo.setRegPinNum(regPinMumStr);
                        }
                        if (regPinMumStr == null || regPinMumStr.isEmpty()) {
                            baseResiterInfo.setRegPinNum(currentRegPinMum);
                        }
                        int demoIndex = 0;
                        while (demoIndex < demoNum) {
                            int cellNum = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 12 + demoIndex : 11 + demoIndex;
                            String demoFunctionValue = cellArray[cellNum];
                            if (!ExcelDataHelper.isEmptyStr(demoFunctionValue)) {
                                String demoName = (String)demo.get(demoIndex);
                                baseResiterInfo.getDemoSelectFunValue().put(demoName, demoFunctionValue);
                            }
                            ++demoIndex;
                        }
                        if (baseResiterInfo.getDemoSelectFunValue().size() > 0) {
                            currentDemoSelectFunValue = baseResiterInfo.getDemoSelectFunValue();
                        } else {
                            baseResiterInfo.setDemoSelectFunValue(currentDemoSelectFunValue);
                        }
                        excelWorkbookInfo.getBaseRegisterInfoList().add(baseResiterInfo);
                    }
                }
            }
            ++rowIndex;
        }
        return excelWorkbookInfo;
    }

    private static ExcelWorkbookInfo loadWorkbookCommon(ExcelData excelData, String filePath, String workbookName) throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        List<String[]> workbookList = XLSXCovertCSVReader.readerExcel(filePath, workbookName, 8);
        String currentRegName = "";
        int currentRegOffsetAddress = 0;
        ExcelWorkbookInfo excelWorkbookInfo = new ExcelWorkbookInfo();
        excelWorkbookInfo.setWorkbookName(workbookName);
        ExcelDataHelper.readBaseWorkbookInfo(workbookList, excelWorkbookInfo, excelData);
        boolean hasFunction = false;
        int rowIndex = 0;
        while (rowIndex < workbookList.size()) {
            block13: {
                int regOffsetAddress;
                String regStartBit;
                String regBit;
                String regReadOrWrite;
                String regDelay;
                String regValue;
                String regOffsetAddressStr;
                String regName;
                BaseRegisterInfo baseResiterInfo;
                block15: {
                    boolean checkVaild;
                    String[] cellArray;
                    block14: {
                        cellArray = workbookList.get(rowIndex);
                        if (cellArray == null) break block13;
                        int reginfoStartRow = ExcelDataHelper.isV120RegFomatVersion(excelData) ? 3 : 7;
                        String[] stringArray = cellArray;
                        int n = cellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String headName = stringArray[n2];
                            if (headName != null && headName.equalsIgnoreCase("function")) {
                                hasFunction = true;
                                break;
                            }
                            ++n2;
                        }
                        if (rowIndex < reginfoStartRow) break block13;
                        baseResiterInfo = new BaseRegisterInfo();
                        regName = cellArray[0];
                        regOffsetAddressStr = cellArray[1];
                        String regFunction = null;
                        regValue = null;
                        regDelay = null;
                        regReadOrWrite = null;
                        regBit = null;
                        regStartBit = null;
                        if (!hasFunction) break block14;
                        regFunction = cellArray[2];
                        boolean bl = checkVaild = regName == null && regOffsetAddressStr == null && regFunction == null;
                        if (checkVaild) break block13;
                        if (regFunction == null) {
                            regFunction = "";
                        }
                        baseResiterInfo.setRegFunction(regFunction);
                        baseResiterInfo.setWorkbookName(workbookName);
                        regValue = cellArray[3];
                        regDelay = cellArray[4];
                        regReadOrWrite = cellArray[5];
                        regBit = cellArray[6];
                        regStartBit = cellArray[7];
                        break block15;
                    }
                    regValue = cellArray[2];
                    boolean bl = checkVaild = regName == null && regOffsetAddressStr == null && regValue == null;
                    if (checkVaild) break block13;
                    regDelay = cellArray[3];
                    regReadOrWrite = cellArray[4];
                    regBit = cellArray[5];
                    regStartBit = cellArray[6];
                }
                if (!ExcelDataHelper.isEmptyStr(regName)) {
                    currentRegName = regName;
                } else {
                    regName = currentRegName;
                }
                baseResiterInfo.setRegName(regName);
                if (!ExcelDataHelper.isEmptyStr(regOffsetAddressStr)) {
                    regOffsetAddressStr = ExcelDataHelper.remove0xHexStr(regOffsetAddressStr);
                    currentRegOffsetAddress = regOffsetAddress = Integer.parseInt(regOffsetAddressStr, 16);
                    baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                } else {
                    regOffsetAddress = currentRegOffsetAddress;
                    baseResiterInfo.setRegOffsetAddress(regOffsetAddress);
                }
                if (ExcelDataHelper.isEmptyStr(regValue)) {
                    baseResiterInfo.setRegValue(-1);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_CheckTempCurrentPageError, (Object)workbookName, (Object)(String.valueOf(baseResiterInfo.getRegName()) + " Value")));
                        }
                    });
                } else {
                    regValue = ExcelDataHelper.remove0xHexStr(regValue.trim());
                    baseResiterInfo.setRegValue(BitUtils.parseLongToInt32(regValue, true));
                }
                baseResiterInfo.setRegDelay(ExcelDataHelper.isEmptyStr(regDelay) ? -1 : Integer.parseInt(regDelay));
                ExcelDataHelper.setBaseReadOrWrite(workbookName, baseResiterInfo, regReadOrWrite);
                baseResiterInfo.setRegBit(ExcelDataHelper.isEmptyStr(regBit) ? -1 : Integer.parseInt(regBit));
                baseResiterInfo.setRegStartBit(ExcelDataHelper.isEmptyStr(regStartBit) ? -1 : Integer.parseInt(regStartBit));
                excelWorkbookInfo.getBaseRegisterInfoList().add(baseResiterInfo);
            }
            ++rowIndex;
        }
        return excelWorkbookInfo;
    }

    protected static void readBaseWorkbookInfo(List<String[]> workbookList, ExcelWorkbookInfo excelWorkbookInfo, ExcelData excelData) {
        String[] cellArray = workbookList.get(0);
        if (ExcelDataHelper.isV120RegFomatVersion(excelData)) {
            ExcelDataHelper.readV120BaseWorkbookInfo(workbookList, excelWorkbookInfo, cellArray);
        } else {
            ExcelDataHelper.readOtherBaseWrokbookInfo(workbookList, excelWorkbookInfo);
        }
    }

    private static void readOtherBaseWrokbookInfo(List<String[]> workbookList, ExcelWorkbookInfo excelWorkbookInfo) {
        String[] cellArray = workbookList.get(0);
        String moduleName = cellArray[1];
        if (moduleName == null) {
            moduleName = "";
        }
        excelWorkbookInfo.setModuleName(moduleName);
        cellArray = workbookList.get(1);
        String hexBaseAddressStr = cellArray[1];
        if (hexBaseAddressStr == null || hexBaseAddressStr.isEmpty()) {
            excelWorkbookInfo.setBaseAddress(-1);
        } else {
            hexBaseAddressStr = ExcelDataHelper.remove0xHexStr(hexBaseAddressStr);
            excelWorkbookInfo.setBaseAddress(BitUtils.parseLongToInt32(hexBaseAddressStr, true));
        }
        cellArray = workbookList.get(2);
        int item = 0;
        String itemStr = cellArray[1];
        if (itemStr != null && !itemStr.isEmpty()) {
            item = Integer.parseInt(itemStr);
        }
        excelWorkbookInfo.setItem(item);
        cellArray = workbookList.get(3);
        int priority = 0;
        String priorityStr = cellArray[1];
        if (priorityStr != null && !priorityStr.isEmpty()) {
            priority = Integer.parseInt(priorityStr);
        }
        excelWorkbookInfo.setPriority(priority);
        cellArray = workbookList.get(4);
        boolean exeForStandyWakeup = false;
        String exeForStandyWakeupStr = cellArray[1];
        exeForStandyWakeup = exeForStandyWakeupStr == null ? false : ExcelDataHelper.convertToBool(exeForStandyWakeupStr);
        excelWorkbookInfo.setExeForStandyWakeup(exeForStandyWakeup);
        cellArray = workbookList.get(5);
        boolean exeForNormalBoot = false;
        String exeForNormalBootStr = cellArray[1];
        exeForNormalBoot = exeForNormalBootStr == null ? false : ExcelDataHelper.convertToBool(exeForNormalBootStr);
        excelWorkbookInfo.setExeForNormalBoot(exeForNormalBoot);
    }

    private static void readV120BaseWorkbookInfo(List<String[]> workbookList, ExcelWorkbookInfo excelWorkbookInfo, String[] cellArray) {
        String[] nextCellArray = workbookList.get(1);
        if (nextCellArray == null) {
            return;
        }
        int i = 0;
        while (i < cellArray.length) {
            String readStr = cellArray[i];
            if (readStr != null) {
                if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[0])) {
                    String moduleName = nextCellArray[i];
                    if (moduleName == null) {
                        moduleName = "";
                    }
                    excelWorkbookInfo.setModuleName(moduleName);
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[1])) {
                    String hexBaseAddressStr = nextCellArray[i];
                    if (hexBaseAddressStr == null || hexBaseAddressStr.isEmpty()) {
                        excelWorkbookInfo.setBaseAddress(-1);
                    } else {
                        hexBaseAddressStr = ExcelDataHelper.remove0xHexStr(hexBaseAddressStr);
                        excelWorkbookInfo.setBaseAddress(BitUtils.parseLongToInt32(hexBaseAddressStr, true));
                    }
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[2])) {
                    String exeForNormalBootStr = nextCellArray[i];
                    boolean exeForNormalBoot = false;
                    exeForNormalBoot = exeForNormalBootStr == null ? false : ExcelDataHelper.convertToBool(exeForNormalBootStr);
                    excelWorkbookInfo.setExeForNormalBoot(exeForNormalBoot);
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[3])) {
                    String exeForStandyWakeupStr = nextCellArray[i];
                    boolean exeForStandyWakeup = false;
                    exeForStandyWakeup = exeForStandyWakeupStr == null ? false : ExcelDataHelper.convertToBool(exeForStandyWakeupStr);
                    excelWorkbookInfo.setExeForStandyWakeup(exeForStandyWakeup);
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[4])) {
                    String normalChipStr = nextCellArray[i];
                    boolean normalChip = false;
                    normalChip = normalChipStr == null ? false : ExcelDataHelper.convertToBool(normalChipStr);
                    excelWorkbookInfo.setNormalChip(normalChip);
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[5])) {
                    String caChipStr = nextCellArray[i];
                    boolean caChip = false;
                    caChip = caChipStr == null ? false : ExcelDataHelper.convertToBool(caChipStr);
                    excelWorkbookInfo.setCaChip(caChip);
                } else if (readStr.equals(ExcelDefinition.ExcelCommonDefinition.get98cv200Header()[6])) {
                    String moduleTypeStr = nextCellArray[i];
                    BinModuleType moduleType = BinModuleType.NORMAL;
                    moduleType = moduleTypeStr == null ? BinModuleType.NORMAL : ExcelDataHelper.convertModuleType(moduleTypeStr);
                    excelWorkbookInfo.setModuleType(moduleType);
                }
            }
            ++i;
        }
    }

    protected static String remove0xHexStr(String hexStr) {
        if (hexStr != null && (hexStr = hexStr.trim()).startsWith(HEX_STR)) {
            hexStr = hexStr.substring(hexStr.indexOf(HEX_STR) + HEX_STR.length());
        }
        return hexStr;
    }

    private static boolean convertToBool(String str) {
        boolean bool = false;
        bool = str.equalsIgnoreCase("Y");
        return bool;
    }

    private static BinModuleType convertModuleType(String str) {
        BinModuleType moduleType = BinModuleType.NORMAL;
        if (str.startsWith("0-")) {
            moduleType = BinModuleType.NORMAL;
        } else if (str.startsWith("1-")) {
            moduleType = BinModuleType.SPI;
        } else if (str.startsWith("2-")) {
            moduleType = BinModuleType.NAND;
        } else if (str.startsWith("3-")) {
            moduleType = BinModuleType.EMMC;
        } else if (str.startsWith("4-")) {
            moduleType = BinModuleType.SD;
        } else if (str.startsWith("5-")) {
            moduleType = BinModuleType.EMBEDNY;
        } else if (str.startsWith("6-")) {
            moduleType = BinModuleType.EMBEDWB;
        } else if (str.startsWith("7-")) {
            moduleType = BinModuleType.EMMCPHY;
        }
        return moduleType;
    }

    public static ExcelData getExcelData() {
        return excelData;
    }

    public static ExcelData getExcelDataforImport() {
        return excelDataforImport;
    }

    public static void setExcelDataforImport(ExcelData excelDataforImport) {
        ExcelDataHelper.excelDataforImport = excelDataforImport;
    }

    public static void setExcelData(ExcelData excelData) {
        ExcelDataHelper.excelData = excelData;
    }

    public static ParsedMainData getParsedMainData() {
        return parsedMainData;
    }

    public static void setParsedMainData(ParsedMainData parsedMainData) {
        ExcelDataHelper.parsedMainData = parsedMainData;
    }

    public static String extractDeviceName(String devInfo) {
        int sepIndex = devInfo.indexOf(UNDER_LINE);
        if (sepIndex == -1) {
            return devInfo;
        }
        return devInfo.substring(0, sepIndex).trim();
    }

    public static boolean isV120RegFomatVersion(ExcelData excelData) {
        String regFormatVersion;
        return excelData != null && excelData.getExcelMainData() != null && (regFormatVersion = excelData.getExcelMainData().getRegFormatVersion()) != null && regFormatVersion.equalsIgnoreCase(Excel_98CV200_REG_FORMAT_VERSION);
    }

    public static boolean isV135XlsFomatVersion(ExcelData excelData) {
        String xlsFormatVersion;
        return excelData != null && excelData.getExcelMainData() != null && (xlsFormatVersion = excelData.getExcelMainData().getXlsVersion()) != null && xlsFormatVersion.equalsIgnoreCase(Excel_3751V620_XLS_FORMAT_VERSION);
    }

    public static boolean isCheckGpioNotCorrect() {
        return checkGpioNotCorrect;
    }

    public static void setCheckGpioNotCorrect(boolean checkGpioNotCorrect) {
        ExcelDataHelper.checkGpioNotCorrect = checkGpioNotCorrect;
    }

    public static String getLackOfGpio() {
        return lackOfGpio;
    }

    public static void setLackOfGpio(String lackOfGpio) {
        ExcelDataHelper.lackOfGpio = lackOfGpio;
    }

    public static ParsedMainData getDemoParsedMainData() {
        if (demoParsedMainData == null) {
            demoParsedMainData = ExcelDataHelper.toParsedMainDataNew(ExcelDataHelper.getExcelData());
        }
        return demoParsedMainData;
    }

    public static void setDemoParsedMainData(ParsedMainData demoParsedMainData) {
        ExcelDataHelper.demoParsedMainData = demoParsedMainData;
    }
}

