/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.internal;

import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Chips;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.HisiErrorLog;
import com.soyatec.hisilicon.platform.core.internal.JaxbUtils;
import com.soyatec.hisilicon.platform.core.internal.PreferenceUtils;
import com.soyatec.hisilicon.platform.core.internal.RSAUtil;
import com.soyatec.hisilicon.platform.core.internal.StringConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.util.ValidationEventCollector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DeviceManager
implements IDeviceManager {
    private static String LIST = StringConstants.decode("1818850164");
    private static String CONFIG_MODEL_SCHEMA_FILE = StringConstants.decode("544905895732323196367716");
    private static String DEVICE_NODE = StringConstants.decode("110386941092709");
    private static String CURRENT_DEVICE = StringConstants.decode("27995157100326516");
    private static String DEVICE_POPUP = "device.popup";
    private static Chips currentChips = null;
    private static IDeviceManager instance = new DeviceManager();
    private List<IDeviceChangedListener> listeners = new ArrayList<IDeviceChangedListener>();

    public static IDeviceManager getInstance() {
        return instance;
    }

    private static void SetChips(Chips chips) {
        currentChips = chips;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeviceChangedListener(IDeviceChangedListener listener) {
        List<IDeviceChangedListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeviceChangedListener(IDeviceChangedListener listener) {
        List<IDeviceChangedListener> list = this.listeners;
        synchronized (list) {
            Iterator<IDeviceChangedListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IDeviceChangedListener next = iterator.next();
                if (next != listener) continue;
                iterator.remove();
            }
        }
    }

    public synchronized String getCurrentDevice() {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                String current = node.get(CURRENT_DEVICE, "");
                return current;
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public List<String> getAllDevices() {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                String list = this.decrypt(node.get(LIST, ""));
                return Arrays.asList(list.split(";"));
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    public void updateDevices(File file, boolean replace) throws Exception {
        this.updateDevices(file, replace, true);
    }

    public void updateDevices(File file, boolean replace, boolean restart) throws Exception {
        Preferences node = this.getPreferences();
        File tempFile = PlatformCoreActivator.getDefault().getTempFile();
        if (tempFile.exists() && !tempFile.delete()) {
            return;
        }
        RSAUtil.decrypt(file, tempFile);
        String res = this.loadFile(replace, tempFile);
        node.put(LIST, this.encrypt(res));
        node.flush();
        DeviceManager.SetChips(this.initChipsData());
        if (!this.ifContainCurrentChip() && restart) {
            this.resetDevicePopupIfNotSetTrue();
            this.setCurrentDevice("");
            PlatformUI.getWorkbench().restart();
        } else {
            this.setCurrentDevice(this.getCurrentDevice());
        }
    }

    private String loadFile(boolean replace, File file) throws Exception {
        ArrayList chips;
        Chips originalChips;
        Chips combinedChips = new Chips();
        String rs = "";
        Chips newChips = (Chips)JaxbUtils.readObject(Chips.class, new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), DeviceManager.getConfigModelSchemaFile(), new ValidationEventCollector(), file.getName());
        combinedChips.setChips(newChips.getChips());
        if (!replace && (originalChips = this.initChipsData()) != null && (chips = originalChips.getChips()) != null && chips.size() > 0) {
            int i = 0;
            while (i < chips.size()) {
                this.combinedChips(combinedChips, (Chip)chips.get(i));
                ++i;
            }
        }
        rs = this.constructChipsPreferenceString(combinedChips);
        return rs;
    }

    private void combinedChips(Chips combinedChips, Chip newAdded) {
        if (combinedChips != null && combinedChips.getChips() != null) {
            ArrayList chips = combinedChips.getChips();
            if (chips.size() == 0) {
                chips.add(newAdded);
                return;
            }
            boolean duplicate = false;
            int i = 0;
            while (i < chips.size()) {
                Chip current = (Chip)chips.get(i);
                if (current.getId().equals(newAdded.getId()) && current.getName().equals(newAdded.getName()) && current.getProductionLine().equals(newAdded.getProductionLine())) {
                    duplicate = true;
                    ArrayList newAddedToolList = newAdded.getToolList();
                    if (newAddedToolList == null || newAddedToolList.size() == 0) break;
                    ArrayList currentToolList = current.getToolList();
                    if (currentToolList == null || currentToolList.size() == 0) {
                        current.setToolList(newAddedToolList);
                        break;
                    }
                    int k = 0;
                    while (k < newAddedToolList.size()) {
                        boolean find = false;
                        Tool newAddedTool = (Tool)newAddedToolList.get(k);
                        int j = 0;
                        while (j < currentToolList.size()) {
                            Tool currentTool = (Tool)currentToolList.get(j);
                            if (currentTool.getId().equals(newAddedTool.getId()) && currentTool.getName().equals(newAddedTool.getName())) {
                                find = true;
                                break;
                            }
                            ++j;
                        }
                        if (!find) {
                            currentToolList.add(newAddedTool);
                        }
                        ++k;
                    }
                    break;
                }
                ++i;
            }
            if (!duplicate) {
                chips.add(newAdded);
                return;
            }
        }
    }

    private String constructChipsPreferenceString(Chips chips) {
        String rs = "";
        if (chips != null && chips.getChips().size() > 0) {
            int i = 0;
            while (i < chips.getChips().size()) {
                Chip chip = (Chip)chips.getChips().get(i);
                String chipID = chip.getId();
                String chipName = chip.getName();
                String productionLine = chip.getProductionLine();
                StringBuffer record = new StringBuffer();
                record.append(chipID);
                record.append("@");
                record.append(chipName);
                record.append("@");
                record.append(productionLine);
                ArrayList toolList = chip.getToolList();
                if (toolList != null && toolList.size() > 0) {
                    record.append(":");
                    int j = 0;
                    while (j < toolList.size()) {
                        Tool tool = (Tool)toolList.get(j);
                        String toolID = tool.getId();
                        String toolName = tool.getName();
                        String toolparam = tool.getParam() == null ? "" : tool.getParam();
                        record.append(toolID);
                        record.append("@");
                        record.append(toolName);
                        record.append("@");
                        record.append(toolparam);
                        record.append(":");
                        ++j;
                    }
                    record.delete(record.length() - 1, record.length());
                }
                rs = String.valueOf(rs) + record + ";";
                ++i;
            }
            if (rs.length() > 0) {
                rs = rs.substring(0, rs.length() - 1);
            }
        }
        return rs;
    }

    private String encrypt(String str) {
        return str;
    }

    private String decrypt(String str) {
        return str;
    }

    public synchronized void setCurrentDevice(String device) {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                node.put(CURRENT_DEVICE, device);
                node.flush();
                this.fireDeviceChanged(device);
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireDeviceChanged(String device) {
        Chip chip = this.findChipByName(device);
        List<IDeviceChangedListener> list = this.listeners;
        synchronized (list) {
            List<IDeviceChangedListener> synchronizedList = Collections.synchronizedList(this.listeners);
            int i = 0;
            while (i < synchronizedList.size()) {
                try {
                    IDeviceChangedListener next = synchronizedList.get(i);
                    next.deviceChanged(chip);
                }
                catch (Exception e) {
                    HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
                ++i;
            }
        }
    }

    public Chip findChipByName(String device) {
        ArrayList children;
        if (DeviceManager.getCurrentChips() != null && (children = currentChips.getChips()) != null && children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                Chip chip = (Chip)children.get(i);
                if (chip.getName().equals(device)) {
                    return chip;
                }
                ++i;
            }
        }
        return null;
    }

    private Preferences getPreferences() {
        return PreferenceUtils.getPreferenceNode("com.soyatec.hisilicon.platform.core", DEVICE_NODE);
    }

    public static File getConfigModelSchemaFile() {
        URL resource = Chips.class.getResource(CONFIG_MODEL_SCHEMA_FILE);
        if (resource == null) {
            return null;
        }
        File schema = null;
        try {
            schema = new File(FileLocator.toFileURL((URL)resource).toURI());
        }
        catch (Exception e) {
            try {
                schema = new File(FileLocator.toFileURL((URL)resource).getFile());
            }
            catch (IOException e1) {
                return null;
            }
        }
        return schema;
    }

    public Chips initChipsData() {
        Chips result = new Chips();
        Preferences node = this.getPreferences();
        if (node != null) {
            try {
                String[] chipArr;
                ArrayList<Chip> chips = new ArrayList<Chip>();
                String res = this.decrypt(node.get(LIST, ""));
                if (res != null && res.length() > 0 && (chipArr = res.split(";")) != null && chipArr.length > 0) {
                    IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
                    List<IInstallableUnit> installIUs = toolManager.getInstalledToolIUs();
                    List<ToolDescriptor> featureTools = toolManager.collectFeatureTools(installIUs);
                    Map<String, List<String>> map = this.findPluginsByToolBuildID(installIUs, featureTools);
                    String[] stringArray = chipArr;
                    int n = chipArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String chipDetail = stringArray[n2];
                        Chip chip = new Chip();
                        String[] detail = chipDetail.split(":");
                        if (detail != null && detail.length > 0) {
                            ArrayList<Tool> tools = new ArrayList<Tool>();
                            int i = 0;
                            while (i < detail.length) {
                                String[] idArry;
                                String content = detail[i];
                                if (i == 0) {
                                    idArry = content.split("@");
                                    if (idArry != null && idArry.length == 3) {
                                        chip.setId(idArry[0]);
                                        chip.setName(idArry[1]);
                                        chip.setProductionLine(idArry[2]);
                                    }
                                } else {
                                    idArry = content.split("@");
                                    if (idArry != null) {
                                        Tool tool = new Tool();
                                        if (idArry.length == 2) {
                                            tool.setId(idArry[0]);
                                            tool.setName(idArry[1]);
                                            tool.setParam("");
                                        } else if (idArry.length == 3) {
                                            tool.setId(idArry[0]);
                                            tool.setName(idArry[1]);
                                            tool.setParam(idArry[2]);
                                        }
                                        tool.setContainingPlugin(map.get(tool.getId()));
                                        tools.add(tool);
                                    }
                                }
                                ++i;
                            }
                            chip.setToolList(tools);
                        }
                        chips.add(chip);
                        ++n2;
                    }
                }
                result.setChips(chips);
            }
            catch (Exception e) {
                HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Map<String, List<String>> findPluginsByToolBuildID(List<IInstallableUnit> installIUs, List<ToolDescriptor> tools) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (tools != null && tools.size() > 0) {
            int i = 0;
            while (i < tools.size()) {
                ToolDescriptor descriptor = tools.get(i);
                map.put(descriptor.getProperties().get("build.id"), Arrays.asList(descriptor.getPluginIds()));
                ++i;
            }
        }
        return map;
    }

    public static synchronized Chips getCurrentChips() {
        if (currentChips == null) {
            currentChips = ((DeviceManager)instance).initChipsData();
        }
        return currentChips;
    }

    public boolean ifContainCurrentChip() {
        if (DeviceManager.getCurrentChips() != null && currentChips.getChips().size() > 0) {
            ArrayList chips = currentChips.getChips();
            int i = 0;
            while (i < chips.size()) {
                Chip chip = (Chip)chips.get(i);
                if (chip.getName().equals(this.getCurrentDevice())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void updateDevicePopup(boolean state) {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                node.putBoolean(DEVICE_POPUP, state);
                node.flush();
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    private void resetDevicePopupIfNotSetTrue() {
        if (!this.needPopupDevice()) {
            Preferences node = this.getPreferences();
            try {
                if (node != null) {
                    node.remove(DEVICE_POPUP);
                    node.flush();
                }
            }
            catch (Exception e) {
                HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean needPopupDevice() {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                boolean current = node.getBoolean(DEVICE_POPUP, true);
                return current;
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean isSetPopupDevice() {
        Preferences node = this.getPreferences();
        try {
            if (node != null) {
                boolean current = node.getBoolean(DEVICE_POPUP, false);
                return current;
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void combinedNewToolSuiltableChips(String toolBuildID, String chipStr) throws BackingStoreException {
        if (chipStr != null && chipStr.length() > 0 && chipStr.indexOf(";") > 0) {
            String[] chipArr = chipStr.split(";");
            List<String> newToolSuiltableChips = Arrays.asList(chipArr);
            Chips chips = this.initChipsData();
            ArrayList currentInstallChips = chips.getChips();
            boolean hasChanged = false;
            if (currentInstallChips != null && currentInstallChips.size() > 0) {
                int i = 0;
                while (i < currentInstallChips.size()) {
                    boolean alreadyContain = false;
                    Chip chip = (Chip)currentInstallChips.get(i);
                    int k = 0;
                    while (k < newToolSuiltableChips.size()) {
                        String info = newToolSuiltableChips.get(k);
                        if (info != null && info.length() > 0 && info.split("#").length > 1) {
                            String[] split = info.split("#");
                            String chipID = split[0];
                            String toolBuildName = split[1];
                            String toolParam = "";
                            if (split.length > 2) {
                                toolParam = split[2];
                            }
                            if (chipID.equals(chip.getId())) {
                                ArrayList toolList = chip.getToolList();
                                int j = 0;
                                while (j < toolList.size()) {
                                    String param;
                                    Tool tool = (Tool)toolList.get(j);
                                    String string = param = tool.getParam() == null ? "" : tool.getParam();
                                    if (tool.getId().equals(toolBuildID) && param.equals(toolParam)) {
                                        alreadyContain = true;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!alreadyContain) {
                                    Tool tool = new Tool();
                                    tool.setId(toolBuildID);
                                    tool.setName(toolBuildName);
                                    tool.setParam(toolParam);
                                    chip.getToolList().add(tool);
                                    hasChanged = true;
                                }
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            if (hasChanged) {
                Preferences node = this.getPreferences();
                node.put(LIST, this.encrypt(this.constructChipsPreferenceString(chips)));
                node.flush();
            }
        }
    }

    public void combinedNewTestToolSuiltableChips(String[] selectChips, String toolBuildID) throws BackingStoreException {
        if (selectChips != null && selectChips.length > 0 && toolBuildID != null && toolBuildID.length() > 0) {
            List<String> newToolSuiltableChips = Arrays.asList(selectChips);
            Chips chips = this.initChipsData();
            ArrayList currentInstallChips = chips.getChips();
            boolean hasChanged = false;
            if (currentInstallChips != null && currentInstallChips.size() > 0) {
                int i = 0;
                while (i < currentInstallChips.size()) {
                    boolean alreadyContain = false;
                    Chip chip = (Chip)currentInstallChips.get(i);
                    int k = 0;
                    while (k < newToolSuiltableChips.size()) {
                        String chipID = newToolSuiltableChips.get(k);
                        if (chipID.equals(chip.getId())) {
                            ArrayList toolList = chip.getToolList();
                            int j = 0;
                            while (j < toolList.size()) {
                                Tool tool = (Tool)toolList.get(j);
                                if (tool.getId().equals(toolBuildID)) {
                                    alreadyContain = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!alreadyContain) {
                                Tool tool = new Tool();
                                tool.setId(toolBuildID);
                                tool.setName(toolBuildID);
                                chip.getToolList().add(tool);
                                hasChanged = true;
                            }
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            if (hasChanged) {
                Preferences node = this.getPreferences();
                node.put(LIST, this.encrypt(this.constructChipsPreferenceString(chips)));
                node.flush();
            }
        }
    }
}

