/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.internal;

import com.soyatec.hisilicon.platform.api.IPreferenceStorageHelper;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.internal.HisiErrorLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceStorageHelper
implements IPreferenceStorageHelper {
    private File file;
    Preferences preferences;
    private boolean needWrite;

    public PreferenceStorageHelper(File file) {
        this.file = file;
    }

    public IPreferenceStore getPreferenceStore(String pluginId) {
        return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), pluginId);
    }

    public void savePreferencesDataToFile(String pluginId, Collection<String> keys) {
        IPreferenceStore store = this.getPreferenceStore(pluginId);
        Map<String, String> values = this.getPreferenceValues(store, keys);
        PropertySet set = new PropertySet();
        set.id = pluginId;
        for (String k : keys) {
            set.entry.add(new MapEntry(k, values.get(k)));
        }
        if (this.preferences == null) {
            this.preferences = new Preferences();
        }
        this.preferences.properties.add(set);
        this.needWrite = true;
    }

    public Map<String, String> loadPreferencesDataFromFile(String pluginId) {
        IPreferenceStore store = this.getPreferenceStore(pluginId);
        HashMap<String, String> pref = new HashMap<String, String>();
        FileInputStream stream = null;
        InputStreamReader reader = null;
        try {
            stream = new FileInputStream(this.file);
            reader = new InputStreamReader((InputStream)stream, WorkbenchEncoding.getWorkbenchDefaultEncoding());
            if (this.preferences == null) {
                this.preferences = (Preferences)PreferenceStorageHelper.readObject(Preferences.class, reader);
            }
            if (this.preferences == null) {
                return null;
            }
            try {
                for (PropertySet s : this.preferences.properties) {
                    if (!s.id.equals(pluginId)) continue;
                    for (MapEntry e : s.entry) {
                        pref.put(e.key, e.value);
                    }
                }
                Set keys = pref.entrySet();
                for (Map.Entry key : keys) {
                    store.putValue((String)key.getKey(), (String)key.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void close() {
        if (this.needWrite) {
            try {
                PreferenceStorageHelper.writeObject(this.preferences, new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), WorkbenchEncoding.getWorkbenchDefaultEncoding()));
            }
            catch (IOException e) {
                HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, String> getPreferenceValues(IPreferenceStore store, Collection<String> keys) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            map.put(key, store.getString(key));
        }
        return map;
    }

    public static void writeObject(Object o, Writer writer) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(o, writer);
        writer.flush();
        writer.close();
    }

    public static Object readObject(Class c, Reader reader) throws IOException {
        Object obj = null;
        try {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                obj = unmarshaller.unmarshal(reader);
            }
            catch (Exception exception) {
                reader.close();
            }
        }
        finally {
            reader.close();
        }
        return obj;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType
    static class MapEntry {
        @XmlAttribute
        public String key;
        @XmlValue
        public String value;

        public MapEntry() {
        }

        public MapEntry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }

    @XmlRootElement(name="Preferences")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Preferences {
        @XmlElement(name="PropertySet")
        public List<PropertySet> properties = new ArrayList<PropertySet>();

        Preferences() {
        }
    }

    @XmlRootElement(name="PropertySet")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class PropertySet {
        @XmlAttribute
        public String id;
        @XmlElement(name="Entry")
        public List<MapEntry> entry = new ArrayList<MapEntry>();

        PropertySet() {
        }
    }
}

