/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.internal;

import com.soyatec.hisilicon.platform.api.IPreferenceStorageHelper;
import com.soyatec.hisilicon.platform.api.IToolPreferenceStorage;
import com.soyatec.hisilicon.platform.core.IPreferenceStorageManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.internal.HisiErrorLog;
import com.soyatec.hisilicon.platform.core.internal.PreferenceStorageHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class PreferenceStorageManager
implements IPreferenceStorageManager {
    static PreferenceStorageManager instance;
    Map<String, IExtension> pluginExtensions = new HashMap<String, IExtension>();

    public static synchronized IPreferenceStorageManager getInstance() {
        if (instance == null) {
            instance = new PreferenceStorageManager();
            instance.init();
            Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    try {
                        IExtensionDelta[] extensionDeltas = event.getExtensionDeltas("com.soyatec.hisilicon.platform.api", "storage");
                        if (extensionDeltas != null && extensionDeltas.length > 0) {
                            IExtensionDelta[] iExtensionDeltaArray = extensionDeltas;
                            int n = extensionDeltas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IExtensionDelta extensionDelta = iExtensionDeltaArray[n2];
                                IConfigurationElement[] configurationElements = extensionDelta.getExtension().getConfigurationElements();
                                if (configurationElements != null && configurationElements.length > 0) {
                                    instance.init();
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        return instance;
    }

    static IExtension[] getExtensions(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(id);
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        return extensions;
    }

    void init() {
        this.pluginExtensions.clear();
        IExtension[] extensions = PreferenceStorageManager.getExtensions("com.soyatec.hisilicon.platform.api.storage");
        if (extensions != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension e = iExtensionArray[n2];
                String pluginId = e.getContributor().getName();
                this.pluginExtensions.put(pluginId, e);
                ++n2;
            }
        }
    }

    IToolPreferenceStorage getToolPreferenceStorageImpl(String id) {
        IConfigurationElement[] configs;
        IExtension ext = this.pluginExtensions.get(id);
        if (ext != null && (configs = ext.getConfigurationElements()).length != 0) {
            try {
                return (IToolPreferenceStorage)configs[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean exportPreferences(String[] plugins, File file) {
        boolean success = false;
        PreferenceStorageHelper helper = new PreferenceStorageHelper(file);
        String[] stringArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IToolPreferenceStorage storage = this.getToolPreferenceStorageImpl(id);
            if (storage != null) {
                try {
                    storage.exportPreferences((IPreferenceStorageHelper)helper);
                }
                catch (Exception e) {
                    HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
                success = true;
            }
            ++n2;
        }
        helper.close();
        return success;
    }

    @Override
    public boolean importPreferences(String[] plugins, File file) {
        boolean success = false;
        PreferenceStorageHelper helper = new PreferenceStorageHelper(file);
        String[] stringArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IToolPreferenceStorage storage = this.getToolPreferenceStorageImpl(id);
            if (storage != null) {
                try {
                    storage.importPreferences((IPreferenceStorageHelper)helper);
                }
                catch (Exception e) {
                    HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
                success = true;
            }
            ++n2;
        }
        helper.close();
        return success;
    }
}

