/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal;

import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class NTP {
    static final String[] ntpServers = new String[]{StringConstants.decode("2596070458323231259961315785572381298360807277"), StringConstants.decode("7877147130230283312242426275188")};
    private static long currentInternetTime;
    public static final int retry = 2;
    public static final int port = 123;
    public static final int timeout = 3000;

    public static void init() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    currentInternetTime = NTP.fetchNetTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 30000L, 30000L);
    }

    /*
     * Loose catch block
     */
    public static long fetchNetTime() {
        InetAddress ipv4Addr = null;
        int i = 0;
        while (i < ntpServers.length) {
            try {
                ipv4Addr = InetAddress.getByName(ntpServers[i]);
                if (ipv4Addr != null) {
                    break;
                }
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
        int serviceStatus = -1;
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(3000);
            int attempts = 0;
            while (attempts <= 2) {
                try {
                    byte[] data = new NtpMessage().toByteArray();
                    DatagramPacket outgoing = new DatagramPacket(data, data.length, ipv4Addr, 123);
                    long sentTime = System.currentTimeMillis();
                    socket.send(outgoing);
                    DatagramPacket incoming = new DatagramPacket(data, data.length);
                    socket.receive(incoming);
                    NtpMessage msg = new NtpMessage(incoming.getData());
                    long l = NtpMessage.timestampToLong(msg.referenceTimestamp);
                    if (socket != null) {
                        socket.close();
                    }
                    return l;
                }
                catch (InterruptedIOException ex) {
                    try {
                        ex.printStackTrace();
                        ++attempts;
                    }
                    catch (NoRouteToHostException e) {
                        e.printStackTrace();
                        if (socket != null) {
                            socket.close();
                        }
                        break;
                    }
                    catch (ConnectException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                        break;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return System.currentTimeMillis();
    }

    public static long getCurrentInternetTime() {
        if (currentInternetTime < System.currentTimeMillis()) {
            return System.currentTimeMillis();
        }
        return currentInternetTime;
    }

    public static class NtpMessage {
        public byte leapIndicator = 0;
        public byte version = (byte)3;
        public byte mode = 0;
        public short stratum = 0;
        public byte pollInterval = 0;
        public byte precision = 0;
        public double rootDelay = 0.0;
        public double rootDispersion = 0.0;
        public byte[] referenceIdentifier = new byte[4];
        public double referenceTimestamp = 0.0;
        public double originateTimestamp = 0.0;
        public double receiveTimestamp = 0.0;
        public double transmitTimestamp = 0.0;

        public NtpMessage(byte[] array) {
            this.leapIndicator = (byte)(array[0] >> 6 & 3);
            this.version = (byte)(array[0] >> 3 & 7);
            this.mode = (byte)(array[0] & 7);
            this.stratum = NtpMessage.unsignedByteToShort(array[1]);
            this.pollInterval = array[2];
            this.precision = array[3];
            this.rootDelay = (double)array[4] * 256.0 + (double)NtpMessage.unsignedByteToShort(array[5]) + (double)NtpMessage.unsignedByteToShort(array[6]) / 256.0 + (double)NtpMessage.unsignedByteToShort(array[7]) / 65536.0;
            this.rootDispersion = (double)NtpMessage.unsignedByteToShort(array[8]) * 256.0 + (double)NtpMessage.unsignedByteToShort(array[9]) + (double)NtpMessage.unsignedByteToShort(array[10]) / 256.0 + (double)NtpMessage.unsignedByteToShort(array[11]) / 65536.0;
            this.referenceIdentifier[0] = array[12];
            this.referenceIdentifier[1] = array[13];
            this.referenceIdentifier[2] = array[14];
            this.referenceIdentifier[3] = array[15];
            this.referenceTimestamp = NtpMessage.decodeTimestamp(array, 16);
            this.originateTimestamp = NtpMessage.decodeTimestamp(array, 24);
            this.receiveTimestamp = NtpMessage.decodeTimestamp(array, 32);
            this.transmitTimestamp = NtpMessage.decodeTimestamp(array, 40);
        }

        public NtpMessage(byte leapIndicator, byte version, byte mode, short stratum, byte pollInterval, byte precision, double rootDelay, double rootDispersion, byte[] referenceIdentifier, double referenceTimestamp, double originateTimestamp, double receiveTimestamp, double transmitTimestamp) {
            this.leapIndicator = leapIndicator;
            this.version = version;
            this.mode = mode;
            this.stratum = stratum;
            this.pollInterval = pollInterval;
            this.precision = precision;
            this.rootDelay = rootDelay;
            this.rootDispersion = rootDispersion;
            this.referenceIdentifier = (byte[])referenceIdentifier.clone();
            this.referenceTimestamp = referenceTimestamp;
            this.originateTimestamp = originateTimestamp;
            this.receiveTimestamp = receiveTimestamp;
            this.transmitTimestamp = transmitTimestamp;
        }

        public NtpMessage() {
            this.mode = (byte)3;
            this.transmitTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
        }

        public byte[] toByteArray() {
            byte[] p = new byte[48];
            p[0] = (byte)(this.leapIndicator << 6 | this.version << 3 | this.mode);
            p[1] = (byte)this.stratum;
            p[2] = this.pollInterval;
            p[3] = this.precision;
            int l = (int)(this.rootDelay * 65536.0);
            p[4] = (byte)(l >> 24 & 0xFF);
            p[5] = (byte)(l >> 16 & 0xFF);
            p[6] = (byte)(l >> 8 & 0xFF);
            p[7] = (byte)(l & 0xFF);
            long ul = (long)(this.rootDispersion * 65536.0);
            p[8] = (byte)(ul >> 24 & 0xFFL);
            p[9] = (byte)(ul >> 16 & 0xFFL);
            p[10] = (byte)(ul >> 8 & 0xFFL);
            p[11] = (byte)(ul & 0xFFL);
            p[12] = this.referenceIdentifier[0];
            p[13] = this.referenceIdentifier[1];
            p[14] = this.referenceIdentifier[2];
            p[15] = this.referenceIdentifier[3];
            NtpMessage.encodeTimestamp(p, 16, this.referenceTimestamp);
            NtpMessage.encodeTimestamp(p, 24, this.originateTimestamp);
            NtpMessage.encodeTimestamp(p, 32, this.receiveTimestamp);
            NtpMessage.encodeTimestamp(p, 40, this.transmitTimestamp);
            return p;
        }

        public String toString() {
            String precisionStr = new DecimalFormat("0.#E0").format(Math.pow(2.0, this.precision));
            return "Leap indicator: " + this.leapIndicator + " " + "Version: " + this.version + " " + "Mode: " + this.mode + " " + "Stratum: " + this.stratum + " " + "Poll: " + this.pollInterval + " " + "Precision: " + this.precision + " (" + precisionStr + " seconds) " + "Root delay: " + new DecimalFormat("0.00").format(this.rootDelay * 1000.0) + " ms " + "Root dispersion: " + new DecimalFormat("0.00").format(this.rootDispersion * 1000.0) + " ms " + "Reference identifier: " + NtpMessage.referenceIdentifierToString(this.referenceIdentifier, this.stratum, this.version) + " " + "Reference timestamp: " + NtpMessage.timestampToString(this.referenceTimestamp) + " " + "Originate timestamp: " + NtpMessage.timestampToString(this.originateTimestamp) + " " + "Receive timestamp:   " + NtpMessage.timestampToString(this.receiveTimestamp) + " " + "Transmit timestamp: " + NtpMessage.timestampToString(this.transmitTimestamp);
        }

        public static short unsignedByteToShort(byte b) {
            if ((b & 0x80) == 128) {
                return (short)(128 + (b & 0x7F));
            }
            return b;
        }

        public static double decodeTimestamp(byte[] array, int pointer) {
            double r = 0.0;
            int i = 0;
            while (i < 8) {
                r += (double)NtpMessage.unsignedByteToShort(array[pointer + i]) * Math.pow(2.0, (3 - i) * 8);
                ++i;
            }
            return r;
        }

        public static void encodeTimestamp(byte[] array, int pointer, double timestamp) {
            int i = 0;
            while (i < 8) {
                double base = Math.pow(2.0, (3 - i) * 8);
                array[pointer + i] = (byte)(timestamp / base);
                timestamp -= (double)NtpMessage.unsignedByteToShort(array[pointer + i]) * base;
                ++i;
            }
            Random random = new Random();
            array[7] = (byte)random.nextInt(255);
        }

        public static String timestampToString(double timestamp) {
            if (timestamp == 0.0) {
                return "0";
            }
            double utc = timestamp - 2.2089888E9;
            long ms = (long)(utc * 1000.0);
            String date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date(ms));
            double fraction = timestamp - (double)((long)timestamp);
            String fractionSting = new DecimalFormat(".000000").format(fraction);
            return String.valueOf(date) + fractionSting;
        }

        public static long timestampToLong(double timestamp) {
            if (timestamp == 0.0) {
                return new Date().getTime();
            }
            double utc = timestamp - 2.2089888E9;
            long ms = (long)(utc * 1000.0);
            return ms;
        }

        public static String referenceIdentifierToString(byte[] ref, short stratum, byte version) {
            if (stratum == 0 || stratum == 1) {
                try {
                    return new String(ref, System.getProperty("file.encoding"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (version == 3) {
                return String.valueOf(NtpMessage.unsignedByteToShort(ref[0])) + "." + NtpMessage.unsignedByteToShort(ref[1]) + "." + NtpMessage.unsignedByteToShort(ref[2]) + "." + NtpMessage.unsignedByteToShort(ref[3]);
            }
            if (version == 4) {
                return "" + ((double)NtpMessage.unsignedByteToShort(ref[0]) / 256.0 + (double)NtpMessage.unsignedByteToShort(ref[1]) / 65536.0 + (double)NtpMessage.unsignedByteToShort(ref[2]) / 1.6777216E7 + (double)NtpMessage.unsignedByteToShort(ref[3]) / 4.294967296E9);
            }
            return "";
        }
    }
}

