/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal;

import com.soyatec.hisilicon.platform.osgi.StopLicenceCheck;
import com.soyatec.hisilicon.platform.osgi.internal.NTP;
import com.soyatec.hisilicon.platform.osgi.internal.OsgiBundleFileWrapperFactory;
import com.soyatec.hisilicon.platform.osgi.internal.PluginToolManager;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.OsgiTracker;
import com.soyatec.hisilicon.platform.osgi.internal.security.TaskRunner;
import com.soyatec.hisilicon.platform.osgi.internal.security.ToolLicenseChecker;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.packageadmin.PackageAdmin;

public class OsgiAdaptorHook
implements AdaptorHook {
    private EclipseLogListener logListener;
    private BundleContext context;
    private PluginToolManager pluginTollManager;
    private OsgiTracker tracker;

    public OsgiAdaptorHook(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook((AdaptorHook)this);
        if (StopLicenceCheck.openCheck()) {
            hookRegistry.addBundleFileWrapperFactoryHook((BundleFileWrapperFactoryHook)new OsgiBundleFileWrapperFactory());
        }
    }

    public void addProperties(Properties arg0) {
    }

    private void addListener(BundleContext bc) {
        try {
            ServiceReference readerRef = bc.getServiceReference(ExtendedLogReaderService.class.getName());
            ExtendedLogReaderService readerService = (ExtendedLogReaderService)bc.getService(readerRef);
            Location location = LocationManager.getConfigurationLocation();
            File logDirectory = new File(location.getURL().getFile(), "logs");
            if (!logDirectory.mkdirs()) {
                return;
            }
            this.logListener = new EclipseLogListener(logDirectory);
            readerService.addLogListener((LogListener)this.logListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void frameworkStart(BundleContext bc) throws BundleException {
        this.addListener(bc);
        ServiceReference serviceReference = bc.getServiceReference(PackageAdmin.class.getName());
        serviceReference = bc.getServiceReference(PlatformAdmin.class.getName());
        PlatformAdmin platformAdmin = (PlatformAdmin)bc.getService(serviceReference);
        this.context = bc;
        this.pluginTollManager = PluginToolManager.getInstance();
        this.tracker = new OsgiTracker(bc, platformAdmin);
        if (StopLicenceCheck.openCheck()) {
            try {
                this.tracker.frameworkStart();
            }
            catch (Exception e) {
                EclipseLogListener.logPlatformError(e.getMessage(), e);
            }
        }
        if (StopLicenceCheck.openCheck()) {
            TaskRunner.getInstance().launchOnce(new Runnable(){

                @Override
                public void run() {
                    ToolLicenseChecker.run();
                }
            }, 30000);
            NTP.init();
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void frameworkStop(BundleContext bc) throws BundleException {
        if (this.logListener != null) {
            this.logListener.stop();
        }
        this.pluginTollManager.close();
        if (StopLicenceCheck.openCheck()) {
            this.tracker.frameworkStop();
        }
    }

    public void frameworkStopping(BundleContext bc) {
        if (StopLicenceCheck.openCheck()) {
            this.tracker.frameworkStopping();
        }
    }

    public void handleRuntimeError(Throwable arg0) {
    }

    public void initialize(BaseAdaptor arg0) {
    }

    public URLConnection mapLocationToURLConnection(String arg0) throws IOException {
        return null;
    }
}

