/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal;

import com.soyatec.hisilicon.platform.osgi.internal.OsgiBundleEntry;
import com.soyatec.hisilicon.platform.osgi.internal.RC4;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.ReflectUtil;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class OsgiBundleFile
extends BundleFile {
    private static String META_INF_P2_INF = StringConstants.decode("401213019706758367787217716188376678");
    private static String JAVA_SECURITY_MESSAGE_DIGEST = StringConstants.decode("43762486840192036693690957311772906280142613827505875069398512500");
    private static String SHA1 = StringConstants.decode("1397244209");
    private static String GET_INSTANCE = StringConstants.decode("124998463548682745364243301");
    private static String DIGEST = StringConstants.decode("110403869045620");
    private static String CLASS = StringConstants.decode("51004554965875");
    private static String JAVA_SECURITY_DIGEST_INPUT_STREAM = StringConstants.decode("187958449770255175959034631184996705194798560213848320868262636976402162029");
    private static String META_INF_MANIFEST_MF = StringConstants.decode("441138380382702259153990393352176630926813318470");
    private boolean decrypt = true;
    private final BundleFile wrapped;

    public OsgiBundleFile(BundleFile bundleFile, long bundleID, BaseData data, File content) {
        super(bundleFile.getBaseFile());
        this.wrapped = bundleFile;
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public File getFile(String path, boolean nativeCode) {
        return this.wrapped.getFile(path, nativeCode);
    }

    public void open() throws IOException {
        this.wrapped.open();
    }

    public boolean containsDir(String dir) {
        return this.wrapped.containsDir(dir);
    }

    public Enumeration getEntryPaths(String path) {
        return this.wrapped.getEntryPaths(path);
    }

    public BundleEntry getEntry(String path) {
        BundleEntry entry = this.wrapped.getEntry(path);
        if (entry == null || !this.decrypt) {
            return entry;
        }
        if (META_INF_MANIFEST_MF.equals(path)) {
            return entry;
        }
        try {
            if (!path.endsWith(CLASS)) {
                return entry;
            }
            byte[] buf = entry.getBytes();
            if ((buf[0] & 0xFF) == 202 && (buf[1] & 0xFF) == 254 && (buf[2] & 0xFF) == 186 && (buf[3] & 0xFF) == 190) {
                return entry;
            }
            return this.decrypt(entry);
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
            return entry;
        }
    }

    private byte[] calculateKey() {
        try {
            InputStream in;
            BundleEntry p2 = this.wrapped.getEntry(META_INF_P2_INF);
            if (p2 != null && (in = p2.getInputStream()) != null) {
                Object sha1 = ReflectUtil.getInstance(JAVA_SECURITY_MESSAGE_DIGEST, GET_INSTANCE, SHA1);
                byte[] hash = OsgiBundleFile.calculateHash(sha1, in);
                return hash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] calculateHash(Object algorithm, InputStream fis) throws Exception {
        try {
            byte[] hash;
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStream dis = (InputStream)ReflectUtil.newInstance(JAVA_SECURITY_DIGEST_INPUT_STREAM, bis, algorithm);
            while (dis.read() != -1) {
            }
            byte[] byArray = hash = (byte[])ReflectUtil.invoke(algorithm, DIGEST);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            OsgiBundleFile.close(fis);
        }
    }

    private BundleEntry decrypt(BundleEntry entry) throws IOException {
        byte[] bytes = entry.getBytes();
        byte[] key = this.calculateKey();
        RC4 ownRc4 = new RC4(key);
        byte[] result = ownRc4.rc4(bytes);
        return new OsgiBundleEntry(entry, entry.getName(), result, entry.getFileURL());
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

