/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal;

import com.soyatec.hisilicon.platform.osgi.internal.P2InfUtils;
import com.soyatec.hisilicon.platform.osgi.internal.ToolFilter;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class PluginToolManager {
    private static final PluginToolManager INSTANCE = new PluginToolManager();
    private static final String SPLIT_CHAR = StringConstants.decode("59");
    private static String TOOL_NAME = StringConstants.decode("2147852068157609045349");
    private static String TRUE = StringConstants.decode("1953658213");
    private static String TOOL_FEATURE = StringConstants.decode("36034978083524681544326541925");
    private static String BUILD_ID = StringConstants.decode("7094692702250232164");
    private static String HI_TOOL = StringConstants.decode("79617225355116");
    private static String BUILD_VER = StringConstants.decode("1816241331776060286322");
    private static String SEP = StringConstants.decode("16448");
    private static String COM_SOYATEC_HISILICON_PLATFORM_RCP = "com.soyatec.hisilicon.platform.rcp";
    private static String TOOL_PLUGINS = StringConstants.decode("36034978083527504076355497587");
    private static String HI_PLATFORM = StringConstants.decode("341953090008327039971949");
    private static String META_INF_P2_INF = StringConstants.decode("401213019706758367787217716188376678");
    private Map<String, Boolean> toolMap = new HashMap<String, Boolean>();
    private Set<String> allTools = new HashSet<String>();
    private BundleContext context;
    private Map<String, String> toolNames = new HashMap<String, String>();
    private Map<String, String> toolFeatures = new HashMap<String, String>();
    private Map<String, String> toolPlugins = new HashMap<String, String>();
    private Map<String, Map<String, String>> p2Properties = new HashMap<String, Map<String, String>>();
    private Set<String> buildIds = new HashSet<String>();
    private PackageAdmin packageAdminService;
    private PlatformAdmin platformAdmin;
    private Bundle platformBundle;
    private List<String> platformContainsPlugins = new ArrayList<String>();
    private static Object lock = new Object();
    private Map urlTrackers = new HashMap();

    private PluginToolManager() {
    }

    public static PluginToolManager getInstance() {
        return INSTANCE;
    }

    public void init(PackageAdmin packageAdminService, PlatformAdmin platformAdmin, BundleContext context) {
        this.context = context;
        this.packageAdminService = packageAdminService;
        this.platformAdmin = platformAdmin;
        this.collectTools();
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin admin = this.packageAdminService;
        if (admin == null) {
            return null;
        }
        Bundle[] bundles = admin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public Bundle[] getBundles() {
        return this.context.getBundles();
    }

    public void collectTools() {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            this.collectTool(b);
            ++n2;
        }
    }

    public void disable(Bundle bundle) {
        PlatformAdmin admin = this.getPlatformAdmin();
        State state = admin.getState(false);
        BundleDescription desc = state.getBundle(bundle.getBundleId());
        DisabledInfo info = new DisabledInfo(bundle.getSymbolicName(), "Disabled via PDE", desc);
        admin.addDisabledInfo(info);
    }

    public InputStream getBundleFileStream(Bundle b, String path) {
        URL entry = b.getEntry(path);
        if (entry == null) {
            return null;
        }
        try {
            entry = this.resolve(entry);
            entry = this.toFileURL(entry);
            InputStream stream = entry.openStream();
            return stream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void collectTool(Bundle b) {
        String id = b.getSymbolicName();
        if (this.toolMap.containsKey(id)) {
            return;
        }
        InputStream stream = this.getBundleFileStream(b, META_INF_P2_INF);
        if (stream == null) {
            return;
        }
        Map<String, String> props = P2InfUtils.loadP2Inf(stream);
        if (TRUE.equals(props.get(HI_TOOL)) && !ToolFilter.isHiToolFilterIU(id) || TRUE.equals(props.get(HI_PLATFORM))) {
            String[] pArray;
            this.toolMap.put(id, Boolean.TRUE);
            String name = props.get(TOOL_NAME);
            this.toolNames.put(id, name);
            this.allTools.add(name);
            String feature = props.get(TOOL_FEATURE);
            this.toolFeatures.put(name, feature);
            this.toolFeatures.put(feature, name);
            String plugins = props.get(TOOL_PLUGINS);
            String[] stringArray = pArray = plugins.split(SPLIT_CHAR);
            int n = pArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                this.toolNames.put(p, name);
                ++n2;
            }
            this.toolPlugins.put(name, plugins);
            this.toolPlugins.put(feature, plugins);
            if (TRUE.equals(props.get(HI_PLATFORM)) && id.equals(COM_SOYATEC_HISILICON_PLATFORM_RCP)) {
                this.platformBundle = b;
                String[] split = plugins.split(SPLIT_CHAR);
                if (split.length > 0) {
                    this.platformContainsPlugins = Arrays.asList(split);
                }
            }
            this.p2Properties.put(id, props);
            String buildId = props.get(BUILD_ID);
            String buildVer = props.get(BUILD_VER);
            if (buildId != null) {
                String key = String.valueOf(buildId) + SEP + buildVer;
                this.buildIds.add(key);
                this.p2Properties.put(key, props);
            }
            return;
        }
        this.toolMap.put(b.getSymbolicName(), Boolean.FALSE);
    }

    public Set<String> getBuildIds() {
        return this.buildIds;
    }

    public Map<String, String> getP2Properties(String id) {
        return this.p2Properties.get(id);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.platformAdmin;
    }

    public boolean isTool(Bundle b) {
        Boolean res = this.toolMap.get(b.getSymbolicName());
        if (res == null) {
            this.collectTool(b);
        }
        return (res = this.toolMap.get(b.getSymbolicName())) == null ? false : res;
    }

    public boolean isTool(String id) {
        Boolean res = this.toolMap.get(id);
        if (res == null && this.getBundle(id) != null) {
            return this.isTool(this.getBundle(id));
        }
        return false;
    }

    public String getToolFeature(String name) {
        return this.toolFeatures.get(name);
    }

    public String[] getToolPlugins(String name) {
        String p = this.toolPlugins.get(name);
        return p.split(SPLIT_CHAR);
    }

    public boolean isPlatformContainsBundle(Bundle b) {
        return this.platformContainsPlugins.contains(b.getSymbolicName());
    }

    public Set<String> getAllToolNames() {
        return this.allTools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URLConverter getURLConverter(URL url) {
        String protocol = url.getProtocol();
        Object object = lock;
        synchronized (object) {
            ServiceTracker tracker = (ServiceTracker)this.urlTrackers.get(protocol);
            if (tracker == null) {
                String FILTER_PREFIX = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=";
                String FILTER_POSTFIX = "))";
                Filter filter = null;
                try {
                    filter = this.getContext().createFilter(String.valueOf(FILTER_PREFIX) + protocol + FILTER_POSTFIX);
                }
                catch (InvalidSyntaxException e) {
                    return null;
                }
                tracker = new ServiceTracker(this.getContext(), filter, null);
                tracker.open();
                this.urlTrackers.put(protocol, tracker);
            }
            return (URLConverter)tracker.getService();
        }
    }

    public URL resolve(URL url) throws IOException {
        URLConverter converter = this.getURLConverter(url);
        return converter == null ? url : converter.resolve(url);
    }

    public URL toFileURL(URL url) throws IOException {
        URLConverter converter = this.getURLConverter(url);
        return converter == null ? url : converter.toFileURL(url);
    }

    public void close() {
        this.closeURLTrackerServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeURLTrackerServices() {
        Object object = lock;
        synchronized (object) {
            if (!this.urlTrackers.isEmpty()) {
                for (String key : this.urlTrackers.keySet()) {
                    ServiceTracker tracker = (ServiceTracker)this.urlTrackers.get(key);
                    tracker.close();
                }
            }
            this.urlTrackers = new HashMap();
        }
    }

    public String getToolNameByBundleID(String bundleID) {
        return this.toolNames.get(bundleID);
    }

    public Bundle getPlatformBundle() {
        return this.platformBundle;
    }
}

