/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.security;

import com.soyatec.hisilicon.platform.osgi.internal.RC4;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.service.datalocation.Location;

public class EncryptStorage {
    private static String USER_HOME = StringConstants.decode("2166584234454673223013");
    private static String STORAGE = StringConstants.decode("32497644330903397");
    private static String TOOLS_STAT = StringConstants.decode("549850129523939642466676");
    private static String JAVA_HOME = StringConstants.decode("1962377779334091861349");
    private static String SECURE_KEY = StringConstants.decode("115392895296831387209524601");
    private static String STAT = StringConstants.decode("1937006964");
    private static Properties storage;
    private static volatile Properties stat;
    private static Object lock;

    static {
        lock = new Object();
    }

    static synchronized Properties getStorage() {
        if (storage == null) {
            try {
                storage = EncryptStorage.loadStorageFile();
            }
            catch (IOException e) {
                EclipseLogListener.logPlatformError(e.getMessage(), e);
            }
        }
        return storage;
    }

    protected static void saveStorageFile(Properties props) {
        block12: {
            File file = EncryptStorage.getStorageFile();
            FileOutputStream out = null;
            try {
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    props.save(buf, "");
                    byte[] byteArr = buf.toByteArray();
                    RC4 r = new RC4(SECURE_KEY);
                    byteArr = r.rc4(byteArr);
                    out = new FileOutputStream(file);
                    out.write(byteArr);
                }
                catch (Exception e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        EclipseLogListener.logPlatformError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected static Properties loadStorageFile() throws IOException {
        File file = EncryptStorage.getStorageFile();
        if (file == null) {
            return null;
        }
        byte[] content = EncryptStorage.getContents(file);
        RC4 r = new RC4(SECURE_KEY);
        content = r.rc4(content);
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(content));
        return p;
    }

    private static File getStorageFile() {
        return EncryptStorage.createEncryptionFile(STORAGE);
    }

    private static byte[] getContents(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream((int)file.length());
            byte[] buffer = new byte[512];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    static synchronized void syncStatFile() {
        block12: {
            FileOutputStream out = null;
            try {
                try {
                    Location location = LocationManager.getConfigurationLocation();
                    File file = new File(location.getURL().getFile(), TOOLS_STAT);
                    Properties prop = EncryptStorage.getStat();
                    out = new FileOutputStream(file);
                    prop.save(out, null);
                }
                catch (Exception e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        EclipseLogListener.logPlatformError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }
        }
    }

    static synchronized void saveStatFile(Properties props) {
        block12: {
            File file = EncryptStorage.getStatFile();
            FileOutputStream out = null;
            try {
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    props.save(buf, "");
                    byte[] byteArr = buf.toByteArray();
                    RC4 r = new RC4(SECURE_KEY);
                    byteArr = r.rc4(byteArr);
                    out = new FileOutputStream(file);
                    out.write(byteArr);
                }
                catch (Exception e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        EclipseLogListener.logPlatformError(e2.getMessage(), e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }
        }
    }

    static synchronized Properties loadStatFile() throws IOException {
        File file = EncryptStorage.getStatFile();
        if (file == null) {
            return null;
        }
        byte[] content = EncryptStorage.getContents(file);
        RC4 r = new RC4(SECURE_KEY);
        content = r.rc4(content);
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(content));
        return p;
    }

    private static File getStatFile() {
        return EncryptStorage.createEncryptionFile(STAT);
    }

    private static File createEncryptionFile(String fileName) {
        File file;
        String javaHome = System.getProperty(JAVA_HOME);
        if (javaHome != null) {
            block8: {
                file = new File(javaHome, fileName);
                if (file.exists() || file.createNewFile()) break block8;
                return null;
            }
            try {
                if (file.canWrite()) {
                    return file;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String userHome = System.getProperty(USER_HOME);
        file = new File(userHome, fileName);
        try {
            if (!file.exists() && !file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Properties getStat() {
        Object object = lock;
        synchronized (object) {
            if (stat == null) {
                try {
                    stat = EncryptStorage.loadStatFile();
                }
                catch (IOException e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                }
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStat(String key, String value) {
        Object object = lock;
        synchronized (object) {
            stat.put(key, value);
        }
    }

    static synchronized void saveStatFile() {
        EncryptStorage.saveStatFile(stat);
    }

    public static long getLongStat(String key) {
        String v = EncryptStorage.getStat(key);
        return v == null ? 0L : Long.parseLong(v);
    }

    public static String getStat(String key) {
        Properties s = EncryptStorage.getStat();
        return s.getProperty(key);
    }
}

