/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.security;

import com.soyatec.hisilicon.platform.osgi.internal.HiLogUtils;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class LogSynManager {
    public static void syncLogFile() {
        FileInputStream in = null;
        try {
            File logsDel = HiLogUtils.findLogDelFile();
            if (logsDel.exists()) {
                in = new FileInputStream(logsDel);
                Properties props = new Properties();
                props.load(in);
                in.close();
                List<File> logFiles = HiLogUtils.findAllLogFiles();
                if (logFiles != null && logFiles.size() > 0) {
                    int i = 0;
                    while (i < logFiles.size()) {
                        File log = logFiles.get(i);
                        LogSynManager.updateLogFile(log, props);
                        ++i;
                    }
                    if (!logsDel.delete()) {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                }
            }
        }
    }

    private static void updateLogFile(File log, Properties props) {
        String read = LogSynManager.read(log);
        Collection<Object> values = props.values();
        if (values != null && values.size() > 0) {
            for (String string : values) {
                String millis;
                String level;
                String toolName;
                String toolSymbolicName;
                String find;
                int start;
                String[] rs;
                if (string == null || string.length() <= 0 || (rs = string.split("@")).length != 4 || (start = read.indexOf(find = LogSynManager.format(toolSymbolicName = rs[0], toolName = rs[1], level = rs[2], millis = rs[3]))) < 0) continue;
                String recordEnd = "</record>\n";
                int end = read.indexOf(recordEnd, start) + recordEnd.length();
                String substring = read.substring(start, end);
                read = read.replace(substring, "");
            }
        }
        LogSynManager.write(log, read);
    }

    public static String read(File f) {
        StringBuffer sb;
        block16: {
            String s = null;
            sb = new StringBuffer();
            if (f.exists()) {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), System.getProperty("file.encoding")));
                        while ((s = br.readLine()) != null) {
                            sb.append(String.valueOf(s) + "\n");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                EclipseLogListener.logPlatformError(e2.getMessage(), e2);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            EclipseLogListener.logPlatformError(e.getMessage(), e);
                        }
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static void write(File f, String content) {
        BufferedWriter utput = null;
        try {
            if (!f.exists()) {
                return;
            }
            try {
                utput = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), System.getProperty("file.encoding")));
                utput.write(content);
            }
            catch (Exception e) {
                EclipseLogListener.logPlatformError(e.getMessage(), e);
            }
        }
        finally {
            if (utput != null) {
                try {
                    utput.close();
                }
                catch (IOException e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                }
            }
        }
    }

    private static String format(String symbolicName, String toolName, String level, String millis) {
        StringBuffer sb = new StringBuffer();
        sb.append("<record");
        sb.append(" tool-symbolicName=\"" + symbolicName + "\"");
        sb.append(" tool-name=\"" + toolName + "\"");
        sb.append(" level=\"" + level + "\"");
        sb.append(" millis=\"" + millis + "\"");
        sb.append(">");
        return sb.toString();
    }
}

