/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.security;

import com.soyatec.hisilicon.platform.osgi.StopLicenceCheck;
import com.soyatec.hisilicon.platform.osgi.internal.PluginToolManager;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.EncryptStorage;
import com.soyatec.hisilicon.platform.osgi.internal.security.LogSynManager;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import com.soyatec.hisilicon.platform.osgi.internal.security.TaskRunner;
import com.soyatec.hisilicon.platform.osgi.internal.security.ToolLicenseChecker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class OsgiTracker
implements BundleListener {
    private static String ELLAPSE = StringConstants.decode("28548185394803557");
    private static String INSTALL = StringConstants.decode("29676314707455084");
    private static String SEP_STR = StringConstants.decode("16448");
    private static String COUNTER = StringConstants.decode("27988572849333618");
    private static String START = StringConstants.decode("495873782388");
    Map<String, Long> startTime = new HashMap<String, Long>();
    private BundleContext bc;
    private PlatformAdmin platformAdmin;
    private long startupTime;
    private Set<String> enableBundles = new HashSet<String>();
    private Set<String> startBundles = new HashSet<String>();

    public OsgiTracker(BundleContext bc, PlatformAdmin platformAdmin) {
        if (StopLicenceCheck.openCheck()) {
            bc.addBundleListener((BundleListener)this);
        }
        this.bc = bc;
        this.platformAdmin = platformAdmin;
    }

    public void frameworkStart() throws Exception {
        this.startupTime = System.currentTimeMillis();
        this.enableBundles.clear();
        this.startBundles.clear();
        Bundle[] installedBundles = this.bc.getBundles();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < installedBundles.length) {
            Bundle bundle = installedBundles[i];
            String name = bundle.getSymbolicName();
            String version = bundle.getVersion().toString();
            if (!this.isBundleEnabled(bundle)) {
                sb.append(name).append(";");
            } else {
                this.enableBundles.add(String.valueOf(name) + SEP_STR + version);
            }
            ++i;
        }
        TaskRunner.getInstance().launchSpecificTimes(new Runnable(){

            @Override
            public void run() {
                EncryptStorage.syncStatFile();
            }
        }, 30000, 10);
    }

    public void frameworkStop() {
        if (StopLicenceCheck.openCheck()) {
            HashSet<String> notStarted = new HashSet<String>();
            notStarted.addAll(this.enableBundles);
            notStarted.removeAll(this.startBundles);
            long seconds = (System.currentTimeMillis() - this.startupTime) / 1000L;
            for (String key : notStarted) {
                String ellapse = String.valueOf(key) + SEP_STR + ELLAPSE;
                String value = EncryptStorage.getStat(ellapse);
                long t = value == null ? 0L : Long.parseLong(value);
                EncryptStorage.saveStat(ellapse, String.valueOf(t + seconds));
            }
            EncryptStorage.saveStatFile();
            EncryptStorage.syncStatFile();
        }
        LogSynManager.syncLogFile();
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        try {
            switch (event.getType()) {
                case 2: {
                    this.bundleStart(bundle);
                    break;
                }
                case 4: {
                    this.bundleStop(bundle);
                }
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
    }

    boolean isBundleEnabled(Bundle bundle) {
        BundleDescription description;
        State state = this.platformAdmin.getState(false);
        return state.getDisabledInfos(description = state.getBundle(bundle.getBundleId())).length == 0;
    }

    private void bundleStop(Bundle bundle) {
        String name = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        Long start = this.startTime.get(String.valueOf(name) + SEP_STR + version + SEP_STR + START);
        if (start != null) {
            String ellapse = String.valueOf(name) + SEP_STR + version + SEP_STR + ELLAPSE;
            String value = EncryptStorage.getStat(ellapse);
            long t = value == null ? 0L : Long.parseLong(value);
            long seconds = t + (System.currentTimeMillis() - start) / 1000L;
            EncryptStorage.saveStat(ellapse, String.valueOf(seconds));
            EncryptStorage.saveStatFile();
        }
    }

    private void bundleStart(Bundle bundle) {
        String counter;
        String value;
        String name = bundle.getSymbolicName();
        String version = bundle.getVersion().toString();
        this.startBundles.add(String.valueOf(name) + SEP_STR + version);
        String install = String.valueOf(name) + SEP_STR + version + SEP_STR + INSTALL;
        if (EncryptStorage.getStat(install) == null) {
            EncryptStorage.saveStat(install, String.valueOf(System.currentTimeMillis()));
        }
        int count = (value = EncryptStorage.getStat(counter = String.valueOf(name) + SEP_STR + version + SEP_STR + COUNTER)) == null ? 0 : Integer.parseInt(value);
        EncryptStorage.saveStat(counter, String.valueOf(++count));
        String start = String.valueOf(name) + SEP_STR + version + SEP_STR + START;
        long time = System.currentTimeMillis();
        this.startTime.put(start, time);
        EncryptStorage.saveStat(start, "" + time);
        EncryptStorage.saveStatFile();
        EncryptStorage.syncStatFile();
    }

    public void frameworkStopping() {
        if (StopLicenceCheck.openCheck() && this.startBundles != null && this.startBundles.size() > 0) {
            Iterator<String> iterator = this.startBundles.iterator();
            while (iterator != null && iterator.hasNext()) {
                String next = iterator.next();
                String[] split = next.split(SEP_STR);
                if (split == null || split.length <= 0) continue;
                ToolLicenseChecker.updateTrialState(ToolLicenseChecker.initRegistry(), PluginToolManager.getInstance(), split[0], true);
            }
        }
    }
}

