/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.security;

import com.soyatec.hisilicon.platform.osgi.internal.NTP;
import com.soyatec.hisilicon.platform.osgi.internal.PluginToolManager;
import com.soyatec.hisilicon.platform.osgi.internal.RC4;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.Base64;
import com.soyatec.hisilicon.platform.osgi.internal.security.EncryptStorage;
import com.soyatec.hisilicon.platform.osgi.internal.security.Encrypter;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import com.soyatec.hisilicon.platform.osgi.internal.security.TaskRunner;
import com.soyatec.hisilicon.platform.osgi.internal.security.TestBuildUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class ToolLicenseChecker {
    private static String COUNTER = StringConstants.decode("27988572849333618");
    private static String COM_SOYATEC_HISILICON_PLATFORM_CORE = StringConstants.decode("44975845576599891314511085142816151461019359216123777208932144120131455251045");
    private static String BUILD_VER = StringConstants.decode("1816241331776060286322");
    private static String CLASS = StringConstants.decode("51004554965875");
    private static String TOOLS_REG = StringConstants.decode("2147852068452889159015");
    private static String INFO = StringConstants.decode("1768842863");
    private static String SEP_STR = StringConstants.decode("16448");
    private static String BUILD_ID = StringConstants.decode("7094692702250232164");
    private static String BUNDLE_ACTIVATOR = StringConstants.decode("88338785475672371835552635359350517618");
    private static String BUILD_TIME = StringConstants.decode("464957780934671400004965");
    private static String ELLAPSE = StringConstants.decode("28548185394803557");
    private static String TOOL_NAME = StringConstants.decode("2147852068157609045349");
    private static String SHA1 = StringConstants.decode("1397244209");
    private static String TOOL_PLUGINS = StringConstants.decode("36034978083527504076355497587");
    private static String META_INF_P2_INF = StringConstants.decode("401213019706758367787217716188376678");
    private static String UNLIMITED = StringConstants.decode("2166225907184315950436");
    private static String COM_SOYATEC_HISILICON_PLATFORM_RCP = StringConstants.decode("175686896783593325447308926339125591644606871937983504722391187969264477040");
    private static String START = StringConstants.decode("495873782388");
    private static String FREE = StringConstants.decode("1718773093");
    private static String EXPIRE = StringConstants.decode("111567956439653");
    private static String SHARP_STR = StringConstants.decode("35");
    private static String LIC_TYPE = StringConstants.decode("7811884079824597093");
    private static String LIC_KEY = StringConstants.decode("6875986606611457401");
    private static String COM_SOYATEC_HISILICON_PLATFORM_UI = StringConstants.decode("686276940560911427528550493512209342361745593507748065321840578004940137");
    private static String Platform_Tool_Name = "Platform";
    public static final int PLATFROM_DISABLE_EVENT = -1;
    public static final int TOOL_DISABLE_EVENT = -10;

    static void checkRegistryUpdate() {
        try {
            Properties p = ToolLicenseChecker.initRegistry();
            if (p == null) {
                return;
            }
            Set<Object> keys = p.keySet();
            for (Object o : keys) {
                String key = (String)o;
                String value = p.getProperty(key);
                String[] v = key.split(SEP_STR);
                String tool = v[0];
                String version = v[1];
                v = value.split(SEP_STR);
                String regTime = v[0];
                String regCode = v[1];
                if (!ToolLicenseChecker.isNewRegisterCode(tool, version)) continue;
                ToolLicenseChecker.updateRegisterCode(tool, version, regTime, regCode);
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
    }

    private static void updateRegisterCode(String tool, String version, String regTime, String regCode) {
        PluginToolManager manager = PluginToolManager.getInstance();
        Map<String, String> p = manager.getP2Properties(String.valueOf(tool) + SEP_STR + version);
        String info = p.get(INFO);
        String[] code = ToolLicenseChecker.validateLicense(tool, version, info, regCode);
        if (code == null) {
            return;
        }
        String[] condition = code[3].split("=");
        Properties props = EncryptStorage.getStorage();
        props.put(String.valueOf(tool) + SEP_STR + version, String.valueOf(regCode) + SEP_STR + info + SEP_STR + condition[0] + SEP_STR + condition[1]);
        EncryptStorage.saveStorageFile(props);
    }

    public static void run() {
        TaskRunner runner = TaskRunner.getInstance();
        runner.launchRepeat(new Runnable(){
            long lastModified;

            @Override
            public void run() {
                Location location = LocationManager.getConfigurationLocation();
                File regFile = new File(location.getURL().getFile(), TOOLS_REG);
                long last = regFile.lastModified();
                if (last != this.lastModified) {
                    this.lastModified = last;
                    ToolLicenseChecker.checkRegistryUpdate();
                }
            }
        }, 60000, 5000);
        runner.launchRepeat(new Runnable(){

            @Override
            public void run() {
                ToolLicenseChecker.checkTrialExpire();
            }
        }, 0, 20000);
        runner.launchOnce(new Runnable(){

            @Override
            public void run() {
                ToolLicenseChecker.validateP2Info();
            }
        }, 10000);
    }

    protected static void validateP2Info() {
        Bundle[] bundles;
        PluginToolManager manager = PluginToolManager.getInstance();
        Bundle[] bundleArray = bundles = manager.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            String activator = (String)b.getHeaders().get(BUNDLE_ACTIVATOR);
            if (activator != null) {
                String c = String.valueOf(activator.replace('.', '/')) + CLASS;
                InputStream stream = manager.getBundleFileStream(b, c);
                if (stream == null) {
                    return;
                }
                byte[] content = ToolLicenseChecker.readClassFile(stream);
                if (content != null) {
                    stream = manager.getBundleFileStream(b, META_INF_P2_INF);
                    if (stream == null) {
                        manager.disable(b);
                    } else if (!ToolLicenseChecker.decryptFile(content, stream)) {
                        manager.disable(b);
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean decryptFile(byte[] content, InputStream stream) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance(SHA1);
            byte[] hash = ToolLicenseChecker.calculateHash(sha1, stream);
            RC4 ownRc4 = new RC4(hash);
            byte[] buf = ownRc4.rc4(content);
            return (buf[0] & 0xFF) == 202 && (buf[1] & 0xFF) == 254 && (buf[2] & 0xFF) == 186 && (buf[3] & 0xFF) == 190;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] calculateHash(MessageDigest algorithm, InputStream fis) throws Exception {
        try {
            byte[] hash;
            BufferedInputStream bis = new BufferedInputStream(fis);
            DigestInputStream dis = new DigestInputStream(bis, algorithm);
            while (dis.read() != -1) {
            }
            byte[] byArray = hash = algorithm.digest();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            ToolLicenseChecker.close(fis);
        }
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static byte[] readClassFile(InputStream stream) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buf = new byte[4];
            int read = stream.read(buf);
            if (read == buf.length) {
                if ((buf[0] & 0xFF) == 202 && (buf[1] & 0xFF) == 254 && (buf[2] & 0xFF) == 186 && (buf[3] & 0xFF) == 190) {
                    return null;
                }
                out.write(buf);
                buf = new byte[1024];
                while (read > 0) {
                    read = stream.read(buf);
                    out.write(buf, 0, read);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        catch (Exception exception) {
        }
        finally {
            ToolLicenseChecker.close(stream);
        }
        return null;
    }

    private static boolean isNewRegisterCode(String tool, String version) {
        Properties p = EncryptStorage.getStorage();
        return !p.contains(String.valueOf(tool) + SEP_STR + version);
    }

    static void checkTrialExpire() {
        Properties registry = ToolLicenseChecker.initRegistry();
        if (registry == null) {
            return;
        }
        PluginToolManager manager = PluginToolManager.getInstance();
        Set<String> buildIds = manager.getBuildIds();
        for (String i : buildIds) {
            ToolLicenseChecker.updateTrialState(registry, manager, i);
        }
    }

    public static void updateTrialState(Properties registry, PluginToolManager manager, String i) {
        try {
            ToolLicenseChecker.updateTrialState(registry, manager, i, false);
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
    }

    public static void updateTrialState(Properties registry, PluginToolManager manager, String i, boolean containsEqual) {
        Map<String, String> props = manager.getP2Properties(i);
        if (props != null) {
            String buildId = props.get(BUILD_ID);
            String ver = props.get(BUILD_VER);
            String info = props.get(INFO);
            String toolName = props.get(TOOL_NAME);
            String licType = ToolLicenseChecker.decodeLicType(props);
            if (TestBuildUtils.isTestBuild(props)) {
                return;
            }
            if (UNLIMITED.equalsIgnoreCase(licType)) {
                if (!ToolLicenseChecker.validateUnlimited(buildId, ver, info)) {
                    ToolLicenseChecker.disablePlugins(props.get(TOOL_PLUGINS), toolName);
                }
            } else {
                String value = registry.getProperty(String.valueOf(buildId) + SEP_STR + ver);
                if (value == null) {
                    if (licType.length() > 0) {
                        ToolLicenseChecker.checkTrialExpire(licType, props.get(TOOL_PLUGINS), toolName, containsEqual);
                    }
                } else {
                    String[] v = value.split(SEP_STR);
                    String regCode = v[1];
                    if (ToolLicenseChecker.validateLicense(buildId, ver, info, regCode) == null) {
                        ToolLicenseChecker.disablePlugins(props.get(TOOL_PLUGINS), toolName);
                    }
                }
            }
        }
    }

    private static void checkTrialExpire(String licType, String plugins, String toolName, boolean containsEqual) {
        String[] v = licType.split(":");
        String cond = v[0];
        String limit = v[1];
        if (cond.equals(EXPIRE)) {
            if (NTP.getCurrentInternetTime() > Long.parseLong(limit)) {
                ToolLicenseChecker.disablePlugins(plugins, toolName);
            } else {
                Long l = Long.parseLong(limit);
                if (NTP.getCurrentInternetTime() == l && containsEqual) {
                    ToolLicenseChecker.disablePlugins(plugins, toolName);
                }
            }
        } else if (cond.equals(COUNTER)) {
            long c = ToolLicenseChecker.maxLongStat(plugins, COUNTER);
            if (c > Long.parseLong(limit)) {
                ToolLicenseChecker.disablePlugins(plugins, toolName);
            } else {
                Long l = Long.parseLong(limit);
                if (c == l && containsEqual) {
                    ToolLicenseChecker.disablePlugins(plugins, toolName);
                }
            }
        } else if (cond.equals(ELLAPSE)) {
            double rs;
            long seconds = 0L;
            long start = ToolLicenseChecker.maxLongStat(plugins, START);
            if (start != 0L) {
                seconds = (NTP.getCurrentInternetTime() - start) / 1000L;
            }
            if ((rs = Double.parseDouble(limit) - (double)ToolLicenseChecker.maxLongStat(plugins, ELLAPSE) - (double)seconds) <= 0.0) {
                ToolLicenseChecker.disablePlugins(plugins, toolName);
            }
        } else {
            ToolLicenseChecker.disablePlugins(plugins, toolName);
        }
    }

    static long maxLongStat(String plugins, String field) {
        String[] pArray;
        PluginToolManager manager = PluginToolManager.getInstance();
        long max = 0L;
        String[] stringArray = pArray = plugins.split(";");
        int n = pArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            Bundle bundle = manager.getBundle(p);
            if (bundle != null) {
                String name = bundle.getSymbolicName();
                String version = bundle.getVersion().toString();
                String key = String.valueOf(name) + SEP_STR + version + SEP_STR + field;
                long v = EncryptStorage.getLongStat(key);
                if (v > max) {
                    max = v;
                }
            }
            ++n2;
        }
        return max;
    }

    static String decodeLicType(Map<String, String> props) {
        String lic = props.get(LIC_TYPE);
        String time = props.get(BUILD_TIME);
        try {
            if (lic != null && time != null) {
                RC4 r = new RC4(String.valueOf(LIC_KEY) + time);
                byte[] content = r.rc4(Base64.decode(lic));
                String text = new String(content, System.getProperty("file.encoding"));
                return text;
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
        return "";
    }

    private static String[] validateLicense(String id, String ver, String info, String regCode) {
        String[] v;
        block5: {
            block4: {
                try {
                    byte[] key = Encrypter.encodeMD5(regCode.getBytes(System.getProperty("file.encoding")));
                    byte[] cryptData = Base64.decode(info);
                    byte[] outputData = Encrypter.decrypt(cryptData, key);
                    String text = new String(outputData, System.getProperty("file.encoding"));
                    v = text.split(SHARP_STR);
                    if (987654321L == Long.parseLong(v[0], 16)) break block4;
                    return null;
                }
                catch (Exception e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                    return null;
                }
            }
            if (id.equals(v[1]) && ver.equals(v[2])) break block5;
            return null;
        }
        return v;
    }

    private static boolean validateUnlimited(String id, String ver, String info) {
        String[] v;
        block6: {
            block5: {
                String pass = String.valueOf(id) + SHARP_STR + ver + SHARP_STR + FREE;
                byte[] key = Encrypter.encodeMD5(pass.getBytes(System.getProperty("file.encoding")));
                byte[] cryptData = Base64.decode(info);
                byte[] content = Encrypter.decrypt(cryptData, key);
                String text = new String(content, System.getProperty("file.encoding"));
                v = text.split(SHARP_STR);
                if (987654321L == Long.parseLong(v[0], 16)) break block5;
                return false;
            }
            if (id.equals(v[1]) && ver.equals(v[2])) break block6;
            return false;
        }
        try {
            if (UNLIMITED.equals(v[3])) {
                return true;
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
        return false;
    }

    private static void disablePlugins(String str, String toolName) {
        try {
            PluginToolManager manager = PluginToolManager.getInstance();
            String[] pArray = str.split(";");
            boolean disabledPlatform = false;
            Framework framework = null;
            Bundle bundle = null;
            String[] stringArray = pArray;
            int n = pArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                bundle = manager.getBundle(p);
                if (bundle != null) {
                    if (framework == null && bundle.getBundleContext() != null) {
                        framework = ((BundleContextImpl)bundle.getBundleContext()).getFramework();
                    }
                    if ((p.equals(COM_SOYATEC_HISILICON_PLATFORM_CORE) || p.equals(COM_SOYATEC_HISILICON_PLATFORM_UI) || p.equals(COM_SOYATEC_HISILICON_PLATFORM_RCP)) && !disabledPlatform) {
                        disabledPlatform = true;
                        if (framework != null) {
                            framework.publishFrameworkEvent(-1, bundle, null);
                        }
                    }
                }
                ++n2;
            }
            if (toolName != null) {
                if (!toolName.equals(Platform_Tool_Name) && framework != null) {
                    framework.publishFrameworkEvent(-10, bundle, (Throwable)new Exception(toolName));
                }
                EclipseLogListener.logPlatformInfo(String.valueOf(toolName) + " : " + "Auto disabled by platform license checking.");
            }
        }
        catch (Exception e) {
            EclipseLogListener.logPlatformError(e.getMessage(), e);
        }
    }

    public static synchronized Properties initRegistry() {
        Properties p = new Properties();
        FileInputStream in = null;
        try {
            Location location = LocationManager.getConfigurationLocation();
            File regFile = new File(location.getURL().getFile(), TOOLS_REG);
            if (!regFile.exists() && !regFile.createNewFile()) {
                return null;
            }
            try {
                in = new FileInputStream(regFile);
                p.load(in);
                in.close();
            }
            catch (IOException e) {
                EclipseLogListener.logPlatformError(e.getMessage(), e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return p;
    }
}

