/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient4;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.filetransfer.events.socket.ISocketClosedEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketConnectedEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketCreatedEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;

public class ConnectingSocketMonitor
implements ISocketListener {
    private Map connectingSockets;

    public ConnectingSocketMonitor(int initialCapacity) {
        this.connectingSockets = Collections.synchronizedMap(new HashMap(initialCapacity));
    }

    public ConnectingSocketMonitor() {
        this.connectingSockets = Collections.synchronizedMap(new HashMap());
    }

    public Collection getConnectingSockets() {
        return Collections.unmodifiableCollection(this.connectingSockets.keySet());
    }

    public void clear() {
        this.connectingSockets.clear();
    }

    public void handleSocketEvent(ISocketEvent event) {
        if (event instanceof ISocketCreatedEvent) {
            this.connectingSockets.put(event.getFactorySocket(), event);
        } else if (event instanceof ISocketConnectedEvent) {
            this.connectingSockets.remove(event.getFactorySocket());
        } else if (event instanceof ISocketClosedEvent) {
            this.connectingSockets.remove(event.getFactorySocket());
        }
    }
}

