/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.soyatec.connector.api.serial.ISerialSettings;

public class SerialHelper {
    public static boolean isSerinalLibInstalled() {
        boolean valid = true;
        try {
            Class.forName("gnu.ioSerialPort");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            valid = false;
        }
        return valid;
    }

    public static List<String> listSerialPorts() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)portIdentifiers.nextElement();
            if (port.getPortType() != 1) continue;
            result.add(port.getName());
        }
        return result;
    }

    public static String[] arraySerialPorts() {
        List<String> listPortNames = SerialHelper.listSerialPorts();
        int i = 0;
        while (i < 3) {
            if (!listPortNames.isEmpty()) break;
            listPortNames = SerialHelper.listSerialPorts();
            ++i;
        }
        return listPortNames.toArray(new String[listPortNames.size()]);
    }

    public static List<CommPortIdentifier> getPortIdentifiers() {
        ArrayList<CommPortIdentifier> result = new ArrayList<CommPortIdentifier>();
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier nextElement = (CommPortIdentifier)portIdentifiers.nextElement();
            result.add(nextElement);
        }
        return result;
    }

    public static SerialPort createConnect(ISerialSettings serialSettings) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        SerialPort serialPort = null;
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)serialSettings.getSerialPort());
        serialPort = (SerialPort)portId.open(SerialHelper.class.getName(), serialSettings.getTimeout());
        SerialHelper.updateParameter(serialPort, serialSettings);
        return serialPort;
    }

    public static void updateParameter(SerialPort serialPort, ISerialSettings serialSettings) throws UnsupportedCommOperationException {
        if (serialPort == null) {
            return;
        }
        try {
            serialPort.setSerialPortParams(serialSettings.getBaudRate(), serialSettings.getDataBits(), serialSettings.getStopBits(), serialSettings.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            serialPort.close();
            throw new UnsupportedCommOperationException();
        }
    }
}

