/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.ui.config.telnet;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.soyatec.connector.api.IModifiedListener;
import org.soyatec.connector.api.ISettings;
import org.soyatec.connector.api.ui.config.telnet.IpAddressEditor;
import org.soyatec.connector.api.ui.config.telnet.NetworkPortMap;
import org.soyatec.connector.api.ui.config.telnet.TelnetMessages;
import org.soyatec.connector.api.ui.config.telnet.TelnetSetting;

public class TelnetSettingsPage {
    private IpAddressEditor fHostEditor;
    private Combo fNetworkPortCombo;
    private Text fTimeout;
    private Text fCommandPrompt;
    private Text fLoginPrompt;
    private Text fPasswordPrompt;
    private Text fLoginName;
    private Text fPassword;
    private final TelnetSetting fTerminalSettings;
    private IModifiedListener modifiedListener;

    public TelnetSettingsPage(TelnetSetting settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setHost(this.fHostEditor.getDisplayAddress());
        this.fTerminalSettings.setNetworkPort(this.getNetworkPort());
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null) {
            this.setHost(this.fTerminalSettings.getHost());
            this.setNetworkPort(this.fTerminalSettings.getNetworkPortString());
            this.setTimeout(this.fTerminalSettings.getTimeoutString());
            this.setCommandPrompt(this.fTerminalSettings.getCommandPrompt());
            this.setLoginPrompt(this.fTerminalSettings.getLoginPrompt());
            this.setPasswordPrompt(this.fTerminalSettings.getPasswordPrompt());
            this.setLoginName(this.fTerminalSettings.getLoginName());
            this.setPassword(this.fTerminalSettings.getPassword());
        }
    }

    private void setHost(String strHost) {
        if (strHost == null) {
            strHost = "";
        }
        this.fHostEditor.setAddress(strHost);
    }

    private void setTimeout(String timeout) {
        if (timeout == null || timeout.length() == 0) {
            timeout = "5";
        }
        this.fTimeout.setText(timeout);
    }

    private void setCommandPrompt(String commandPrompt) {
        if (commandPrompt == null || commandPrompt.length() == 0) {
            commandPrompt = "#";
        }
        this.fCommandPrompt.setText(commandPrompt);
    }

    private void setLoginPrompt(String loginPrompt) {
        if (loginPrompt == null || loginPrompt.length() == 0) {
            loginPrompt = "login:";
        }
        this.fLoginPrompt.setText(loginPrompt);
    }

    private void setPasswordPrompt(String passwordPrompt) {
        if (passwordPrompt == null || passwordPrompt.length() == 0) {
            passwordPrompt = "Password:";
        }
        this.fPasswordPrompt.setText(passwordPrompt);
    }

    private void setLoginName(String loginName) {
        if (loginName == null || loginName.length() == 0) {
            loginName = "root";
        }
        this.fLoginName.setText(loginName);
    }

    private void setPassword(String password) {
        if (password == null || password.length() == 0 || password.equalsIgnoreCase("")) {
            password = "";
        }
        this.fPassword.setText(password);
    }

    private void setNetworkPort(String strNetworkPort) {
        if (strNetworkPort != null) {
            int nIndex;
            String strPortName = this.getNetworkPortMap().findPortName(strNetworkPort);
            if (strPortName == null) {
                strPortName = strNetworkPort;
            }
            if ((nIndex = this.fNetworkPortCombo.indexOf(strPortName)) == -1) {
                if (this.fNetworkPortCombo.getItemCount() > 0) {
                    this.fNetworkPortCombo.select(0);
                }
            } else {
                this.fNetworkPortCombo.select(nIndex);
            }
        }
    }

    private String getNetworkPort() {
        String portText = this.fNetworkPortCombo.getText();
        String mappedPort = this.getNetworkPortMap().findPort(portText);
        return mappedPort != null ? mappedPort : portText;
    }

    private NetworkPortMap getNetworkPortMap() {
        return this.fTerminalSettings.getProperties().getNetworkPortMap();
    }

    public boolean validateSettings() {
        int p;
        block4: {
            if (this.fHostEditor.getDisplayAddress().trim().length() == 0) {
                return false;
            }
            try {
                p = Integer.parseInt(this.getNetworkPort().trim());
                if (p > 0 && p <= 65535) break block4;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        p = Integer.parseInt(this.fTimeout.getText().trim());
        return p >= 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.HOST) + ":");
        gridData = new GridData(768);
        this.fHostEditor = new IpAddressEditor(composite, 2048);
        this.fHostEditor.setLayoutData(gridData);
        this.fHostEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.PORT) + ":");
        gridData = new GridData(768);
        this.fNetworkPortCombo = new Combo(composite, 12);
        this.fNetworkPortCombo.setLayoutData((Object)gridData);
        this.fNetworkPortCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        List table = this.getNetworkPortMap().getNameTable();
        Collections.sort(table);
        this.loadCombo(this.fNetworkPortCombo, table);
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.TIMEOUT) + ":");
        this.fTimeout = new Text(composite, 2048);
        this.fTimeout.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                boolean matches;
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fTimeout.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
                e.doit = matches = Pattern.compile("[1-9]{1}[0-9]{0,1}").matcher(stringBuilder).matches();
            }
        });
        this.fTimeout.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        this.fTimeout.setTextLimit(2);
        this.fTimeout.setLayoutData((Object)new GridData(768));
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.COMMAND_PROMPT) + ":");
        this.fCommandPrompt = new Text(composite, 2048);
        this.fCommandPrompt.setLayoutData((Object)new GridData(768));
        this.fCommandPrompt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fCommandPrompt.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
            }
        });
        this.fCommandPrompt.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text widget = (Text)event.widget;
                String newValue = widget.getText();
                String cmdPrompt = TelnetSettingsPage.this.fTerminalSettings.getCommandPrompt();
                if (cmdPrompt == null || !cmdPrompt.equals(newValue)) {
                    TelnetSettingsPage.this.fTerminalSettings.setCommandPrompt(newValue);
                }
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.LOGIN_PROMPT) + ":");
        this.fLoginPrompt = new Text(composite, 2048);
        this.fLoginPrompt.setLayoutData((Object)new GridData(768));
        this.fLoginPrompt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fLoginPrompt.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
            }
        });
        this.fLoginPrompt.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text widget = (Text)event.widget;
                String newValue = widget.getText();
                String loginPrompt = TelnetSettingsPage.this.fTerminalSettings.getLoginPrompt();
                if (loginPrompt == null || !loginPrompt.equals(newValue)) {
                    TelnetSettingsPage.this.fTerminalSettings.setLoginPrompt(newValue);
                }
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.PASSWORD_PROMPT) + ":");
        this.fPasswordPrompt = new Text(composite, 2048);
        this.fPasswordPrompt.setLayoutData((Object)new GridData(768));
        this.fPasswordPrompt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fPasswordPrompt.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
            }
        });
        this.fPasswordPrompt.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text widget = (Text)event.widget;
                String newValue = widget.getText();
                String pswdPrompt = TelnetSettingsPage.this.fTerminalSettings.getPasswordPrompt();
                if (pswdPrompt == null || !pswdPrompt.equals(newValue)) {
                    TelnetSettingsPage.this.fTerminalSettings.setPasswordPrompt(newValue);
                }
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.LOGIN_NAME) + ":");
        this.fLoginName = new Text(composite, 2048);
        this.fLoginName.setLayoutData((Object)new GridData(768));
        this.fLoginName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fLoginName.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
            }
        });
        this.fLoginName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text widget = (Text)event.widget;
                String newValue = widget.getText();
                String loginName = TelnetSettingsPage.this.fTerminalSettings.getLoginName();
                if (loginName == null || !loginName.equals(newValue)) {
                    TelnetSettingsPage.this.fTerminalSettings.setLoginName(newValue);
                }
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.PASSWORD) + ":");
        this.fPassword = new Text(composite, 2048);
        this.fPassword.setLayoutData((Object)new GridData(768));
        this.fPassword.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 8) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(TelnetSettingsPage.this.fPassword.getText());
                stringBuilder.delete(e.start, e.end);
                stringBuilder.insert(e.start, e.text);
            }
        });
        this.fPassword.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Text widget = (Text)event.widget;
                String newValue = widget.getText();
                String password = TelnetSettingsPage.this.fTerminalSettings.getPassword();
                if (password == null || !password.equals(newValue)) {
                    TelnetSettingsPage.this.fTerminalSettings.setPassword(newValue);
                }
                TelnetSettingsPage.this.dispatchModifiedEvent();
            }
        });
        this.loadSettings();
    }

    private void loadCombo(Combo ctlCombo, List table) {
        for (String label : table) {
            ctlCombo.add(label);
        }
    }

    protected void dispatchModifiedEvent() {
        if (this.modifiedListener != null) {
            this.modifiedListener.modified((ISettings)this.fTerminalSettings);
        }
    }

    public IModifiedListener getModifiedListener() {
        return this.modifiedListener;
    }

    public void setModifiedListener(IModifiedListener modifiedListener) {
        this.modifiedListener = modifiedListener;
    }
}

