/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.core;

import com.ardublock.ui.listener.OpenblocksFrameListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.renderable.RenderableBlock;
import java.util.HashSet;
import java.util.Set;

public class Context {
    private static Context singletonContext;
    private boolean workspaceChanged;
    private String saveFilePath;
    private Set<RenderableBlock> highlightBlockSet;
    private Set<OpenblocksFrameListener> ofls;
    public static final String APP_NAME = "ArduBlock";
    private WorkspaceController workspaceController = new WorkspaceController();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context getContext() {
        if (singletonContext != null) return singletonContext;
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            if (singletonContext != null) return singletonContext;
            singletonContext = new Context();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonContext;
        }
    }

    private Context() {
        this.workspaceController.resetWorkspace();
        this.workspaceController.resetLanguage();
        this.workspaceController.setLangDefDtd(this.getClass().getResourceAsStream("/com/ardublock/block/lang_def.dtd"));
        this.workspaceController.setLangDefStream(this.getClass().getResourceAsStream("/com/ardublock/block/ardublock_def.xml"));
        this.workspaceController.loadFreshWorkspace();
        this.workspaceChanged = false;
        this.saveFilePath = null;
        this.highlightBlockSet = new HashSet<RenderableBlock>();
        this.ofls = new HashSet<OpenblocksFrameListener>();
    }

    public WorkspaceController getWorkspaceController() {
        return this.workspaceController;
    }

    public boolean isWorkspaceChanged() {
        return this.workspaceChanged;
    }

    public void setWorkspaceChanged(boolean workspaceChanged) {
        this.workspaceChanged = workspaceChanged;
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    public String makeFrameTitle() {
        String title = "ArduBlock ";
        title = this.saveFilePath == null ? title + "untitled" : title + this.saveFilePath;
        if (this.workspaceChanged) {
            title = title + " *";
        }
        return title;
    }

    public void highlightBlock(RenderableBlock block) {
        block.updateInSearchResults(true);
        this.highlightBlockSet.add(block);
    }

    public void cancelHighlightBlock(RenderableBlock block) {
        block.updateInSearchResults(false);
        this.highlightBlockSet.remove(block);
    }

    public void resetHightlightBlock() {
        for (RenderableBlock rb : this.highlightBlockSet) {
            rb.updateInSearchResults(false);
        }
        this.highlightBlockSet.clear();
    }

    public void registerOpenblocksFrameListener(OpenblocksFrameListener ofl) {
        this.ofls.add(ofl);
    }

    public void didSave() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didSave();
        }
    }

    public void didLoad() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didLoad();
        }
    }

    public void didGenerate(String sourcecode) {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didGenerate(sourcecode);
        }
    }
}

