/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator;

import com.ardublock.translator.adaptor.BlockAdaptor;
import com.ardublock.translator.adaptor.OpenBlocksAdaptor;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.TranslatorBlockFactory;
import com.ardublock.translator.block.exception.SocketNullException;
import edu.mit.blocks.codeblocks.Block;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Translator {
    private static final String variablePrefix = "_ABVAR_";
    private Set<String> headerFileSet;
    private Set<String> definitionSet;
    private Set<String> setupSet;
    private BlockAdaptor blockAdaptor;
    private Set<Long> inputPinSet;
    private Set<Long> outputPinSet;
    private Map<String, String> numberVariableSet;
    private Map<String, String> booleanVariableSet;
    private int variableCnt;

    public Translator() {
        this.reset();
    }

    public String translate(Long blockId) throws SocketNullException {
        this.reset();
        TranslatorBlockFactory translatorBlockFactory = new TranslatorBlockFactory();
        Block block = Block.getBlock(blockId);
        TranslatorBlock rootTranslatorBlock = translatorBlockFactory.buildTranslatorBlock(this, blockId, block.getGenusName(), block.getBlockLabel(), "", "");
        String loopCommand = rootTranslatorBlock.toCode();
        String headerCommand = "";
        if (!this.headerFileSet.isEmpty()) {
            for (String file : this.headerFileSet) {
                headerCommand = headerCommand + "#include <" + file + ">\n";
            }
            headerCommand = headerCommand + "\n";
        }
        if (!this.definitionSet.isEmpty()) {
            for (String command : this.definitionSet) {
                headerCommand = headerCommand + command + "\n";
            }
            headerCommand = headerCommand + "\n";
        }
        headerCommand = headerCommand + "void setup()\n{\n";
        if (!this.inputPinSet.isEmpty()) {
            for (Long pinNumber : this.inputPinSet) {
                headerCommand = headerCommand + "pinMode( " + pinNumber + " , INPUT);\n";
            }
        }
        if (!this.outputPinSet.isEmpty()) {
            for (Long pinNumber : this.outputPinSet) {
                headerCommand = headerCommand + "pinMode( " + pinNumber + " , OUTPUT);\n";
            }
        }
        if (!this.setupSet.isEmpty()) {
            for (String command : this.setupSet) {
                headerCommand = headerCommand + command + "\n";
            }
        }
        headerCommand = headerCommand + "}\n\n";
        String program = headerCommand + loopCommand;
        return program;
    }

    public BlockAdaptor getBlockAdaptor() {
        return this.blockAdaptor;
    }

    private void reset() {
        this.headerFileSet = new HashSet<String>();
        this.definitionSet = new HashSet<String>();
        this.setupSet = new HashSet<String>();
        this.inputPinSet = new HashSet<Long>();
        this.outputPinSet = new HashSet<Long>();
        this.numberVariableSet = new HashMap<String, String>();
        this.booleanVariableSet = new HashMap<String, String>();
        this.blockAdaptor = this.buildOpenBlocksAdaptor();
        this.variableCnt = 0;
    }

    private BlockAdaptor buildOpenBlocksAdaptor() {
        return new OpenBlocksAdaptor();
    }

    public void addHeaderFile(String headerFile) {
        this.headerFileSet.add(headerFile);
    }

    public void addSetupCommand(String command) {
        this.setupSet.add(command);
    }

    public void addDefinitionCommand(String command) {
        this.definitionSet.add(command);
    }

    public void addInputPin(Long pinNumber) {
        this.inputPinSet.add(pinNumber);
    }

    public void addOutputPin(Long pinNumber) {
        this.outputPinSet.add(pinNumber);
    }

    public String getNumberVariable(String userVarName) {
        return this.numberVariableSet.get(userVarName);
    }

    public String getBooleanVariable(String userVarName) {
        return this.booleanVariableSet.get(userVarName);
    }

    public void addNumberVariable(String userVarName, String internalName) {
        this.numberVariableSet.put(userVarName, internalName);
    }

    public void addBooleanVariable(String userVarName, String internalName) {
        this.booleanVariableSet.put(userVarName, internalName);
    }

    public String buildVariableName() {
        return this.buildVariableName("");
    }

    public String buildVariableName(String reference) {
        ++this.variableCnt;
        String varName = variablePrefix + this.variableCnt + "_";
        for (int i = 0; i < reference.length(); ++i) {
            char c = reference.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') continue;
            varName = varName + c;
        }
        return varName;
    }
}

