/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui;

import com.ardublock.core.Context;
import com.ardublock.ui.listener.ArdublockWorkspaceListener;
import com.ardublock.ui.listener.GenerateCodeButtonListener;
import com.ardublock.ui.listener.OpenButtonListener;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import com.ardublock.ui.listener.SaveButtonListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ArduBlockToolFrame
extends JFrame {
    private static final long serialVersionUID = 2841155965906223806L;
    private Context context = Context.getContext();

    public void addListener(OpenblocksFrameListener ofl) {
        this.context.registerOpenblocksFrameListener(ofl);
    }

    public ArduBlockToolFrame() {
        this.setTitle(this.context.makeFrameTitle());
        this.setSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.initOpenBlocks();
    }

    private void initOpenBlocks() {
        Context context = Context.getContext();
        WorkspaceController workspaceController = context.getWorkspaceController();
        JComponent workspaceComponent = workspaceController.getWorkspacePanel();
        Workspace workspace = Workspace.getInstance();
        workspace.addWorkspaceListener(new ArdublockWorkspaceListener(this));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new SaveButtonListener(this));
        JButton openButton = new JButton("Load");
        openButton.addActionListener(new OpenButtonListener(this));
        JButton generateButton = new JButton("Upload");
        generateButton.addActionListener(new GenerateCodeButtonListener(this));
        buttons.add(saveButton);
        buttons.add(openButton);
        buttons.add(generateButton);
        this.add((Component)buttons, "North");
        this.add((Component)workspaceComponent, "Center");
    }
}

