/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import edu.mit.blocks.controller.WorkspaceController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class OpenButtonListener
implements ActionListener {
    private Context context = Context.getContext();
    private JFileChooser fileChooser = new JFileChooser();
    private JFrame parentFrame;

    public OpenButtonListener(JFrame frame) {
        this.parentFrame = frame;
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("open action p");
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this.parentFrame, "over", "question", 1, 3, null, null, 1);
            if (optionValue == 0) {
                this.loadFile();
                this.context.didLoad();
            }
        } else {
            this.loadFile();
            this.context.didLoad();
        }
    }

    private void loadFile() {
        this.fileChooser.showOpenDialog(this.parentFrame);
        File savedFile = this.fileChooser.getSelectedFile();
        if (savedFile != null) {
            String saveFilePath = savedFile.getAbsolutePath();
            WorkspaceController workspaceController = this.context.getWorkspaceController();
            workspaceController.resetWorkspace();
            workspaceController.loadProjectFromPath(saveFilePath);
            this.context.setSaveFilePath(saveFilePath);
            this.context.setWorkspaceChanged(false);
            if (this.parentFrame != null) {
                this.parentFrame.setTitle(this.context.makeFrameTitle());
            }
        }
    }
}

