/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import edu.mit.blocks.controller.WorkspaceController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class SaveButtonListener
implements ActionListener {
    private Context context = Context.getContext();
    private JFileChooser fileChooser = new JFileChooser();
    private JFrame parentFrame;

    public SaveButtonListener(JFrame frame) {
        this.parentFrame = frame;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.context.isWorkspaceChanged()) {
            try {
                WorkspaceController workspaceController = this.context.getWorkspaceController();
                String saveString = workspaceController.getSaveString();
                String saveFilePath = this.context.getSaveFilePath();
                if (saveFilePath == null) {
                    File saveFile;
                    int chooseResult = this.fileChooser.showSaveDialog(this.parentFrame);
                    if (chooseResult == 0 && (saveFile = this.fileChooser.getSelectedFile()) != null) {
                        this.saveFile(saveFile, saveString);
                        saveFilePath = saveFile.getAbsolutePath();
                        this.context.setSaveFilePath(saveFilePath);
                        this.context.setWorkspaceChanged(false);
                        if (this.parentFrame != null) {
                            this.parentFrame.setTitle(this.context.makeFrameTitle());
                        }
                        this.context.didSave();
                    }
                } else {
                    File saveFile = new File(saveFilePath);
                    this.saveFile(saveFile, saveString);
                    this.context.setWorkspaceChanged(false);
                    if (this.parentFrame != null) {
                        this.parentFrame.setTitle(this.context.makeFrameTitle());
                    }
                    this.context.didSave();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveFile(File saveFile, String saveString) throws IOException {
        if (!saveFile.exists()) {
            saveFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(saveFile);
        fos.write(saveString.getBytes());
        fos.flush();
        fos.close();
    }
}

