/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.LinkRule;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceListener;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockLinkChecker {
    private static ArrayList<LinkRule> rules = new ArrayList();
    private static double MAX_LINK_DISTANCE = 20.0;

    public static void reset() {
        rules.clear();
    }

    public static void addRule(LinkRule rule) {
        rules.add(rule);
        if (rule instanceof WorkspaceListener) {
            Workspace.getInstance().addWorkspaceListener((WorkspaceListener)((Object)rule));
        }
    }

    public static void insertRule(LinkRule rule, int index) {
        rules.remove(rule);
        rules.add(index, rule);
    }

    public static void removeRule(LinkRule rule) {
        rules.remove(rule);
    }

    public static BlockLink canLink(Block block1, Block block2, BlockConnector con1, BlockConnector con2) {
        if (BlockLinkChecker.checkRules(block1, block2, con1, con2)) {
            return BlockLink.getBlockLink(block1, block2, con1, con2);
        }
        return null;
    }

    public static BlockLink getLink(RenderableBlock rblock1, Iterable<RenderableBlock> otherBlocks) {
        Block block1 = Block.getBlock(rblock1.getBlockID());
        BlockConnector closestSocket1 = null;
        BlockConnector closestSocket2 = null;
        Block closestBlock2 = null;
        double closestDistance = MAX_LINK_DISTANCE;
        for (RenderableBlock rblock2 : otherBlocks) {
            double currentDistance;
            BlockConnector currentPlug = BlockLinkChecker.getPlugEquivalent(block1);
            Block block2 = Block.getBlock(rblock2.getBlockID());
            if (block1.equals(block2) || !rblock1.isVisible() || !rblock2.isVisible() || rblock1.isCollapsed() || rblock2.isCollapsed()) continue;
            Point2D currentPlugPoint = null;
            Point2D currentSocketPoint = null;
            if (currentPlug != null) {
                currentPlugPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock1, currentPlug);
                for (BlockConnector currentSocket : BlockLinkChecker.getSocketEquivalents(block2)) {
                    currentSocketPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock2, currentSocket);
                    currentDistance = currentPlugPoint.distance(currentSocketPoint);
                    if (!(currentDistance < closestDistance) || !BlockLinkChecker.checkRules(block1, block2, currentPlug, currentSocket)) continue;
                    closestBlock2 = block2;
                    closestSocket1 = currentPlug;
                    closestSocket2 = currentSocket;
                    closestDistance = currentDistance;
                }
            }
            if ((currentPlug = BlockLinkChecker.getPlugEquivalent(block2)) == null) continue;
            currentPlugPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock2, currentPlug);
            for (BlockConnector currentSocket : BlockLinkChecker.getSocketEquivalents(block1)) {
                currentSocketPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock1, currentSocket);
                currentDistance = currentPlugPoint.distance(currentSocketPoint);
                if (!(currentDistance < closestDistance) || !BlockLinkChecker.checkRules(block1, block2, currentSocket, currentPlug)) continue;
                closestBlock2 = block2;
                closestSocket1 = currentSocket;
                closestSocket2 = currentPlug;
                closestDistance = currentDistance;
            }
        }
        if (closestSocket1 == null) {
            return null;
        }
        return BlockLink.getBlockLink(block1, closestBlock2, closestSocket1, closestSocket2);
    }

    public static BlockLink getWeakLink(RenderableBlock rblock1, Iterable<RenderableBlock> otherBlocks) {
        Block block1 = Block.getBlock(rblock1.getBlockID());
        BlockConnector closestSocket1 = null;
        BlockConnector closestSocket2 = null;
        Block closestBlock2 = null;
        double closestDistance = Double.POSITIVE_INFINITY;
        for (RenderableBlock rblock2 : otherBlocks) {
            double currentDistance;
            BlockConnector currentPlug = BlockLinkChecker.getPlugEquivalent(block1);
            Block block2 = Block.getBlock(rblock2.getBlockID());
            if (block1.equals(block2) || !rblock1.isVisible() || !rblock2.isVisible()) continue;
            Point2D currentPlugPoint = null;
            Point2D currentSocketPoint = null;
            if (currentPlug != null) {
                currentPlugPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock1, currentPlug);
                for (BlockConnector currentSocket : BlockLinkChecker.getSocketEquivalents(block2)) {
                    currentSocketPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock2, currentSocket);
                    currentDistance = currentPlugPoint.distance(currentSocketPoint);
                    if (!(currentDistance < closestDistance) || !BlockLinkChecker.checkRules(block1, block2, currentPlug, currentSocket)) continue;
                    closestBlock2 = block2;
                    closestSocket1 = currentPlug;
                    closestSocket2 = currentSocket;
                    closestDistance = currentDistance;
                }
            }
            if ((currentPlug = BlockLinkChecker.getPlugEquivalent(block2)) == null) continue;
            currentPlugPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock2, currentPlug);
            for (BlockConnector currentSocket : BlockLinkChecker.getSocketEquivalents(block1)) {
                currentSocketPoint = BlockLinkChecker.getAbsoluteSocketPoint(rblock1, currentSocket);
                currentDistance = currentPlugPoint.distance(currentSocketPoint);
                if (!(currentDistance < closestDistance) || !BlockLinkChecker.checkRules(block1, block2, currentSocket, currentPlug)) continue;
                closestBlock2 = block2;
                closestSocket1 = currentSocket;
                closestSocket2 = currentPlug;
                closestDistance = currentDistance;
            }
        }
        if (closestSocket1 == null) {
            return null;
        }
        return BlockLink.getBlockLink(block1, closestBlock2, closestSocket1, closestSocket2);
    }

    private static boolean checkRules(Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        Iterator<LinkRule> rulesList = Collections.unmodifiableList(rules).iterator();
        LinkRule currentRule = null;
        boolean foundRule = false;
        while (rulesList.hasNext()) {
            currentRule = rulesList.next();
            boolean canLink = currentRule.canLink(block1, block2, socket1, socket2);
            if (!currentRule.isMandatory()) {
                foundRule |= canLink;
                continue;
            }
            if (canLink) continue;
            return false;
        }
        return foundRule;
    }

    private static Point2D getAbsoluteSocketPoint(RenderableBlock block, BlockConnector socket) {
        Point relativePoint = block.getSocketPixelPoint(socket);
        Point blockPosition = block.getLocationOnScreen();
        return new Point2D.Double(((Point2D)relativePoint).getX() + ((Point2D)blockPosition).getX(), ((Point2D)relativePoint).getY() + ((Point2D)blockPosition).getY());
    }

    public static boolean hasPlugEquivalent(Block b) {
        if (b == null) {
            return false;
        }
        boolean hasPlug = b.hasPlug();
        boolean hasBefore = b.hasBeforeConnector();
        assert (!(hasPlug & hasBefore));
        return hasPlug | hasBefore;
    }

    public static BlockConnector getPlugEquivalent(Block b) {
        if (!BlockLinkChecker.hasPlugEquivalent(b)) {
            return null;
        }
        if (b.hasPlug()) {
            return b.getPlug();
        }
        return b.getBeforeConnector();
    }

    public static Iterable<BlockConnector> getSocketEquivalents(Block b) {
        if (b == null) {
            return new ArrayList<BlockConnector>();
        }
        if (!b.hasAfterConnector()) {
            return b.getSockets();
        }
        ArrayList<BlockConnector> socketEquivalents = new ArrayList<BlockConnector>();
        for (BlockConnector socket : b.getSockets()) {
            socketEquivalents.add(socket);
        }
        socketEquivalents.add(b.getAfterConnector());
        return Collections.unmodifiableList(socketEquivalents);
    }

    public static void printRules() {
    }
}

