/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStub
extends Block {
    private static HashMap<String, Long> parentNameToParentBlock = new HashMap();
    private static HashMap<String, ArrayList<Long>> parentNameToBlockStubs = new HashMap();
    private static Map<String, String> parentToPlugType = new HashMap<String, String>();
    private static final String GETTER_STUB = "getter";
    private static final String SETTER_STUB = "setter";
    private static final String CALLER_STUB = "caller";
    private static final String AGENT_STUB = "agent";
    private static final String INC_STUB = "inc";
    private String parentName;
    private final String parentGenus;
    private final String stubGenus;

    public BlockStub(Long initParentID, String parentGenus, String parentName, String stubGenus) {
        super(stubGenus);
        assert (initParentID != Block.NULL) : "Parent id of stub should not be null";
        this.parentGenus = parentGenus;
        this.parentName = parentName;
        this.stubGenus = stubGenus;
        Block parent = Block.getBlock(initParentID);
        this.setBlockLabel(parent.getBlockLabel());
        if (stubGenus.startsWith(GETTER_STUB)) {
            if (parent.getNumSockets() > 0) {
                this.setPlug(parent.getSocketAt(0).getKind(), this.getPlug().getPositionType(), this.getPlugLabel(), this.getPlug().isLabelEditable(), Block.NULL);
            } else {
                this.setPlug(parent.getPlugKind(), this.getPlug().getPositionType(), this.getPlugLabel(), this.getPlug().isLabelEditable(), Block.NULL);
            }
        } else if (stubGenus.startsWith(SETTER_STUB)) {
            BlockConnector mySoc = this.getSocketAt(0);
            if (parent.getNumSockets() > 0) {
                this.setSocketAt(0, parent.getSocketAt(0).getKind(), mySoc.getPositionType(), mySoc.getLabel(), mySoc.isLabelEditable(), mySoc.isExpandable(), mySoc.getBlockID());
            } else {
                this.setSocketAt(0, parent.getPlugKind(), mySoc.getPositionType(), mySoc.getLabel(), mySoc.isLabelEditable(), mySoc.isExpandable(), mySoc.getBlockID());
            }
        } else if (stubGenus.startsWith(CALLER_STUB)) {
            String kind;
            if (parent.getSocketAt(0).getBlockID() != Block.NULL || parent.getNumSockets() > 1) {
                Iterator<BlockConnector> sockets = parent.getSockets().iterator();
                int i = 0;
                while (sockets.hasNext()) {
                    BlockConnector socket = sockets.next();
                    if (socket.getBlockID() != Block.NULL) {
                        this.addSocket(socket.getKind(), BlockConnector.PositionType.SINGLE, Block.getBlock(socket.getBlockID()).getBlockLabel(), false, false, Block.NULL);
                    }
                    ++i;
                }
            }
            if ((kind = parentToPlugType.get(parent.getBlockLabel() + parent.getGenusName())) != null) {
                this.removeBeforeAndAfter();
                this.setPlug(kind, BlockConnector.PositionType.SINGLE, "", false, Block.NULL);
            }
        } else if (stubGenus.startsWith(AGENT_STUB)) {
            if (parent.getNumSockets() > 0) {
                this.setPlug(parent.getSocketAt(0).getKind(), this.getPlug().getPositionType(), this.getPlugLabel(), this.getPlug().isLabelEditable(), this.getPlugBlockID());
            } else {
                this.setPlug(parent.getPlugKind(), this.getPlug().getPositionType(), this.getPlugLabel(), this.getPlug().isLabelEditable(), this.getPlugBlockID());
            }
        } else if (stubGenus.startsWith(INC_STUB)) {
            // empty if block
        }
        this.setPageLabel(parent.getPageLabel());
        parentNameToBlockStubs.get(parentName + parentGenus).add(this.getBlockID());
    }

    protected BlockStub(Long blockID, String stubGenus, String label, String parentName, String parentGenus) {
        super(blockID, stubGenus, label, true);
        this.stubGenus = stubGenus;
        this.parentName = parentName;
        this.parentGenus = parentGenus;
        String key = parentName + parentGenus;
        if (parentNameToBlockStubs.containsKey(key)) {
            parentNameToBlockStubs.get(parentName + parentGenus).add(this.getBlockID());
        } else {
            ArrayList<Long> stubs = new ArrayList<Long>();
            stubs.add(this.getBlockID());
            parentNameToBlockStubs.put(key, stubs);
        }
    }

    public static void reset() {
        parentNameToBlockStubs.clear();
        parentNameToParentBlock.clear();
    }

    public static Iterable<Long> getStubsOfParent(Long blockID) {
        ArrayList<Long> stubs = parentNameToBlockStubs.get(Block.getBlock(blockID).getBlockLabel() + Block.getBlock(blockID).getGenusName());
        if (stubs != null) {
            return stubs;
        }
        return new ArrayList<Long>();
    }

    public static void putNewParentInStubMap(Long blockID) {
        String key = Block.getBlock(blockID).getBlockLabel() + Block.getBlock(blockID).getGenusName();
        parentNameToParentBlock.put(key, blockID);
        if (parentNameToBlockStubs.get(key) == null) {
            parentNameToBlockStubs.put(key, new ArrayList());
        }
        for (Long stubID : parentNameToBlockStubs.get(key)) {
            BlockStub stub = (BlockStub)Block.getBlock(stubID);
            stub.notifyRenderable();
        }
    }

    public static void parentNameChanged(String oldParentName, String newParentName, Long parentID) {
        String newKey;
        String oldKey = oldParentName + Block.getBlock(parentID).getGenusName();
        if (!oldKey.equals(newKey = newParentName + Block.getBlock(parentID).getGenusName())) {
            parentNameToParentBlock.put(newKey, parentID);
            ArrayList<Long> stubs = parentNameToBlockStubs.get(oldKey);
            for (Long stub : stubs) {
                BlockStub blockStub = (BlockStub)Block.getBlock(stub);
                blockStub.parentName = newParentName;
                blockStub.setBlockLabel(newParentName);
                blockStub.notifyRenderable();
            }
            ArrayList<Long> existingStubs = parentNameToBlockStubs.get(newKey);
            if (existingStubs != null) {
                stubs.addAll(existingStubs);
            }
            parentNameToBlockStubs.put(newKey, stubs);
            parentNameToParentBlock.remove(oldKey);
            parentNameToBlockStubs.remove(oldKey);
        }
    }

    public static void parentPageLabelChanged(String newPageLabel, Long parentID) {
        String key = Block.getBlock(parentID).getBlockLabel() + Block.getBlock(parentID).getGenusName();
        ArrayList<Long> stubs = parentNameToBlockStubs.get(key);
        for (Long stub : stubs) {
            BlockStub blockStub = (BlockStub)Block.getBlock(stub);
            blockStub.setPageLabel(newPageLabel);
            blockStub.notifyRenderable();
        }
    }

    public static void parentConnectorsChanged(Long parentID) {
        String key = Block.getBlock(parentID).getBlockLabel() + Block.getBlock(parentID).getGenusName();
        ArrayList<Long> stubs = parentNameToBlockStubs.get(key);
        for (Long stub : stubs) {
            BlockStub blockStub = (BlockStub)Block.getBlock(stub);
            if (!blockStub.stubGenus.startsWith(CALLER_STUB)) continue;
            blockStub.updateConnectors();
            blockStub.notifyRenderable();
        }
    }

    public static void parentPlugChanged(Long parentID, String kind) {
        String key = Block.getBlock(parentID).getBlockLabel() + Block.getBlock(parentID).getGenusName();
        if (kind == null) {
            parentToPlugType.remove(key);
        } else {
            parentToPlugType.put(key, kind);
        }
        ArrayList<Long> stubs = parentNameToBlockStubs.get(key);
        for (Long stub : stubs) {
            BlockStub blockStub = (BlockStub)Block.getBlock(stub);
            if (!blockStub.stubGenus.startsWith(CALLER_STUB)) continue;
            if (kind == null) {
                blockStub.restoreInitConnectors();
                continue;
            }
            blockStub.updatePlug(kind);
        }
    }

    public String getParentName() {
        return this.parentName;
    }

    public Block getParent() {
        String key = this.parentName + this.parentGenus;
        if (!parentNameToParentBlock.containsKey(key)) {
            return null;
        }
        return Block.getBlock(parentNameToParentBlock.get(key));
    }

    public String getParentGenus() {
        return this.parentGenus;
    }

    public boolean doesParentExist() {
        return true;
    }

    @Override
    public void changeGenusTo(String genusName) {
    }

    private void updateConnectors() {
        Block parent = this.getParent();
        if (parent != null) {
            Iterator<BlockConnector> parentSockets = parent.getSockets().iterator();
            for (BlockConnector socket : this.getSockets()) {
                this.removeSocket(socket);
            }
            int i = 0;
            while (parentSockets.hasNext()) {
                BlockConnector parentSocket = parentSockets.next();
                if (parentSocket.getBlockID() != Block.NULL) {
                    if (i > this.getNumSockets() - 1) {
                        if (parentSocket.getBlockID() != Block.NULL) {
                            this.addSocket(parentSocket.getKind(), BlockConnector.PositionType.SINGLE, Block.getBlock(parentSocket.getBlockID()).getBlockLabel(), false, false, Block.NULL);
                        }
                    } else {
                        BlockConnector con = this.getSocketAt(i);
                        this.setSocketAt(i, parentSocket.getKind(), con.getPositionType(), Block.getBlock(parentSocket.getBlockID()).getBlockLabel(), con.isLabelEditable(), con.isExpandable(), con.getBlockID());
                    }
                }
                ++i;
            }
        }
    }

    private void restoreInitConnectors() {
        if (!this.hasPlug()) {
            return;
        }
        Long id = this.getPlugBlockID();
        if (id != null && !id.equals(Block.NULL)) {
            this.disconnectBlock(id);
        }
        this.removePlug();
        this.resetBeforeAndAfter();
        RenderableBlock.getRenderableBlock(this.getBlockID()).updateConnectors();
        this.notifyRenderable();
    }

    private void updatePlug(String kind) {
        if (this.hasPlug() && this.getPlugKind().equals(kind)) {
            return;
        }
        Long id = this.getBeforeBlockID();
        if (id != null && !id.equals(Block.NULL)) {
            this.disconnectBlock(id);
        }
        if ((id = this.getAfterBlockID()) != null && !id.equals(Block.NULL)) {
            this.disconnectBlock(id);
        }
        if ((id = this.getPlugBlockID()) != null && !id.equals(Block.NULL)) {
            this.disconnectBlock(id);
        }
        this.removeBeforeAndAfter();
        this.setPlug(kind, BlockConnector.PositionType.SINGLE, kind, false, Block.NULL);
        RenderableBlock.getRenderableBlock(this.getBlockID()).updateConnectors();
        this.notifyRenderable();
    }

    private void disconnectBlock(Long id) {
        Block b2 = Block.getBlock(id);
        BlockConnector conn2 = b2.getConnectorTo(this.getBlockID());
        BlockConnector conn = this.getConnectorTo(id);
        BlockLink link = BlockLink.getBlockLink(this, b2, conn, conn2);
        RenderableBlock rb = RenderableBlock.getRenderableBlock(link.getSocketBlockID());
        link.disconnect();
        rb.blockDisconnected(link.getSocket());
        Workspace.getInstance().notifyListeners(new WorkspaceEvent(rb.getParentWidget(), link, 6));
    }

    @Override
    public Color getColor() {
        if (this.getParent() == null) {
            return super.getColor();
        }
        return this.getParent().getColor();
    }

    @Override
    public String toString() {
        return "Block Stub +" + this.getBlockID() + ": " + this.getBlockLabel() + " with sockets: " + this.getSockets() + " and plug: " + this.getPlug();
    }

    @Override
    public boolean isCommandBlock() {
        return this.hasAfterConnector() && this.hasBeforeConnector();
    }

    @Override
    public boolean isDataBlock() {
        return !this.hasAfterConnector() && !this.hasBeforeConnector();
    }

    @Override
    public boolean isFunctionBlock() {
        return this.hasPlug() && this.getNumSockets() > 0;
    }

    @Override
    public Node getSaveNode(Document document, int x, int y, Node commentNode, boolean collapsed) {
        Element stubElement = document.createElement("BlockStub");
        Element parentNameElement = document.createElement("StubParentName");
        parentNameElement.appendChild(document.createTextNode(this.parentName));
        stubElement.appendChild(parentNameElement);
        Element parentGenusElement = document.createElement("StubParentGenus");
        parentGenusElement.appendChild(document.createTextNode(this.parentGenus));
        stubElement.appendChild(parentGenusElement);
        Node blockNode = super.getSaveNode(document, x, y, commentNode, collapsed);
        stubElement.appendChild(blockNode);
        return stubElement;
    }
}

