/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.LinkRule;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;

public class CommandRule
implements LinkRule,
WorkspaceListener {
    public boolean canLink(Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        if (!BlockConnectorShape.isCommandConnector(socket1) || !BlockConnectorShape.isCommandConnector(socket2)) {
            return false;
        }
        if (socket1 == block1.getBeforeConnector()) {
            return !socket1.hasBlock();
        }
        if (socket2 == block2.getBeforeConnector()) {
            return !socket2.hasBlock();
        }
        return false;
    }

    public boolean isMandatory() {
        return false;
    }

    public void workspaceEventOccurred(WorkspaceEvent e) {
        BlockLink link;
        if (e.getEventType() == 5 && (link = e.getSourceLink()).getLastBlockID() != null && link.getLastBlockID() != Block.NULL && BlockConnectorShape.isCommandConnector(link.getPlug()) && BlockConnectorShape.isCommandConnector(link.getSocket())) {
            Block top = Block.getBlock(link.getPlugBlockID());
            while (top.hasAfterConnector() && top.getAfterConnector().hasBlock()) {
                top = Block.getBlock(top.getAfterBlockID());
            }
            Block bottom = Block.getBlock(link.getLastBlockID());
            if (!top.hasAfterConnector() || !bottom.hasBeforeConnector()) {
                return;
            }
            link = BlockLink.getBlockLink(top, bottom, top.getAfterConnector(), bottom.getBeforeConnector());
            link.connect();
        }
    }
}

