/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;

public abstract class CArrowButton
extends CButton
implements ActionListener {
    private static final long serialVersionUID = 328149080231L;
    private static final int m = 3;
    private final Direction dir;
    private static final Color highlight = CGraphite.blue;
    private static final Color arrowColor = CGraphite.blue;

    public CArrowButton(Direction dir) {
        super(Color.black, CGraphite.blue, null);
        this.setOpaque(false);
        this.dir = dir;
        this.addActionListener(this);
    }

    private Shape getShape(Direction dir) {
        if (dir == Direction.NORTH) {
            return new GeneralPath();
        }
        if (dir == Direction.SOUTH) {
            return new GeneralPath();
        }
        if (dir == Direction.EAST) {
            GeneralPath arrow = new GeneralPath();
            arrow.moveTo(3.0f, 3.0f);
            arrow.lineTo(this.getWidth() - 3, this.getHeight() / 2);
            arrow.lineTo(3.0f, this.getHeight() - 3);
            arrow.lineTo(3.0f, 3.0f);
            arrow.closePath();
            return arrow;
        }
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo(this.getWidth() - 3, 3.0f);
        arrow.lineTo(3.0f, this.getHeight() / 2);
        arrow.lineTo(this.getWidth() - 3, this.getHeight() - 3);
        arrow.lineTo(this.getWidth() - 3, 3.0f);
        arrow.closePath();
        return arrow;
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape arrow = this.getShape(this.dir);
        if (this.focus) {
            g2.setColor(Color.gray);
            g2.drawRoundRect(0, 0, w - 1, h - 1, 6, 6);
        }
        if (this.pressed) {
            g2.setColor(highlight);
            g2.fill(arrow);
            g2.setColor(Color.yellow);
            g2.draw(arrow);
        } else {
            g2.setColor(arrowColor);
            g2.fill(arrow);
            g2.setColor(Color.white);
            g2.draw(arrow);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.triggerAction();
    }

    public abstract void triggerAction();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

