/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.ChartData;
import java.awt.Color;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class CBarGraph
extends JLabel {
    private static final long serialVersionUID = 328149080230L;
    private static final Color DEFAULT_BACKGROUND = CGraphite.blue;
    private JFreeChart chart;
    private BarData chartData;
    private Color background;
    private boolean lock = false;
    private ChartPanel output = null;
    private double upperBound = -1.0E9;
    private double lowerBound = 0.0;

    public CBarGraph(String title, int seriesNum, Color background) {
        super("", 0);
        this.chartData = new BarData(title);
        this.chart = this.chartData.makeChart();
        this.background = background == null ? DEFAULT_BACKGROUND : background;
        this.chart.setBackgroundPaint(this.background);
        this.chart.setBorderPaint(null);
        ImageIcon icon = new ImageIcon(this.chart.createBufferedImage(150, 100));
        this.setLayout(null);
        this.setIcon(icon);
        this.setBounds(0, 0, 170, 130);
    }

    public Insets getInsets() {
        return new Insets(15, 10, 15, 10);
    }

    public void clearChart() {
        if (!this.lock) {
            this.chart = this.chartData.makeChart();
            this.chart.setBackgroundPaint(this.background);
            this.chart.setBorderPaint(null);
            if (this.output != null) {
                JFreeChart newChart = new JFreeChart(this.chart.getPlot());
                newChart.getLegend().setPosition(RectangleEdge.TOP);
                newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
                newChart.setBackgroundPaint(this.background);
                this.output.setChart(newChart);
                this.output.invalidate();
                this.output.repaint();
            }
        }
    }

    public void updateDomain(String title, int seriesNum, Color background) {
        if (!this.lock) {
            this.chart = this.chartData.makeChart();
            this.background = background == null ? DEFAULT_BACKGROUND : background;
            this.chart.setBackgroundPaint(this.background);
            this.chart.setBorderPaint(null);
            if (this.output != null) {
                JFreeChart newChart = new JFreeChart(this.chart.getPlot());
                newChart.getLegend().setPosition(RectangleEdge.TOP);
                newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
                newChart.setBackgroundPaint(background);
                this.output.setChart(newChart);
                this.output.invalidate();
                this.output.repaint();
            }
        }
    }

    public void updateValues(String seriesName, double value) {
        if (!this.lock) {
            DefaultCategoryDataset dataset = (DefaultCategoryDataset)this.chart.getCategoryPlot().getDataset();
            dataset.addValue(value, (Comparable)((Object)seriesName), (Comparable)Integer.valueOf(0));
            if (value < this.lowerBound) {
                this.lowerBound = value;
            }
            if (value > this.upperBound) {
                this.upperBound = value;
            }
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.getRangeAxis().setLowerBound(this.lowerBound);
            plot.getRangeAxis().setUpperBound(this.upperBound);
        }
    }

    public void updateSeriesNamesAt(String seriesName, int index) {
    }

    public void updateImage() {
        if (!this.lock) {
            ImageIcon icon = new ImageIcon(this.chart.createBufferedImage(150, 100, 150.0, 100.0, null));
            this.setIcon(icon);
        }
    }

    public ChartPanel getOutputPanel() {
        JFreeChart newChart = new JFreeChart(this.chart.getPlot());
        newChart.getLegend().setPosition(RectangleEdge.TOP);
        newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
        newChart.setBackgroundPaint(this.background);
        this.output = new ChartPanel(newChart);
        return this.output;
    }

    public BufferedImage getBufferedImage(int width, int height) {
        return this.chart.createBufferedImage(width, height);
    }

    public String getCSV() {
        StringBuilder output = new StringBuilder();
        DefaultCategoryDataset d = (DefaultCategoryDataset)this.chart.getCategoryPlot().getDataset();
        for (int i = 0; i < d.getRowCount(); ++i) {
            output.append(d.getRowKey(i) + "," + d.getValue(d.getRowKey(i), Integer.valueOf(0)) + "\n");
        }
        return output.toString();
    }

    private class BarData
    extends ChartData {
        public BarData(String title) {
            super(title);
        }

        public JFreeChart makeChart() {
            JFreeChart chart = ChartFactory.createBarChart3D("", "", "", new DefaultCategoryDataset(), PlotOrientation.VERTICAL, false, false, false);
            ValueAxis rangeAxis = chart.getCategoryPlot().getRangeAxis();
            if (rangeAxis instanceof NumberAxis) {
                ((NumberAxis)rangeAxis).setNumberFormatOverride(new DecimalFormat("######.###"));
            }
            return chart;
        }
    }
}

