/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.GraphicsManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class CButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 328149080228L;
    static float[] BLUR = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.3f, 0.1f, 0.1f, 0.1f, 0.1f};
    static final int INSET = 3;
    static final int HIGHLIGHT_INSET = 2;
    boolean focus = false;
    boolean pressed = false;
    boolean selected = false;
    Color buttonColor;
    Color selectedColor;
    Color foregroundColor = Color.white;
    Color hoveredColor = Color.red;

    public CButton(String text) {
        this(new Color(30, 30, 30), Color.gray, text);
    }

    public CButton(Color buttonColor, Color selectedColor, String text) {
        this.setOpaque(false);
        this.buttonColor = buttonColor;
        this.selectedColor = selectedColor;
        this.setText(text);
        this.setFont(new Font("Ariel", 1, 16));
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(80, 25));
        this.setCursor(new Cursor(12));
    }

    public void setLighting(Color buttonColor, Color selectedColor) {
        this.buttonColor = buttonColor;
        this.selectedColor = selectedColor;
    }

    public void setTextLighting(Color foregroundColor, Color hoveredColor) {
        this.foregroundColor = foregroundColor;
        this.hoveredColor = hoveredColor;
    }

    public void toggleSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(0, this.getHeight() / 2, 0, this.getHeight() / 2);
    }

    public void paint(Graphics g) {
        Color backgroundColor = this.pressed || this.selected ? this.selectedColor : this.buttonColor;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BufferedImage buffer = GraphicsManager.gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D gb = buffer.createGraphics();
        gb.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int buttonHeight = this.getHeight() - 6;
        int buttonWidth = this.getWidth() - 6;
        int arc = buttonHeight;
        Color topColoring = backgroundColor.darker();
        Color bottomColoring = backgroundColor.darker();
        gb.setPaint(new GradientPaint(0.0f, 3.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        gb.fillRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
        gb.setColor(Color.darkGray);
        gb.drawRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
        int highlightHeight = buttonHeight - 4;
        int highlightWidth = buttonWidth - 4;
        int highlightArc = highlightHeight;
        topColoring = backgroundColor.brighter().brighter().brighter().brighter();
        bottomColoring = backgroundColor.brighter().brighter().brighter().brighter();
        gb.setComposite(AlphaComposite.getInstance(3, 0.8f));
        gb.setPaint(new GradientPaint(0.0f, 5.0f, topColoring, 0.0f, 5 + highlightHeight / 2, backgroundColor.brighter(), false));
        gb.setClip(new RoundRectangle2D.Float(5.0f, 5.0f, highlightWidth, highlightHeight / 2, highlightHeight / 3, highlightHeight / 3));
        gb.fillRoundRect(5, 5, highlightWidth, highlightHeight, highlightArc, highlightArc);
        ConvolveOp blurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurredImage = blurOp.filter(buffer, null);
        g2.drawImage((Image)blurredImage, 0, 0, null);
        if (this.getText() != null) {
            if (this.focus) {
                g2.setColor(this.hoveredColor);
            } else {
                g2.setColor(this.foregroundColor);
            }
            Font font = g2.getFont().deriveFont((float)((double)buttonHeight * 0.6));
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
            float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
            g2.drawString(this.getText(), x, y);
        }
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
    }

    public void mouseEntered(MouseEvent e) {
        this.focus = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.focus = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.pressed = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }
}

