/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.ChartData;
import edu.mit.blocks.codeblockutil.GraphicsManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;

public class CLineGraph
extends JLabel {
    private static final long serialVersionUID = 328149080211L;
    private static final Color DEFAULT_BACKGROUND = CGraphite.blue;
    private JFreeChart chart;
    private LineData chartData;
    private Color background;
    private BufferedImage img = null;
    private boolean lock = false;
    private ChartPanel output = null;

    public CLineGraph(String title, int seriesNum, Color background) {
        super("", 0);
        this.chartData = new LineData(title, true, 0.0, 30.0, 0.0, 100.0, seriesNum);
        this.chart = this.chartData.makeChart();
        this.background = background == null ? DEFAULT_BACKGROUND : background;
        this.chart.setBackgroundPaint(this.background);
        this.chart.setBorderPaint(null);
        ImageIcon icon = new ImageIcon(this.chart.createBufferedImage(150, 100));
        this.setLayout(null);
        this.setIcon(icon);
        this.setBounds(0, 0, 170, 130);
    }

    public Insets getInsets() {
        return new Insets(15, 10, 15, 10);
    }

    public void clearChart() {
        if (!this.lock) {
            this.chart = this.chartData.makeChart();
            this.chart.setBackgroundPaint(this.background);
            this.chart.setBorderPaint(null);
            if (this.output != null) {
                JFreeChart newChart = new JFreeChart(this.chart.getPlot());
                newChart.getLegend().setPosition(RectangleEdge.TOP);
                newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
                newChart.setBackgroundPaint(this.background);
                this.output.setChart(newChart);
                this.output.invalidate();
                this.output.repaint();
            }
        }
    }

    public void updateDomain(String title, int seriesNum, Color background) {
        if (!this.lock) {
            this.chartData.setSeriesNum(seriesNum);
            this.chart = this.chartData.makeChart();
            this.background = background == null ? DEFAULT_BACKGROUND : background;
            this.chart.setBackgroundPaint(this.background);
            this.chart.setBorderPaint(null);
            if (this.output != null) {
                JFreeChart newChart = new JFreeChart(this.chart.getPlot());
                newChart.getLegend().setPosition(RectangleEdge.TOP);
                newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
                newChart.setBackgroundPaint(background);
                this.output.setChart(newChart);
                this.output.invalidate();
                this.output.repaint();
            }
        }
    }

    public void clearValues() {
        if (!this.lock) {
            for (int i = 0; i < this.chart.getXYPlot().getSeriesCount(); ++i) {
                XYSeries s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(i);
                while (s.getItemCount() > 0) {
                    s.remove(0);
                }
            }
        }
    }

    public void clearValues(int index, double startTime) {
        XYSeries s;
        int i;
        if (!this.lock && (i = (s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(index)).indexOf(startTime)) >= 0) {
            for (int total = s.getItemCount(); i < total; --total) {
                s.remove(i);
            }
        }
    }

    public void updateValues(String seriesName, int index, double time, double value) {
        if (!this.lock) {
            XYSeries s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(index);
            s.setKey((Comparable)((Object)seriesName));
            s.addOrUpdate(time, value);
        }
    }

    public void updateSeriesNameAt(String seriesName, int index) {
        if (!this.lock) {
            XYSeries s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(index);
            s.setKey((Comparable)((Object)seriesName));
        }
    }

    public void updateImage() {
        if (!this.lock) {
            GraphicsManager.recycleGCCompatibleImage(this.img);
            this.img = GraphicsManager.getGCCompatibleImage(150, 100);
            this.chart.draw(this.img.createGraphics(), new Rectangle2D.Double(0.0, 0.0, 150.0, 100.0), null);
            ImageIcon icon = new ImageIcon(this.img);
            this.setIcon(icon);
        }
    }

    public ChartPanel getOutputPanel() {
        JFreeChart newChart = new JFreeChart(this.chart.getPlot());
        newChart.getLegend().setPosition(RectangleEdge.TOP);
        newChart.getLegend().setPadding(5.0, 5.0, 5.0, 5.0);
        newChart.setBackgroundPaint(this.background);
        this.output = new ChartPanel(newChart);
        return this.output;
    }

    public BufferedImage getBufferedImage(int width, int height) {
        return this.chart.createBufferedImage(width, height);
    }

    public String getCSV() {
        this.lock = true;
        int max = 0;
        ArrayList columns = new ArrayList();
        for (int i = 0; i < this.chartData.getSeriesNum(); ++i) {
            XYDataItem item;
            XYSeries s;
            if (i == 0) {
                ArrayList<String> time = new ArrayList<String>();
                s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(i);
                max = Math.max(max, s.getItemCount());
                time.add("TIME,");
                for (Object o : s.getItems()) {
                    item = (XYDataItem)o;
                    time.add(item.getX() + ",");
                }
                columns.add(time);
            }
            ArrayList<String> values = new ArrayList<String>();
            s = ((XYSeriesCollection)this.chart.getXYPlot().getDataset()).getSeries(i);
            max = Math.max(max, s.getItemCount());
            values.add(s.getKey().toString() + ",");
            for (Object o : s.getItems()) {
                item = (XYDataItem)o;
                values.add(item.getY() + ",");
            }
            columns.add(values);
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                if (i < ((List)columns.get(j)).size()) {
                    output.append((String)((List)columns.get(j)).get(i));
                    continue;
                }
                output.append(",");
            }
            output.append("\n");
        }
        this.lock = false;
        return output.toString();
    }

    private class LineData
    extends ChartData {
        private boolean autoRange;
        private double xMin;
        private double xMax;
        private double yMin;
        private double yMax;
        private int seriesNum;

        public LineData(String title, boolean autoRange, double xMin, double xMax, double yMin, double yMax, int seriesNum) {
            super(title);
            this.autoRange = autoRange;
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMin = yMin;
            this.yMax = yMax;
            this.seriesNum = seriesNum;
        }

        public JFreeChart makeChart() {
            XYSeriesCollection lineDataset = new XYSeriesCollection();
            for (int i = 0; i < this.getSeriesNum(); ++i) {
                lineDataset.addSeries(new XYSeries(new Integer(i)));
            }
            JFreeChart chart = ChartFactory.createXYLineChart("", "", "", lineDataset, PlotOrientation.VERTICAL, false, false, false);
            XYItemRenderer r = chart.getXYPlot().getRenderer();
            for (int i = 0; i < this.getSeriesNum(); ++i) {
                int colorValue = Color.HSBtoRGB((float)i / (float)this.getSeriesNum(), 1.0f, 0.5f);
                Color color = new Color(colorValue);
                r.setSeriesPaint(i, color);
                r.setSeriesStroke(i, new BasicStroke(2.0f, 1, 0));
            }
            NumberAxis rangeAxis = (NumberAxis)chart.getXYPlot().getRangeAxis();
            rangeAxis.setNumberFormatOverride(new DecimalFormat("######.###"));
            NumberAxis domainAxis = (NumberAxis)chart.getXYPlot().getDomainAxis();
            if (this.autoRange) {
                rangeAxis.setAutoRange(true);
                domainAxis.setAutoRange(true);
            } else {
                domainAxis.setRange(this.xMin, this.xMax);
                rangeAxis.setRange(this.yMin, this.yMax);
            }
            return chart;
        }

        public int getSeriesNum() {
            return this.seriesNum;
        }

        public void setSeriesNum(int seriesNum) {
            this.seriesNum = seriesNum;
        }
    }
}

