/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;

class GlassHorizontalBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 328149080225L;
    private final BoundedRangeModel modelrange;
    private final Color thumbColor;
    private final Color trackColor;
    private final RenderingHints renderingHints;
    private int pressLocation;

    public GlassHorizontalBar(int barwidth, Color thumbColor, Color trackColor, BoundedRangeModel modelrange) {
        this.modelrange = modelrange;
        this.thumbColor = thumbColor;
        this.trackColor = trackColor;
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pressLocation = 0;
        this.setOpaque(false);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        super.paint(g);
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        int vHeight = this.getHeight() / 2;
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(this.renderingHints);
        g2.translate(0, vHeight / 2);
        g2.setColor(this.trackColor);
        g2.fillRoundRect(0, 0, this.getWidth(), vHeight, vHeight, vHeight);
        g2.setColor(new Color(150, 150, 150));
        g2.drawRoundRect(0, 0, this.getWidth() - 1, vHeight, vHeight, vHeight);
        if (viewValue < (double)((float)this.getWidth() - 0.5f * (float)this.getHeight())) {
            g2.translate(viewValue, 0.0);
        } else {
            g2.translate((float)this.getWidth() - 0.5f * (float)this.getHeight(), 0.0);
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.thumbColor, 0.0f, this.getHeight() + 10, Color.black, true));
        g2.fillRoundRect(0, 0, (int)viewExtent, vHeight, vHeight, vHeight);
        g2.setColor(new Color(250, 250, 250, 100));
        g2.drawRoundRect(0, 0, (int)viewExtent, vHeight, vHeight, vHeight);
    }

    private double viewToModel(int view) {
        return view * this.modelrange.getMaximum() / this.getWidth();
    }

    private double modelToView(int model) {
        return (double)(model * this.getWidth()) / (double)this.modelrange.getMaximum();
    }

    public void mousePressed(MouseEvent e) {
        double viewValue = this.modelToView(this.modelrange.getValue());
        double viewExtent = this.modelToView(this.modelrange.getExtent());
        if ((double)e.getX() < viewValue || (double)e.getX() > viewExtent + viewValue) {
            this.pressLocation = (int)(viewExtent / 2.0);
            this.modelrange.setValue((int)this.viewToModel(e.getX()) - this.modelrange.getExtent() / 2);
            this.repaint();
        } else {
            this.pressLocation = e.getX() - (int)viewValue;
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.modelrange.setValue((int)this.viewToModel(e.getX() - this.pressLocation));
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.pressLocation = 0;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

