/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    private final int capacity;
    private final LinkedHashMap<K, V> map;

    public LRUCache(int _capacity) {
        this.capacity = _capacity;
        this.map = new LinkedHashMap<K, V>(this.capacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUCache.this.capacity;
            }
        };
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }
}

