/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupExplorer
extends JLayeredPane
implements Explorer,
ComponentListener {
    private static final long serialVersionUID = 328149080299L;
    protected JPanel buttonPane;
    private JPanel viewport;
    private JComponent scroll;
    private List<Canvas> components = new ArrayList<Canvas>();

    public PopupExplorer() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.viewport = new JPanel(new BorderLayout());
        this.scroll = new CHoverScrollPane(this.viewport, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER, 20, Color.blue, new Color(0, 0, 50));
        this.add((Component)this.scroll, JLayeredPane.DEFAULT_LAYER);
        this.setLayer(this.scroll, JLayeredPane.DEFAULT_LAYER, 0);
        this.buttonPane = new ButtonPanel();
        this.add((Component)this.buttonPane, JLayeredPane.PALETTE_LAYER);
        this.setLayer(this.buttonPane, JLayeredPane.PALETTE_LAYER, 0);
        this.addComponentListener(this);
    }

    @Override
    public boolean anyCanvasSelected() {
        return false;
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.getJComponent().getWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
    }

    @Override
    public void removeListener(ExplorerListener gel) {
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.components.clear();
        this.components.addAll(items);
        this.reformView();
        if (!items.isEmpty()) {
            this.setViewPort(items.get(0));
        }
    }

    @Override
    public void reformView() {
        this.scroll.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.scroll.revalidate();
        this.scroll.repaint();
        this.buttonPane.setSize(60, this.getSize().height);
    }

    void setViewPort(Canvas view) {
        this.viewport.removeAll();
        this.viewport.add((Component)view.getJComponent(), "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void selectCanvas(int index) {
        if (index >= 0 && index < this.components.size()) {
            Canvas view = this.components.get(index);
            this.viewport.removeAll();
            this.viewport.add((Component)view.getJComponent(), "Center");
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.reformView();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private class EnlargerTimer
    implements ActionListener {
        private int count = 0;
        private Timer timer = new Timer(15, this);
        private boolean expand = true;

        public void actionPerformed(ActionEvent e) {
            if (this.expand) {
                if (this.count > 10) {
                    this.timer.stop();
                } else {
                    ++this.count;
                    PopupExplorer.this.buttonPane.setBounds(0, 0, 60 + this.count * 10, PopupExplorer.this.buttonPane.getHeight());
                    PopupExplorer.this.repaint();
                }
            } else if (this.count <= 0) {
                this.timer.stop();
            } else {
                --this.count;
                PopupExplorer.this.buttonPane.setBounds(0, 0, 60 + this.count * 10, PopupExplorer.this.buttonPane.getHeight());
                PopupExplorer.this.repaint();
            }
            if (this.count < -100 || this.count > 100) {
                throw new RuntimeException("Timer continues infinityly");
            }
        }

        public void expand() {
            this.expand = true;
            this.timer.start();
        }

        public void shrink() {
            this.expand = false;
            this.timer.start();
        }
    }

    private class ButtonPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 328149080300L;
        private EnlargerTimer timer;

        protected ButtonPanel() {
            super(null);
            this.setOpaque(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.timer = new EnlargerTimer();
            this.setFont(new Font("Ariel", 1, 13));
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!PopupExplorer.this.components.isEmpty()) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int yloc = 0;
                int dh = 0;
                dh = this.getHeight() / PopupExplorer.this.components.size();
                int i = 0;
                for (Canvas p : PopupExplorer.this.components) {
                    g.setColor(new Color(i * 27 % 255, i * 47 % 255, i * 57 % 255, 150));
                    g.fillRoundRect(-10, yloc, this.getWidth() + 9, dh, 20, 20);
                    g.setColor(Color.white);
                    g.drawRoundRect(-10, yloc, this.getWidth() + 9, dh, 20, 20);
                    if (p.getName() == null) {
                        g.drawString(p.toString(), 0, yloc + dh / 2 + g.getFontMetrics().getHeight() / 2);
                    } else {
                        g.drawString(p.getName(), 0, yloc + dh / 2 + g.getFontMetrics().getHeight() / 2);
                    }
                    yloc += dh;
                    ++i;
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int index = PopupExplorer.this.components.size() * e.getY() / this.getHeight();
            if (index >= 0 && index < PopupExplorer.this.components.size()) {
                PopupExplorer.this.setViewPort((Canvas)PopupExplorer.this.components.get(index));
            }
        }

        public void mouseEntered(MouseEvent e) {
            this.timer.expand();
        }

        public void mouseExited(MouseEvent e) {
            this.timer.shrink();
        }
    }
}

