/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CTabButton;
import edu.mit.blocks.codeblockutil.CWheeler;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import edu.mit.blocks.codeblockutil.TabCard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedExplorer
extends JPanel
implements Explorer,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 328149080307L;
    private static final int BUTTON_HEIGHT = 28;
    private static final Dimension BUTTON_DIMENSION = new Dimension(28, 28);
    private final List<TabCard> drawerCards;
    private final JComponent canvasPane;
    private final CWheeler wheeler;
    private final JPopupMenu menu;
    private final CButton left;
    private final CButton right;
    private final CButton down;
    private final Timer timer;
    private boolean directedToLeft = true;
    private final boolean scrollable;
    private int selectedIndex = 0;

    public TabbedExplorer() {
        this(true);
    }

    public TabbedExplorer(boolean scrollable) {
        this.scrollable = scrollable;
        this.drawerCards = new ArrayList<TabCard>();
        this.canvasPane = new JPanel(new BorderLayout());
        this.canvasPane.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, CGraphite.blue));
        this.setBackground(Color.black);
        this.timer = new Timer(300, this);
        this.menu = new JPopupMenu();
        this.wheeler = new CWheeler(new ArrayList<JComponent>(), false, Color.black);
        this.wheeler.setPreferredSize(new Dimension(this.wheeler.getPreferredSize().width, 28));
        this.left = new CTabButton("<<");
        this.left.setPreferredSize(BUTTON_DIMENSION);
        this.left.addMouseListener(this);
        this.right = new CTabButton(">>");
        this.right.setPreferredSize(BUTTON_DIMENSION);
        this.right.addMouseListener(this);
        this.down = new CTabButton("V");
        this.down.setPreferredSize(BUTTON_DIMENSION);
        this.down.addMouseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)this.left, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.wheeler, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.right, gbc);
        ++gbc.gridx;
        this.add((Component)this.down, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.canvasPane, gbc);
    }

    @Override
    public boolean anyCanvasSelected() {
        return false;
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.canvasPane.getWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
    }

    @Override
    public void removeListener(ExplorerListener gel) {
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.drawerCards.clear();
        this.menu.removeAll();
        ArrayList<CButton> buttons = new ArrayList<CButton>();
        for (int i = 0; i < items.size(); ++i) {
            TabCard card = new TabCard(i, items.get(i), this, this.scrollable);
            this.drawerCards.add(card);
            buttons.add(card.getButton());
            card.getButton().setPreferredSize(new Dimension(125, 28));
            this.menu.add(card.getMenuItem());
        }
        this.wheeler.setElements(buttons);
        this.selectCanvas(0);
    }

    @Override
    public void selectCanvas(int index) {
        if (index >= 0 && index < this.drawerCards.size()) {
            TabCard card = this.drawerCards.get(index);
            this.canvasPane.removeAll();
            this.canvasPane.add(card.getScroll());
            this.canvasPane.revalidate();
            this.canvasPane.repaint();
            for (TabCard otherCard : this.drawerCards) {
                otherCard.getButton().toggleSelected(false);
            }
            card.getButton().toggleSelected(true);
            this.selectedIndex = index;
            this.revalidate();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    void scrollToWheelItem(int index) {
        if (index >= 0 && index < this.drawerCards.size()) {
            this.wheeler.scrollToWheelItem(this.drawerCards.get(index).getButton());
        }
    }

    @Override
    public void reformView() {
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.timer.stop();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource().equals(this.left)) {
            this.directedToLeft = true;
            this.wheeler.scrollLeft();
            this.timer.start();
        } else if (e.getSource().equals(this.right)) {
            this.directedToLeft = false;
            this.wheeler.scrollRight();
            this.timer.start();
        } else if (e.getSource().equals(this.down)) {
            this.menu.show(this.down, 5, 5);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.directedToLeft) {
            this.wheeler.scrollLeft();
        } else {
            this.wheeler.scrollRight();
        }
    }
}

