/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.renderable.RenderableBlock;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

class BlockControlLabel
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private boolean active = false;
    private long blockID;

    BlockControlLabel(long blockID) {
        this.blockID = blockID;
        this.setFont(new Font("Courier", 1, 14));
        this.setForeground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void update() {
        RenderableBlock rb = RenderableBlock.getRenderableBlock(this.blockID);
        if (rb != null) {
            int x = 0;
            int y = 0;
            y = (int)((double)y + ((double)rb.getBlockHeight() / rb.getZoom() - 22.0 + (double)(this.isActive() ? 4.0f : 0.0f)));
            y -= 20;
            x += 12;
            x = rb.rescale(x);
            y = rb.rescale(y);
            this.setLocation(x, y);
            this.setSize(rb.rescale(14), rb.rescale(14));
            if (this.isActive()) {
                this.setText("?");
            } else {
                this.setText("-");
            }
        }
    }

    public void paint(Graphics g) {
        this.update();
        super.paint(g);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    void toggle() {
        this.setActive(!this.isActive());
    }

    void setBlockID(long blockID) {
        this.blockID = blockID;
    }

    long getBlockID() {
        return this.blockID;
    }

    public void setZoomLevel(double newZoom) {
        AffineTransform at = new AffineTransform();
        at.setToScale(newZoom, newZoom);
        Font renderingFont = this.getFont().deriveFont(at);
        this.setFont(renderingFont);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setBorder(BorderFactory.createLineBorder(Color.white));
    }

    public void mouseExited(MouseEvent e) {
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

