/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblockutil.GraphicsManager;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.RBParent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RBHighlightHandler
extends JComponent
implements ComponentListener,
HierarchyListener {
    private static final long serialVersionUID = 328149080427L;
    public static final int HIGHLIGHT_STROKE_WIDTH = 12;
    private static final float HIGHLIGHT_ALPHA = 0.75f;
    private Color hColor = null;
    private boolean isSearchResult = false;
    private boolean hasFocus = false;
    private Area blockArea = null;
    private RenderableBlock rb;
    private BufferedImage hImage;

    public RBHighlightHandler(RenderableBlock rb) {
        this.rb = rb;
        this.setSize(6, 1);
        this.setOpaque(false);
        this.hColor = null;
        this.blockArea = rb.getBlockArea();
        this.updateImage();
        rb.addHierarchyListener(this);
        rb.addComponentListener(this);
    }

    public void setHighlightColor(Color c) {
        this.hColor = c;
        this.updateImage();
        this.repaint();
    }

    public void setIsSearchResult(boolean isResult) {
        this.isSearchResult = isResult;
        this.updateImage();
        this.repaint();
    }

    public void resetHighlight() {
        this.hColor = null;
        this.updateImage();
        this.repaint();
    }

    public void repaint() {
        if (this.rb.isVisible()) {
            if (this.blockArea == null || this.blockArea != this.rb.getBlockArea() || this.rb.getBlock() != null && this.rb.getBlock().hasFocus() != this.hasFocus) {
                this.updateImage();
                this.blockArea = this.rb.getBlockArea();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RBHighlightHandler.this.updateBounds();
                }
            });
        }
        super.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
        if (this.hImage != null) {
            g2.drawImage((Image)this.hImage, 0, 0, null);
        }
    }

    public void setParent(RBParent newParent) {
        this.removeFromParent();
        newParent.addToHighlightLayer(this);
        this.updateImage();
        ((Container)((Object)newParent)).validate();
    }

    public void removeFromParent() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public void updateImage() {
        this.hasFocus = this.rb.getBlock().hasFocus();
        Color color = null;
        if (this.hColor != null) {
            color = this.hColor;
        } else if (this.rb.getBlock().hasFocus()) {
            color = new Color(200, 200, 255);
        } else if (this.isSearchResult) {
            color = new Color(255, 255, 120);
        } else if (this.rb.getBlock().isBad()) {
            color = new Color(255, 100, 100);
        } else {
            GraphicsManager.recycleGCCompatibleImage(this.hImage);
            this.hImage = null;
            return;
        }
        if (!this.rb.isVisible()) {
            GraphicsManager.recycleGCCompatibleImage(this.hImage);
            this.hImage = null;
            return;
        }
        this.hImage = GraphicsManager.getGCCompatibleImage(this.rb.getBlockWidth() + 12, this.rb.getBlockHeight() + 12);
        Graphics2D hg = (Graphics2D)this.hImage.getGraphics();
        hg.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        hg.setColor(color);
        hg.translate(6, 6);
        hg.setComposite(AlphaComposite.getInstance(3, 0.2f));
        for (int i = 0; i < 12; ++i) {
            hg.setStroke(new BasicStroke(i));
            hg.draw(this.rb.getBlockArea());
        }
        hg.setColor(new Color(0, 0, 0, 0));
        hg.setComposite(AlphaComposite.getInstance(2, 1.0f));
        hg.fill(this.rb.getBlockArea());
    }

    private void updateBounds() {
        Point rbLoc = SwingUtilities.convertPoint(this.rb.getParent(), this.rb.getLocation(), this.getParent());
        this.setBounds(rbLoc.x - 6, rbLoc.y - 6, this.rb.getBlockWidth() + 12, this.rb.getBlockHeight() + 12);
    }

    public void componentResized(ComponentEvent arg0) {
        this.repaint();
    }

    public void componentMoved(ComponentEvent arg0) {
        this.repaint();
    }

    public void componentShown(ComponentEvent arg0) {
        this.repaint();
    }

    public void componentHidden(ComponentEvent arg0) {
        GraphicsManager.recycleGCCompatibleImage(this.hImage);
        this.hImage = null;
    }

    public void hierarchyChanged(HierarchyEvent he) {
        if (this.rb.getParent() == null) {
            this.removeFromParent();
            GraphicsManager.recycleGCCompatibleImage(this.hImage);
            this.hImage = null;
        }
    }
}

