/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.renderable.BlockLabel;
import java.awt.Color;
import java.awt.geom.Point2D;

class SocketLabel
extends BlockLabel {
    private BlockConnector socket;

    SocketLabel(BlockConnector socket, String initLabelText, BlockLabel.Type labelType, boolean isEditable, long blockID) {
        super(initLabelText, labelType, isEditable, blockID, false, new Color(190, 250, 125));
        this.socket = socket;
    }

    static boolean ignoreSocket(BlockConnector socket) {
        return socket.getPositionType() == BlockConnector.PositionType.BOTTOM || socket.getLabel().equals("");
    }

    void update(Point2D socketPoint) {
        double y;
        double x;
        if (SocketLabel.ignoreSocket(this.socket)) {
            return;
        }
        if (BlockConnectorShape.isCommandConnector(this.socket)) {
            x = -25.0 + socketPoint.getX();
            y = -4.0 + socketPoint.getY();
        } else {
            x = (double)(-4 - BlockConnectorShape.getConnectorDimensions((BlockConnector)this.socket).width) + socketPoint.getX();
            y = -10.0 + socketPoint.getY();
        }
        x = (double)(-this.getAbstractWidth()) + x;
        this.setPixelLocation(this.rescale(x), this.rescale(y));
    }

    protected void textChanged(String text) {
        if (this.socket != null) {
            this.socket.setLabel(text);
            super.textChanged(text);
        }
    }
}

