/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblockutil.CToolTip;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockStackSorterUtil;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.PageJComponent;
import edu.mit.blocks.workspace.RBParent;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
implements WorkspaceWidget,
SearchableContainer,
ISupportMemento {
    private static final int COLLAPSED_WIDTH = 20;
    private static final int DEFAULT_MINUMUM_WIDTH = 100;
    private static final int DEFAULT_ABSTRACT_WIDTH = 700;
    public static final int DEFAULT_ABSTRACT_HEIGHT = 1600;
    private static final String emptyString = "";
    static double zoom = 1.0;
    private final PageJComponent pageJComponent = new PageJComponent();
    private double abstractWidth;
    private double abstractHeight;
    private String pageDrawer;
    private final Color defaultColor;
    private boolean mouseIsInPage = false;
    private int minimumPixelWidth = 0;
    private boolean fullview;
    private CollapseButton collapse;
    private String pageId = null;
    private boolean hideMinimize = false;

    public Page(String name, int pageWidth, int pageHeight, String pageDrawer) {
        this(name, pageWidth, pageHeight, pageDrawer, true, null);
    }

    public Page(String name, int pageWidth, int pageHeight, String pageDrawer, boolean inFullview, Color defaultColor) {
        this.defaultColor = defaultColor;
        this.pageJComponent.setLayout(null);
        this.pageJComponent.setName(name);
        this.abstractWidth = pageWidth > 0 ? (double)pageWidth : 700.0;
        this.abstractHeight = 1600.0;
        if (pageDrawer != null) {
            this.pageDrawer = pageDrawer;
        } else if (Workspace.everyPageHasDrawer) {
            this.pageDrawer = name;
        }
        this.pageJComponent.setOpaque(true);
        this.fullview = inFullview;
        this.collapse = new CollapseButton(inFullview, name);
        this.pageJComponent.add(this.collapse);
        this.pageJComponent.setFullView(inFullview);
    }

    public void disableMinimize() {
        this.hideMinimize = true;
        this.collapse.repaint();
    }

    public void enableMinimize() {
        this.hideMinimize = false;
        this.collapse.repaint();
    }

    public void setHide(boolean hide) {
        this.hideMinimize = hide;
        this.collapse.repaint();
    }

    public Page(String name) {
        this(name, -1, -1, name);
    }

    public static Page getBlankPage() {
        return new Page(emptyString);
    }

    public void reset() {
        this.pageJComponent.removeAll();
        zoom = 1.0;
    }

    public void clearPage() {
        for (RenderableBlock block : this.getBlocks()) {
            this.pageJComponent.remove(block);
        }
    }

    public void setPageId(String id) {
        if (this.pageId != null) {
            throw new RuntimeException("Tried to set pageId again: " + this);
        }
        this.pageId = id;
    }

    public Collection<RenderableBlock> getBlocks() {
        ArrayList<RenderableBlock> blocks = new ArrayList<RenderableBlock>();
        for (Component block : this.pageJComponent.getComponents()) {
            if (!(block instanceof RenderableBlock)) continue;
            blocks.add((RenderableBlock)block);
        }
        return blocks;
    }

    public Collection<RenderableBlock> getTopLevelBlocks() {
        ArrayList<RenderableBlock> topBlocks = new ArrayList<RenderableBlock>();
        for (RenderableBlock renderable : this.getBlocks()) {
            Block block = Block.getBlock(renderable.getBlockID());
            if (block.getPlug() != null && block.getPlugBlockID() != null && !block.getPlugBlockID().equals(Block.NULL) || block.getBeforeConnector() != null && block.getBeforeBlockID() != null && !block.getBeforeBlockID().equals(Block.NULL)) continue;
            topBlocks.add(renderable);
        }
        return topBlocks;
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPageName() {
        return this.pageJComponent.getName();
    }

    public Color getPageColor() {
        return this.pageJComponent.getBackground();
    }

    public Color getDefaultPageColor() {
        return this.defaultColor;
    }

    public double getAbstractWidth() {
        return this.abstractWidth;
    }

    public double getAbstractHeight() {
        return this.abstractHeight;
    }

    public String getPageDrawer() {
        return this.pageDrawer;
    }

    public Image getIcon() {
        return this.pageJComponent.getImage();
    }

    public boolean isInFullview() {
        return this.fullview;
    }

    public void setPageName(String newName) {
        if (this.pageDrawer.equals(this.pageJComponent.getName())) {
            this.pageDrawer = newName;
        }
        this.pageJComponent.setName(newName);
        this.collapse.setText(newName);
        for (RenderableBlock block : this.getBlocks()) {
            if (!Block.getBlock(block.getBlockID()).isPageLabelSetByPage()) continue;
            Block.getBlock(block.getBlockID()).setPageLabel(this.getPageName());
            block.repaintBlock();
        }
        PageChangeEventManager.notifyListeners();
    }

    public void setIcon(Image image) {
        this.pageJComponent.setImage(image);
    }

    public void setPageColor(Color newColor) {
        this.pageJComponent.setBackground(newColor);
    }

    public void addPixelWidth(int deltaPixelWidth) {
        if (this.fullview) {
            this.setPixelWidth((int)(this.getAbstractWidth() * zoom + (double)deltaPixelWidth));
        }
    }

    public void setPixelWidth(int pixelWidth) {
        this.abstractWidth = pixelWidth < this.minimumPixelWidth ? (double)this.minimumPixelWidth / zoom : (double)pixelWidth / zoom;
    }

    public int reformBounds(double pixelXCor) {
        if (this.fullview) {
            this.getJComponent().setBounds((int)pixelXCor, 0, (int)(this.abstractWidth * zoom), (int)(this.abstractHeight * zoom));
            this.getJComponent().setFont(new Font("Ariel", 0, (int)(12.0 * zoom)));
            return (int)(this.abstractWidth * zoom);
        }
        this.getJComponent().setBounds((int)pixelXCor, 0, 22, (int)(this.abstractHeight * zoom));
        this.getJComponent().setFont(new Font("Ariel", 0, (int)(12.0 * zoom)));
        return 22;
    }

    public void reformBlockPosition(RenderableBlock block) {
        Point p = SwingUtilities.convertPoint(block.getParent(), block.getLocation(), this.pageJComponent);
        if (p.x < block.getHighlightStrokeWidth() / 2 + 1) {
            block.setLocation(block.getHighlightStrokeWidth() / 2 + 1, p.y);
            block.moveConnectedBlocks();
            p = SwingUtilities.convertPoint(block.getParent(), block.getLocation(), this.pageJComponent);
        } else if (p.x + block.getWidth() + block.getHighlightStrokeWidth() / 2 + 1 > this.pageJComponent.getWidth()) {
            this.setPixelWidth(p.x + block.getWidth() + block.getHighlightStrokeWidth() / 2 + 1);
        }
        if (p.y < block.getHighlightStrokeWidth() / 2 + 1) {
            block.setLocation(p.x, block.getHighlightStrokeWidth() / 2 + 1);
            block.moveConnectedBlocks();
        } else if (p.y + block.getStackBounds().height + block.getHighlightStrokeWidth() / 2 + 1 > this.pageJComponent.getHeight()) {
            block.setLocation(p.x, this.pageJComponent.getHeight() - block.getStackBounds().height - block.getHighlightStrokeWidth() / 2 + 1);
            block.moveConnectedBlocks();
        }
        if (block.hasComment()) {
            p = block.getComment().getLocation();
            if (p.x + block.getComment().getWidth() + 1 > this.pageJComponent.getWidth()) {
                this.setPixelWidth(p.x + block.getComment().getWidth() + 1);
            }
        }
        PageChangeEventManager.notifyListeners();
    }

    public void reformMinimumPixelWidth() {
        this.minimumPixelWidth = 0;
        for (RenderableBlock b : this.getBlocks()) {
            if (b.getX() + b.getWidth() + b.getHighlightStrokeWidth() / 2 > this.minimumPixelWidth) {
                this.minimumPixelWidth = b.getX() + b.getWidth() + b.getHighlightStrokeWidth() / 2 + 1;
            }
            if (!b.hasComment() || b.getComment().getX() + b.getComment().getWidth() <= this.minimumPixelWidth) continue;
            this.minimumPixelWidth = b.getComment().getX() + b.getComment().getWidth() + 1;
        }
        if ((double)this.minimumPixelWidth < 100.0 * zoom) {
            this.minimumPixelWidth = (int)(100.0 * zoom);
        }
    }

    public void reformBlockOrdering() {
        BlockStackSorterUtil.sortBlockStacks(this, this.getTopLevelBlocks());
    }

    public static void setZoomLevel(double newZoom) {
        zoom = newZoom;
    }

    public static double getZoomLevel() {
        return zoom;
    }

    @Override
    public void blockDropped(RenderableBlock block) {
        Container oldParent = block.getParent();
        block.setLocation(SwingUtilities.convertPoint(oldParent, block.getLocation(), this.pageJComponent));
        this.addBlock(block);
        this.pageJComponent.setComponentZOrder(block, 0);
        this.pageJComponent.revalidate();
    }

    @Override
    public void blockDragged(RenderableBlock block) {
        if (!this.mouseIsInPage) {
            this.mouseIsInPage = true;
            this.pageJComponent.repaint();
        }
    }

    @Override
    public void blockEntered(RenderableBlock block) {
        if (!this.mouseIsInPage) {
            this.mouseIsInPage = true;
            this.pageJComponent.repaint();
        }
    }

    @Override
    public void blockExited(RenderableBlock block) {
        this.mouseIsInPage = false;
        this.pageJComponent.repaint();
    }

    @Override
    public void addBlock(RenderableBlock block) {
        WorkspaceWidget oldParent = block.getParentWidget();
        if (oldParent != this) {
            if (oldParent != null) {
                oldParent.removeBlock(block);
                if (block.hasComment()) {
                    block.getComment().getParent().remove(block.getComment());
                }
            }
            block.setParentWidget(this);
            if (block.hasComment()) {
                block.getComment().setParent(block.getParentWidget().getJComponent());
            }
        }
        this.getRBParent().addToBlockLayer(block);
        block.setHighlightParent(this.getRBParent());
        if (Block.getBlock(block.getBlockID()).isPageLabelSetByPage()) {
            Block.getBlock(block.getBlockID()).setPageLabel(this.getPageName());
        }
        block.linkDefArgs();
        if (oldParent != this) {
            Workspace.getInstance().notifyListeners(new WorkspaceEvent(oldParent, block.getBlockID(), 11));
            Workspace.getInstance().notifyListeners(new WorkspaceEvent((WorkspaceWidget)this, block.getBlockID(), 3, true));
        }
        this.reformBlockPosition(block);
        this.pageJComponent.setComponentZOrder(block, 0);
    }

    @Override
    public void addBlocks(Collection<RenderableBlock> blocks) {
        for (RenderableBlock block : blocks) {
            this.addBlock(block);
        }
        this.pageJComponent.revalidate();
    }

    @Override
    public void removeBlock(RenderableBlock block) {
        this.pageJComponent.remove(block);
    }

    @Override
    public JComponent getJComponent() {
        return this.pageJComponent;
    }

    public RBParent getRBParent() {
        return this.pageJComponent;
    }

    @Override
    public boolean contains(int x, int y) {
        return this.pageJComponent.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public String toString() {
        return "Page name: " + this.getPageName() + " page color " + this.getPageColor() + " page width " + this.getAbstractWidth() + " page drawer " + this.pageDrawer;
    }

    public Iterable<RenderableBlock> getSearchableElements() {
        return this.getBlocks();
    }

    @Override
    public void updateContainsSearchResults(boolean containsSearchResults) {
    }

    public ArrayList<RenderableBlock> loadPageFrom(Node pageNode, boolean importingPage) {
        HashMap<Long, Long> idMapping;
        NodeList pageChildren = pageNode.getChildNodes();
        ArrayList<RenderableBlock> loadedBlocks = new ArrayList<RenderableBlock>();
        HashMap<Long, Long> hashMap = idMapping = importingPage ? new HashMap<Long, Long>() : null;
        if (importingPage) {
            this.reset();
        }
        for (int i = 0; i < pageChildren.getLength(); ++i) {
            Node pageChild = pageChildren.item(i);
            if (!pageChild.getNodeName().equals("PageBlocks")) continue;
            NodeList blocks = pageChild.getChildNodes();
            for (int j = 0; j < blocks.getLength(); ++j) {
                Node blockNode = blocks.item(j);
                RenderableBlock rb = RenderableBlock.loadBlockNode(blockNode, this, idMapping);
                loadedBlocks.add(rb);
            }
            break;
        }
        return loadedBlocks;
    }

    public void addLoadedBlocks(Collection<RenderableBlock> loadedBlocks, boolean importingPage) {
        for (RenderableBlock rb : loadedBlocks) {
            if (rb == null) continue;
            this.getRBParent().addToBlockLayer(rb);
            rb.setHighlightParent(this.getRBParent());
            Workspace.getInstance().notifyListeners(new WorkspaceEvent((WorkspaceWidget)this, rb.getBlockID(), 3));
            if (!importingPage) continue;
            Block.getBlock(rb.getBlockID()).setFocus(false);
            rb.resetHighlight();
            rb.clearBufferedImage();
        }
        for (RenderableBlock rb : this.getTopLevelBlocks()) {
            rb.redrawFromTop();
            if (!rb.isCollapsed()) continue;
            rb.updateCollapse();
        }
        this.pageJComponent.revalidate();
        this.pageJComponent.repaint();
    }

    public Node getSaveNode(Document document) {
        Iterable blocks;
        Element pageElement = document.createElement("Page");
        pageElement.setAttribute("page-name", this.getPageName());
        pageElement.setAttribute("page-color", this.getPageColor().getRed() + " " + this.getPageColor().getGreen() + " " + this.getPageColor().getBlue());
        pageElement.setAttribute("page-width", String.valueOf((int)this.getAbstractWidth()));
        if (this.fullview) {
            pageElement.setAttribute("page-infullview", "yes");
        } else {
            pageElement.setAttribute("page-infullview", "no");
        }
        if (this.pageDrawer != null) {
            pageElement.setAttribute("page-drawer", this.pageDrawer);
        }
        if (this.pageId != null) {
            pageElement.setAttribute("page-id", this.pageId);
        }
        if ((blocks = this.getBlocks()).size() > 0) {
            Element pageBlocksElement = document.createElement("PageBlocks");
            for (RenderableBlock rb : blocks) {
                pageBlocksElement.appendChild(rb.getSaveNode(document));
            }
            pageElement.appendChild(pageBlocksElement);
        }
        return pageElement;
    }

    @Override
    public Object getState() {
        PageState state = new PageState();
        state.name = this.getPageName();
        state.id = this.getPageId();
        state.color = this.getPageColor();
        state.width = this.pageJComponent.getWidth();
        for (RenderableBlock rb : this.getBlocks()) {
            state.renderableBlocks.put(rb.getBlockID(), rb.getState());
        }
        return state;
    }

    @Override
    public void loadState(Object memento) {
        assert (memento instanceof PageState) : "ISupportMemento contract violated in Page";
        if (memento instanceof PageState) {
            PageState state = (PageState)memento;
            this.setPageName(state.name);
            this.setPageId(state.id);
            this.setPageColor(state.color);
            this.setPixelWidth(state.width);
            Map<Long, Object> renderableBlockStates = state.renderableBlocks;
            LinkedList<Long> unloadedRenderableBlockStates = new LinkedList<Long>();
            LinkedList<Long> loadedBlocks = new LinkedList<Long>();
            for (Long id : renderableBlockStates.keySet()) {
                unloadedRenderableBlockStates.add(id);
            }
            for (RenderableBlock existingBlock : this.getBlocks()) {
                Long existingBlockID = existingBlock.getBlockID();
                if (!renderableBlockStates.containsKey(existingBlockID)) continue;
                existingBlock.loadState(renderableBlockStates.get(existingBlockID));
                unloadedRenderableBlockStates.remove(existingBlockID);
                loadedBlocks.add(existingBlockID);
            }
            ArrayList<RenderableBlock> blocksToRemove = new ArrayList<RenderableBlock>();
            for (RenderableBlock existingBlock : this.getBlocks()) {
                Long existingBlockID = existingBlock.getBlockID();
                if (loadedBlocks.contains(existingBlockID)) continue;
                blocksToRemove.add(existingBlock);
            }
            for (RenderableBlock toBeRemovedBlock : blocksToRemove) {
                this.removeBlock(toBeRemovedBlock);
            }
            ArrayList<RenderableBlock> blocksToAdd = new ArrayList<RenderableBlock>();
            for (Long newBlockID : unloadedRenderableBlockStates) {
                RenderableBlock newBlock = new RenderableBlock(this, newBlockID);
                newBlock.loadState(renderableBlockStates.get(newBlockID));
                blocksToAdd.add(newBlock);
            }
            this.addBlocks(blocksToAdd);
            this.pageJComponent.repaint();
        }
    }

    private class CollapseButton
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 328149080273L;
        private final int[][] shadowPositionArray = new int[][]{{0, -1}, {1, -1}, {-1, 0}, {2, 0}, {-1, 1}, {1, 1}, {0, 2}, {1, 0}, {0, 1}};
        private final float[] shadowColorArray = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f};
        private double offsetSize = 1.0;
        private String[] charSet;
        private int FONT_SIZE = 12;
        private boolean pressed = false;
        private boolean focus = false;
        private String button_text = "";

        public CollapseButton(boolean inFullview, String text) {
            this.addMouseListener(this);
            this.setOpaque(false);
            this.charSet = new String[0];
            this.setFont(new Font("Ariel", 1, this.FONT_SIZE));
            this.setText(text);
            this.loadBounds(inFullview);
        }

        public JToolTip createToolTip() {
            return new CToolTip(new Color(0xFFFFDD));
        }

        public void setText(String text) {
            if (text != null) {
                text = text.toUpperCase();
                ArrayList<String> characters = new ArrayList<String>();
                for (int i = 0; i < text.length(); ++i) {
                    characters.add(text.substring(i, i + 1));
                }
                this.charSet = characters.toArray(this.charSet);
                this.button_text = text;
            }
        }

        private void paintFull(Graphics g) {
            this.paintFull(g, Color.white);
        }

        private void paintCollapsed(Graphics g) {
            this.paintCollapsed(g, Color.white);
        }

        private void paintFull(Graphics g, Color col) {
            int w = this.getWidth();
            g.setColor(col);
            g.fillRect(5, 5, w - 10, w - 17);
            g.setColor(col);
            g.drawRoundRect(3, 3, w - 6, w - 6, 3, 3);
        }

        private void paintCollapsed(Graphics g, Color col) {
            int w = this.getWidth();
            g.setColor(col);
            g.fillRect(5, 5, w - 10, w - 15);
            Graphics2D g2 = (Graphics2D)g;
            for (int j = 0; j < this.charSet.length; ++j) {
                String c = this.charSet[j];
                int x = 5;
                int y = (j + 2) * (this.FONT_SIZE + 3);
                g.setColor(Color.black);
                for (int i = 0; i < this.shadowPositionArray.length; ++i) {
                    int dx = this.shadowPositionArray[i][0];
                    int dy = this.shadowPositionArray[i][1];
                    g2.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowColorArray[i]));
                    g2.drawString(c, x + (int)((double)dx * this.offsetSize), y + (int)((double)dy * this.offsetSize));
                }
                g2.setColor(col);
                g2.drawString(c, x, y);
            }
            g2.drawRoundRect(3, 3, w - 6, w - 6 + this.charSet.length * (this.FONT_SIZE + 3), 3, 3);
        }

        public void paintComponent(Graphics g) {
            int w = this.getWidth();
            if (!Page.this.hideMinimize) {
                if (Page.this.fullview) {
                    this.setToolTipText("Collapse " + this.button_text);
                    this.paintFull(g);
                    if (this.pressed) {
                        g.setColor(Color.blue.darker());
                        g.fillRoundRect(3, 3, w - 6, w - 6, 3, 3);
                        this.paintFull(g);
                    } else if (this.focus) {
                        g.setColor(new Color(51, 153, 255));
                        g.fillRoundRect(3, 3, w - 6, w - 6, 3, 3);
                        this.paintFull(g);
                    }
                } else {
                    this.setToolTipText("Restore " + this.button_text);
                    this.paintCollapsed(g);
                    if (this.pressed) {
                        g.setColor(Color.blue.darker());
                        g.fillRoundRect(3, 3, w - 6, w - 6 + this.charSet.length * (this.FONT_SIZE + 3), 3, 3);
                        this.paintCollapsed(g);
                    } else if (this.focus) {
                        g.setColor(new Color(51, 153, 255));
                        g.fillRoundRect(3, 3, w - 6, w - 6 + this.charSet.length * (this.FONT_SIZE + 3), 3, 3);
                        this.paintCollapsed(g);
                    }
                }
            } else if (Page.this.fullview) {
                this.paintFull(g, Color.gray);
            } else {
                this.paintCollapsed(g, Color.gray);
            }
        }

        private void loadBounds(boolean fullview) {
            if (!fullview) {
                this.setBounds(0, 0, 20, this.charSet.length * (this.FONT_SIZE + 3) + 20);
            } else {
                this.setBounds(0, 0, 20, 20);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (!Page.this.hideMinimize) {
                if (Page.this.fullview) {
                    this.setBounds(0, 0, 20, this.charSet.length * (this.FONT_SIZE + 3) + 20);
                } else {
                    this.setBounds(0, 0, 20, 20);
                }
                Page.this.fullview = !Page.this.fullview;
                Page.this.pageJComponent.setFullView(Page.this.fullview);
                PageChangeEventManager.notifyListeners();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!Page.this.hideMinimize) {
                this.pressed = true;
                this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (!Page.this.hideMinimize) {
                this.pressed = false;
                this.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (!Page.this.hideMinimize) {
                this.focus = true;
                this.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!Page.this.hideMinimize) {
                this.focus = false;
                this.repaint();
            }
        }
    }

    private class PageState {
        public String name;
        public String id;
        public int width;
        public Color color;
        public boolean fullview;
        public Map<Long, Object> blocks = new HashMap<Long, Object>();
        public Map<Long, Object> renderableBlocks = new HashMap<Long, Object>();

        private PageState() {
        }
    }
}

