/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class PageDivider
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 328149080272L;
    private static final Color DIVIDER_COLOR = Color.GRAY;
    private final Page leftPage;
    private boolean mouseIn = false;
    private boolean dragDone = false;
    private int mPressedX;

    public PageDivider(Page left) {
        this.leftPage = left;
        this.setCursor(new Cursor(11));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Page getLeftPage() {
        return this.leftPage;
    }

    public void paintComponent(Graphics g) {
        g.setColor(DIVIDER_COLOR);
        g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
        if (this.mouseIn) {
            g.fillRect(this.getWidth() / 2 - 1, 0, 3, this.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mPressedX = e.getX();
        this.leftPage.reformMinimumPixelWidth();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragDone) {
            Workspace.getInstance().notifyListeners(new WorkspaceEvent((WorkspaceWidget)this.leftPage, 9, true));
            this.dragDone = false;
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.leftPage.addPixelWidth(e.getX() - this.mPressedX);
        this.dragDone = true;
        PageChangeEventManager.notifyListeners();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

