/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ReundoManager
implements WorkspaceListener {
    private List<ISupportMemento> managedClasses = new ArrayList<ISupportMemento>();
    private List<Object> currentStateMemento;
    private Stack<List<Object>> undoMementoStack;
    private Stack<List<Object>> redoMementoStack;
    private boolean lock = false;

    public ReundoManager(ISupportMemento managedClass) {
        this.managedClasses.add(managedClass);
        this.reset();
    }

    public void reset() {
        this.undoMementoStack = new Stack();
        this.redoMementoStack = new Stack();
        this.currentStateMemento = null;
    }

    public void addManagedClass(ISupportMemento anotherManagedClass) {
        this.managedClasses.add(anotherManagedClass);
    }

    public void workspaceEventOccurred(WorkspaceEvent event) {
        if (!this.lock && event.isUserEvent()) {
            if (this.currentStateMemento != null) {
                this.undoMementoStack.add(this.currentStateMemento);
            }
            this.currentStateMemento = new ArrayList<Object>();
            for (ISupportMemento managedClass : this.managedClasses) {
                this.currentStateMemento.add(managedClass.getState());
            }
        }
    }

    public void undo() {
        if (this.canUndo() && !this.lock) {
            this.lock = true;
            List<Object> olderStates = this.undoMementoStack.pop();
            Iterator<Object> olderStatesIterator = olderStates.iterator();
            for (ISupportMemento managedClass : this.managedClasses) {
                managedClass.loadState(olderStatesIterator.next());
            }
            this.redoMementoStack.push(this.currentStateMemento);
            this.currentStateMemento = olderStates;
            this.lock = false;
        }
    }

    public void redo() {
        if (this.canRedo() && !this.lock) {
            this.lock = true;
            this.lock = false;
        }
    }

    public boolean canUndo() {
        return this.undoMementoStack.size() > 0;
    }

    public boolean canRedo() {
        return this.redoMementoStack.size() > 0;
    }

    public String getUndoText() {
        return "";
    }

    public String getRedoText() {
        return "";
    }
}

